/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.context.CommerceContextThreadLocal;
import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class CommerceContextPreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextPreAction.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceContextFactory _commerceContextFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block3: {
            try {
                CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
                if (commerceChannel == null) {
                    return;
                }
                CommerceContext commerceContext = this._commerceContextFactory.create(httpServletRequest);
                httpServletRequest.setAttribute("COMMERCE_CONTEXT", (Object)commerceContext);
                CommerceContextThreadLocal.set((CommerceContext)commerceContext);
                CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(commerceChannel.getGroupId()));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
    }
}

