/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.service.base.CPDAvailabilityEstimateServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CPDAvailabilityEstimate"}, service={AopService.class})
public class CPDAvailabilityEstimateServiceImpl
extends CPDAvailabilityEstimateServiceBaseImpl {
    @Reference
    protected CommerceCatalogLocalService commerceCatalogLocalService;
    @Reference
    protected CPDefinitionLocalService cpDefinitionLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceCatalog)")
    private ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission;

    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCPDefinitionId(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCProductId(cpDefinition.getCProductId());
    }

    public CPDAvailabilityEstimate updateCPDAvailabilityEstimate(long cpdAvailabilityEstimateId, long cpDefinitionId, long commerceAvailabilityEstimateId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.cpdAvailabilityEstimateLocalService.updateCPDAvailabilityEstimateByCProductId(this.getUserId(), cpdAvailabilityEstimateId, cpDefinition.getCProductId(), commerceAvailabilityEstimateId);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        this._commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

