/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_9_4;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;

public class CommerceOrderUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceOrderUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    public void doUpgrade() throws Exception {
        this._updateCommerceOrder();
        this._updateOperationsManagerPermission();
    }

    private void _updateCommerceOrder() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommerceOrder.class.getName(), Collections.singletonList("VIEW"), true);
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select companyId, commerceOrderId from CommerceOrder");){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                Company company = this._companyLocalService.getCompany(companyId);
                long commerceOrderId = resultSet.getLong("commerceOrderId");
                this._resourceLocalService.updateResources(companyId, company.getGroupId(), CommerceOrder.class.getName(), commerceOrderId, new String[]{"VIEW"}, new String[]{"VIEW"});
            }
        }
    }

    private void _updateOperationsManagerPermission() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            Role role = this._roleLocalService.fetchRole(companyId.longValue(), "Operations Manager");
            if (role == null) {
                return;
            }
            this._resourcePermissionLocalService.addResourcePermission(companyId.longValue(), CommerceOrder.class.getName(), 1, String.valueOf(0L), role.getRoleId(), "VIEW");
        });
    }
}

