/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Indexer.class})
public class CommerceOrderItemIndexer
extends BaseIndexer<CommerceOrderItem> {
    public static final String CLASS_NAME = CommerceOrderItem.class.getName();
    public static final String FIELD_COMMERCE_ORDER_ID = "commerceOrderId";
    public static final String FIELD_CP_DEFINITION_ID = "CPDefinitionId";
    public static final String FIELD_FINAL_PRICE = "finalPrice";
    public static final String FIELD_PARENT_COMMERCE_ORDER_ITEM_ID = "parentCommerceOrderItemId";
    public static final String FIELD_QUANTITY = "quantity";
    public static final String FIELD_SKU = "sku";
    public static final String FIELD_UNIT_PRICE = "unitPrice";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemIndexer.class);
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Long parentCommerceOrderItemId;
        Long commerceOrderId = (Long)searchContext.getAttribute(FIELD_COMMERCE_ORDER_ID);
        if (commerceOrderId != null) {
            contextBooleanFilter.addRequiredTerm(FIELD_COMMERCE_ORDER_ID, commerceOrderId);
        }
        if ((parentCommerceOrderItemId = (Long)searchContext.getAttribute(FIELD_PARENT_COMMERCE_ORDER_ITEM_ID)) != null) {
            contextBooleanFilter.addRequiredTerm(FIELD_PARENT_COMMERCE_ORDER_ITEM_ID, parentCommerceOrderItemId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String keywords;
        String expandoAttributes;
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", true);
        this.addSearchTerm(searchQuery, searchContext, FIELD_SKU, false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
        if (Validator.isNotNull((String)(keywords = searchContext.getKeywords()))) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                searchQuery.add((Query)this._getTrailingWildcardQuery(FIELD_SKU, keywords), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    protected void doDelete(CommerceOrderItem commerceOrderItem) throws Exception {
        this.deleteDocument(commerceOrderItem.getCompanyId(), commerceOrderItem.getCommerceOrderItemId());
    }

    protected Document doGetDocument(CommerceOrderItem commerceOrderItem) throws Exception {
        CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce order item " + commerceOrderItem));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceOrderItem);
        document.addLocalizedKeyword("name", commerceOrderItem.getNameMap(), false, true);
        document.addNumber(FIELD_COMMERCE_ORDER_ID, commerceOrderItem.getCommerceOrderId());
        document.addKeyword(FIELD_CP_DEFINITION_ID, commerceOrderItem.getCPDefinitionId());
        document.addNumber(FIELD_FINAL_PRICE, commerceOrderItem.getFinalPrice());
        document.addNumber(FIELD_PARENT_COMMERCE_ORDER_ITEM_ID, commerceOrderItem.getParentCommerceOrderItemId());
        document.addNumber(FIELD_QUANTITY, commerceOrderItem.getQuantity());
        document.addNumberSortable(FIELD_QUANTITY, commerceOrderItem.getQuantity());
        document.addKeyword(FIELD_SKU, commerceOrderItem.getSku());
        document.addKeywordSortable(FIELD_SKU, commerceOrderItem.getSku());
        document.addNumber(FIELD_UNIT_PRICE, commerceOrderItem.getUnitPrice());
        String unitOfMeasureKey = commerceOrderItem.getUnitOfMeasureKey();
        if (Validator.isNotNull((String)unitOfMeasureKey) && (cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(commerceOrderItem.getCPInstanceId(), unitOfMeasureKey)) != null) {
            document.addLocalizedText("cpInstanceUnitOfMeasure", cpInstanceUnitOfMeasure.getNameMap(), true);
        }
        this._expandoBridgeIndexer.addAttributes(document, commerceOrderItem.getExpandoBridge());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Commerce order item " + commerceOrderItem + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceOrderItem commerceOrderItem) throws Exception {
        this._indexWriterHelper.updateDocument(commerceOrderItem.getCompanyId(), this.getDocument(commerceOrderItem));
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceOrderItemLocalService.getCommerceOrderItem(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexCommerceOrderItems(companyId);
    }

    private WildcardQuery _getTrailingWildcardQuery(String field, String value) {
        return new WildcardQueryImpl(field, value + "*");
    }

    private void _reindexCommerceOrderItems(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceOrderItemLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceOrderItem -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceOrderItem)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce order item " + commerceOrderItem), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

