/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.term.evaluator;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;

public class CommerceOrderItemsNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final CommerceMediaResolver _commerceMediaResolver;
    private final CommerceMoneyFactory _commerceMoneyFactory;
    private final CommerceOrderItemQuantityFormatter _commerceOrderItemQuantityFormatter;
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    private final CompanyLocalService _companyLocalService;
    private final CPDefinitionLocalService _cpDefinitionLocalService;
    private final CPInstanceHelper _cpInstanceHelper;
    private final CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    private final Language _language;
    private final ObjectDefinition _objectDefinition;
    private final UserLocalService _userLocalService;

    public CommerceOrderItemsNotificationTermEvaluator(CommerceMediaResolver commerceMediaResolver, CommerceMoneyFactory commerceMoneyFactory, CommerceOrderItemQuantityFormatter commerceOrderItemQuantityFormatter, CommerceOrderLocalService commerceOrderLocalService, CommerceOrderPriceCalculation commerceOrderPriceCalculation, CompanyLocalService companyLocalService, CPDefinitionLocalService cpDefinitionLocalService, CPInstanceUnitOfMeasureLocalService cpInstanceUnitOfMeasureLocalService, CPInstanceHelper cpInstanceHelper, Language language, ObjectDefinition objectDefinition, UserLocalService userLocalService) {
        this._commerceMediaResolver = commerceMediaResolver;
        this._commerceMoneyFactory = commerceMoneyFactory;
        this._commerceOrderItemQuantityFormatter = commerceOrderItemQuantityFormatter;
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._commerceOrderPriceCalculation = commerceOrderPriceCalculation;
        this._companyLocalService = companyLocalService;
        this._cpDefinitionLocalService = cpDefinitionLocalService;
        this._cpInstanceUnitOfMeasureLocalService = cpInstanceUnitOfMeasureLocalService;
        this._cpInstanceHelper = cpInstanceHelper;
        this._language = language;
        this._objectDefinition = objectDefinition;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map && termName.equals("[%COMMERCEORDER_ORDER_ITEMS%]") && "CommerceOrder".equalsIgnoreCase(this._objectDefinition.getShortName()))) {
            return termName;
        }
        UnsyncStringWriter writer = new UnsyncStringWriter();
        Class<?> clazz = this.getClass();
        URL url = clazz.getResource("dependencies/commerce_order_order_items.ftl");
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new URLTemplateResource(url.getPath(), url), (boolean)false);
        Map termValues = (Map)object;
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(GetterUtil.getLong(termValues.get("id")));
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        Locale locale = user.getLocale();
        template.put((Object)"orderItems", (Object)TransformUtil.transform((Collection)commerceOrder.getCommerceOrderItems(), commerceOrderItem -> this._getOrderItem((CommerceOrderItem)commerceOrderItem, commerceOrder.getCommerceCurrency(), locale, company.getPortalURL(commerceOrder.getGroupId()))));
        template.put((Object)"optionLabel", (Object)this._language.get(locale, "option"));
        template.put((Object)"qtyLabel", (Object)this._language.get(locale, "qty"));
        template.put((Object)"skuLabel", (Object)this._language.get(locale, "sku"));
        template.put((Object)"tableLabel", (Object)this._language.get(locale, "order-items"));
        template.put((Object)"uomLabel", (Object)this._language.get(locale, "uom"));
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    private Map<String, Object> _getOrderItem(CommerceOrderItem commerceOrderItem, CommerceCurrency commerceCurrency, Locale locale, String portalURL) throws PortalException {
        return HashMapBuilder.put((Object)"finalPrice", () -> {
            CommerceOrderItemPrice commerceOrderItemPrice = this._commerceOrderPriceCalculation.getCommerceOrderItemPrice(commerceCurrency, commerceOrderItem);
            CommerceMoney finalPriceCommerceMoney = commerceOrderItemPrice.getFinalPrice();
            return finalPriceCommerceMoney.format(locale);
        }).put((Object)"imageURL", () -> {
            CPAttachmentFileEntry cpAttachmentFileEntry = this._cpDefinitionLocalService.getDefaultImageCPAttachmentFileEntry(commerceOrderItem.getCPDefinitionId());
            long cpAttachmentFileEntryId = 0L;
            if (cpAttachmentFileEntry != null) {
                cpAttachmentFileEntryId = cpAttachmentFileEntry.getCPAttachmentFileEntryId();
            }
            if (cpAttachmentFileEntryId == 0L) {
                CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
                String defaultURL = this._commerceMediaResolver.getDefaultURL(cpDefinition.getGroupId());
                return portalURL + defaultURL;
            }
            String imageURL = this._commerceMediaResolver.getURL(-1L, cpAttachmentFileEntryId, false, false, false);
            return portalURL + imageURL;
        }).put((Object)"name", (Object)commerceOrderItem.getName(locale)).put((Object)"options", () -> {
            StringJoiner stringJoiner = new StringJoiner(", ");
            long commerceOrderItemCPDefinitionId = commerceOrderItem.getParentCommerceOrderItemCPDefinitionId();
            if (!commerceOrderItem.hasParentCommerceOrderItem()) {
                commerceOrderItemCPDefinitionId = commerceOrderItem.getCPDefinitionId();
            }
            List commerceOptionValueKeyValuePairs = this._cpInstanceHelper.getKeyValuePairs(commerceOrderItemCPDefinitionId, commerceOrderItem.getJson(), locale);
            for (KeyValuePair keyValuePair : commerceOptionValueKeyValuePairs) {
                stringJoiner.add(keyValuePair.getValue());
            }
            return stringJoiner.toString();
        }).put((Object)"originalPrice", () -> {
            BigDecimal discountAmount = commerceOrderItem.getDiscountAmount();
            BigDecimal finalPrice = commerceOrderItem.getFinalPrice();
            BigDecimal promoPrice = commerceOrderItem.getPromoPrice();
            if (discountAmount.compareTo(new BigDecimal(0)) > 0) {
                CommerceMoney originalPriceCommerceMoney = this._commerceMoneyFactory.create(commerceCurrency, finalPrice.add(discountAmount.multiply(commerceOrderItem.getQuantity())));
                return originalPriceCommerceMoney.format(locale);
            }
            if (promoPrice.compareTo(new BigDecimal(0)) > 0) {
                CommerceMoney originalPriceCommerceMoney = this._commerceMoneyFactory.create(commerceCurrency, finalPrice.add(promoPrice.multiply(commerceOrderItem.getQuantity())));
                return originalPriceCommerceMoney.format(locale);
            }
            return "";
        }).put((Object)"qty", (Object)this._commerceOrderItemQuantityFormatter.format(commerceOrderItem, this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(commerceOrderItem.getCPInstanceId(), commerceOrderItem.getUnitOfMeasureKey()), locale)).put((Object)"sku", (Object)commerceOrderItem.getSku()).put((Object)"uom", (Object)commerceOrderItem.getUnitOfMeasureKey()).build();
    }
}

