/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.ListUtil;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CommerceOrderModelListener
extends BaseModelListener<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelListener.class);
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    public void onAfterUpdate(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder) {
        block3: {
            try {
                if (commerceOrder.getOrderStatus() == 15) {
                    this._commerceOrderEngine.checkCommerceOrderShipmentStatus(commerceOrder, true);
                }
                ListUtil.isNotEmptyForEach((List)originalCommerceOrder.getCustomerCommerceOrderIds(), customerCommerceOrderId -> {
                    block3: {
                        try {
                            CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(customerCommerceOrderId.longValue());
                            this._updateOrderStatus(originalCommerceOrder, commerceOrder, customerCommerceOrder);
                            if (this._updateShippingAmount(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateShippingDiscountAmount(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateSubtotal(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateSubtotalDiscountAmount(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateTaxAmount(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateTotal(originalCommerceOrder, commerceOrder, customerCommerceOrder) || this._updateTotalDiscountAmount(originalCommerceOrder, commerceOrder, customerCommerceOrder)) {
                                this._commerceOrderLocalService.updateCommerceOrder(customerCommerceOrder);
                            }
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Throwable)portalException);
                        }
                    }
                });
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private boolean _transitionOrderStatusCompleted(CommerceOrder commerceOrder) throws PortalException {
        List supplierCommerceOrderIds = commerceOrder.getSupplierCommerceOrderIds();
        if (ListUtil.isEmpty((List)supplierCommerceOrderIds)) {
            return false;
        }
        Long firstSupplierCommerceOrderId = (Long)supplierCommerceOrderIds.get(0);
        CommerceOrder firstSupplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(firstSupplierCommerceOrderId.longValue());
        int orderStatus = firstSupplierCommerceOrder.getOrderStatus();
        if (supplierCommerceOrderIds.size() == 1 && orderStatus != commerceOrder.getOrderStatus()) {
            return true;
        }
        for (int i = 1; i < supplierCommerceOrderIds.size(); ++i) {
            CommerceOrder supplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(((Long)supplierCommerceOrderIds.get(i)).longValue());
            if (orderStatus == supplierCommerceOrder.getOrderStatus()) continue;
            return false;
        }
        return true;
    }

    private void _updateOrderStatus(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) throws PortalException {
        int newOrderStatus = commerceOrder.getOrderStatus();
        int originalOrderStatus = originalCommerceOrder.getOrderStatus();
        if (originalOrderStatus != newOrderStatus) {
            this._commerceOrderEngine.checkCommerceOrderShipmentStatus(customerCommerceOrder, false);
            if (newOrderStatus == 0 && this._transitionOrderStatusCompleted(customerCommerceOrder)) {
                this._commerceOrderEngine.transitionCommerceOrder(customerCommerceOrder, newOrderStatus, 0L, false);
            }
        }
    }

    private boolean _updateShippingAmount(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newShippingAmount;
        BigDecimal originalShippingAmount = originalCommerceOrder.getShippingAmount();
        int compareShippingAmount = originalShippingAmount.compareTo(newShippingAmount = commerceOrder.getShippingAmount());
        if (compareShippingAmount != 0) {
            BigDecimal customerShippingAmount = customerCommerceOrder.getShippingAmount();
            BigDecimal subtractOriginalValue = customerShippingAmount.subtract(originalShippingAmount);
            customerCommerceOrder.setShippingAmount(subtractOriginalValue.add(newShippingAmount));
            return true;
        }
        return false;
    }

    private boolean _updateShippingDiscountAmount(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newShippingDiscountAmount;
        BigDecimal originalShippingDiscountAmount = originalCommerceOrder.getShippingDiscountAmount();
        int compareShippingDiscountAmount = originalShippingDiscountAmount.compareTo(newShippingDiscountAmount = commerceOrder.getShippingDiscountAmount());
        if (compareShippingDiscountAmount != 0) {
            BigDecimal customerShippingDiscountAmount = customerCommerceOrder.getShippingDiscountAmount();
            BigDecimal subtractOriginalValue = customerShippingDiscountAmount.subtract(originalShippingDiscountAmount);
            customerCommerceOrder.setShippingDiscountAmount(subtractOriginalValue.add(newShippingDiscountAmount));
            return true;
        }
        return false;
    }

    private boolean _updateSubtotal(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newSubtotal;
        BigDecimal originalSubtotal = originalCommerceOrder.getSubtotal();
        int compareSubtotal = originalSubtotal.compareTo(newSubtotal = commerceOrder.getSubtotal());
        if (compareSubtotal != 0) {
            BigDecimal customerSubtotal = customerCommerceOrder.getSubtotal();
            BigDecimal subtractOriginalValue = customerSubtotal.subtract(originalSubtotal);
            customerCommerceOrder.setSubtotal(subtractOriginalValue.add(newSubtotal));
            return true;
        }
        return false;
    }

    private boolean _updateSubtotalDiscountAmount(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newSubtotalDiscountAmount;
        BigDecimal originalSubtotalDiscountAmount = originalCommerceOrder.getSubtotalDiscountAmount();
        int compareSubtotalDiscountAmount = originalSubtotalDiscountAmount.compareTo(newSubtotalDiscountAmount = commerceOrder.getSubtotalDiscountAmount());
        if (compareSubtotalDiscountAmount != 0) {
            BigDecimal customerSubtotalDiscountAmount = customerCommerceOrder.getSubtotalDiscountAmount();
            BigDecimal subtractOriginalValue = customerSubtotalDiscountAmount.subtract(originalSubtotalDiscountAmount);
            customerCommerceOrder.setSubtotalDiscountAmount(subtractOriginalValue.add(newSubtotalDiscountAmount));
            return true;
        }
        return false;
    }

    private boolean _updateTaxAmount(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newTaxAmount;
        BigDecimal originalTaxAmount = originalCommerceOrder.getTaxAmount();
        int compareTaxAmount = originalTaxAmount.compareTo(newTaxAmount = commerceOrder.getTaxAmount());
        if (compareTaxAmount != 0) {
            BigDecimal customerTaxAmount = customerCommerceOrder.getTaxAmount();
            BigDecimal subtractOriginalValue = customerTaxAmount.subtract(originalTaxAmount);
            customerCommerceOrder.setTaxAmount(subtractOriginalValue.add(newTaxAmount));
            return true;
        }
        return false;
    }

    private boolean _updateTotal(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newTotal;
        BigDecimal originalTotal = originalCommerceOrder.getTotal();
        int compareTotal = originalTotal.compareTo(newTotal = commerceOrder.getTotal());
        if (compareTotal != 0) {
            BigDecimal customerTotal = customerCommerceOrder.getTotal();
            BigDecimal subtractOriginalValue = customerTotal.subtract(originalTotal);
            customerCommerceOrder.setTotal(subtractOriginalValue.add(newTotal));
            return true;
        }
        return false;
    }

    private boolean _updateTotalDiscountAmount(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder, CommerceOrder customerCommerceOrder) {
        BigDecimal newTotalDiscountAmount;
        BigDecimal originalTotalDiscountAmount = originalCommerceOrder.getTotalDiscountAmount();
        int compareTotalDiscountAmount = originalTotalDiscountAmount.compareTo(newTotalDiscountAmount = commerceOrder.getTotalDiscountAmount());
        if (compareTotalDiscountAmount != 0) {
            BigDecimal customerTotalDiscountAmount = customerCommerceOrder.getTotalDiscountAmount();
            BigDecimal subtractOriginalValue = customerTotalDiscountAmount.subtract(originalTotalDiscountAmount);
            customerCommerceOrder.setTotalDiscountAmount(subtractOriginalValue.add(newTotalDiscountAmount));
            return true;
        }
        return false;
    }
}

