/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_5_0;

import com.liferay.account.constants.AccountListTypeConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class CommerceAddressTypeUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ListTypeLocalService _listTypeLocalService;

    public CommerceAddressTypeUpgradeProcess(CompanyLocalService companyLocalService, ListTypeLocalService listTypeLocalService) {
        this._companyLocalService = companyLocalService;
        this._listTypeLocalService = listTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            this._setAddressListType((long)companyId, this._getListTypeId((long)companyId, "billing"), 14000L);
            this._setAddressListType((long)companyId, this._getListTypeId((long)companyId, "shipping"), 14002L);
            this._setAddressListType((long)companyId, this._getListTypeId((long)companyId, "billing-and-shipping"), 14001L);
        });
    }

    private long _getListTypeId(long companyId, String name) {
        ListType listType = this._listTypeLocalService.getListType(companyId, name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        if (listType == null) {
            listType = this._listTypeLocalService.addListType(companyId, name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        }
        return listType.getListTypeId();
    }

    private void _setAddressListType(long companyId, long newListTypeId, long oldListTypeId) throws Exception {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"update Address set listTypeId = ", newListTypeId, " where companyId = ", companyId, " and listTypeId = ", oldListTypeId}));
    }
}

