/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v13_0_4;

import com.liferay.account.model.AccountGroup;
import com.liferay.commerce.product.model.CPConfigurationEntry;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPConfigurationEntryLocalService;
import com.liferay.commerce.product.service.CPConfigurationEntryLocalServiceUtil;
import com.liferay.commerce.product.service.CPConfigurationListLocalService;
import com.liferay.commerce.product.service.CPConfigurationListRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CPConfigurationListEligibilityUpgradeProcess
extends UpgradeProcess {
    private final CommerceChannelRelLocalService _commerceChannelRelLocalService;
    private final CPConfigurationEntryLocalService _cpConfigurationEntryLocalService;
    private final CPConfigurationListLocalService _cpConfigurationListLocalService;
    private final CPConfigurationListRelLocalService _cpConfigurationListRelLocalService;
    private final Portal _portal;

    public CPConfigurationListEligibilityUpgradeProcess(CommerceChannelRelLocalService commerceChannelRelLocalService, CPConfigurationEntryLocalService cpConfigurationEntryLocalService, CPConfigurationListLocalService cpConfigurationListLocalService, CPConfigurationListRelLocalService cpConfigurationListRelLocalService, Portal portal) {
        this._commerceChannelRelLocalService = commerceChannelRelLocalService;
        this._cpConfigurationEntryLocalService = cpConfigurationEntryLocalService;
        this._cpConfigurationListLocalService = cpConfigurationListLocalService;
        this._cpConfigurationListRelLocalService = cpConfigurationListRelLocalService;
        this._portal = portal;
    }

    protected void doUpgrade() throws Exception {
        long accountGroupClassNameId = this._portal.getClassNameId(AccountGroup.class.getName());
        long commerceCatalogClassNameId = this._portal.getClassNameId(CommerceCatalog.class.getName());
        long cpConfigurationListClassNameId = this._portal.getClassNameId(CPConfigurationList.class.getName());
        long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class.getName());
        try (PreparedStatement selectPreparedStatement1 = this.connection.prepareStatement("select Group_.companyId, Group_.groupId from CommerceCatalog join Group_ on Group_.classNameId = ? and Group_.classPK = CommerceCatalog.commerceCatalogId");
             PreparedStatement selectPreparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select CPDefinition.CPDefinitionId, Rel.type_, ", "Rel.classPK, Rel.resourceId from CPDefinition join ", "(select 'C' as type_, classPK, commerceChannelId as ", "resourceId from CommerceChannelRel where classNameId ", "= ? union select 'A' as type_, classPK, ", "accountGroupId as resourceId from AccountGroupRel ", "where classNameId = ?) Rel on ", "(CPDefinition.CPDefinitionId = Rel.classPK and ", "CPDefinition.groupId = ?) order by Rel.classPK"}));
             PreparedStatement selectPreparedStatement3 = this.connection.prepareStatement("select distinct CPConfigurationListId from CPConfigurationListRel where classNameId = ? and classPK = ?");
             PreparedStatement selectPreparedStatement4 = this.connection.prepareStatement("select distinct classPK as CPConfigurationListId from CommerceChannelRel where classNameId = ? and commerceChannelId = ?");
             PreparedStatement updatePreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update CPConfigurationEntry set visible = ? where ", "classNameId = ? and CPConfigurationListId = ? and ", "groupId = ? and classPK in (select classPK from ", "(select classPK from CPConfigurationEntry where ", "classNameId = ? and CPConfigurationListId != ? and ", "groupId = ?) Internal)"}));){
            selectPreparedStatement1.setLong(1, commerceCatalogClassNameId);
            ResultSet resultSet = selectPreparedStatement1.executeQuery();
            while (resultSet.next()) {
                CPConfigurationEntry templateCPConfigurationEntry;
                long groupId = resultSet.getLong("groupId");
                CPConfigurationList masterCPConfigurationList = this._cpConfigurationListLocalService.getMasterCPConfigurationList(groupId);
                if (masterCPConfigurationList == null || (templateCPConfigurationEntry = masterCPConfigurationList.fetchTemplateCPConfigurationEntry()) == null) continue;
                selectPreparedStatement2.setLong(1, cpDefinitionClassNameId);
                selectPreparedStatement2.setLong(2, cpDefinitionClassNameId);
                selectPreparedStatement2.setLong(3, groupId);
                this._addCPConfigurationLists(masterCPConfigurationList, selectPreparedStatement2);
                this._addCPConfigurationEntries(accountGroupClassNameId, cpConfigurationListClassNameId, cpDefinitionClassNameId, masterCPConfigurationList.getCPConfigurationListId(), selectPreparedStatement2, selectPreparedStatement3, selectPreparedStatement4);
                this._updateMasterCPConfigurationEntries(cpDefinitionClassNameId, groupId, masterCPConfigurationList, updatePreparedStatement);
            }
        }
    }

    private void _addCPConfigurationEntries(long accountGroupClassNameId, long cpConfigurationListClassNameId, long cpDefinitionClassNameId, long masterCPConfigurationListId, PreparedStatement selectPreparedStatement1, PreparedStatement selectPreparedStatement2, PreparedStatement selectPreparedStatement3) throws Exception {
        HashSet<Long> cpConfigurationListIds = new HashSet<Long>();
        long curClassPK = 0L;
        CPConfigurationEntry masterCPConfigurationEntry = null;
        ResultSet resultSet1 = selectPreparedStatement1.executeQuery();
        while (resultSet1.next()) {
            ResultSet resultSet2;
            long classPK = resultSet1.getLong("classPK");
            if (classPK != curClassPK) {
                cpConfigurationListIds = new HashSet();
                curClassPK = classPK;
                masterCPConfigurationEntry = CPConfigurationEntryLocalServiceUtil.fetchCPConfigurationEntry((long)cpDefinitionClassNameId, (long)classPK, (long)masterCPConfigurationListId);
            }
            if (masterCPConfigurationEntry == null) continue;
            long resourceId = resultSet1.getLong("resourceId");
            String type = resultSet1.getString("type_");
            if (type.equals("A")) {
                selectPreparedStatement2.setLong(1, accountGroupClassNameId);
                selectPreparedStatement2.setLong(2, resourceId);
                resultSet2 = selectPreparedStatement2.executeQuery();
            } else {
                selectPreparedStatement3.setLong(1, cpConfigurationListClassNameId);
                selectPreparedStatement3.setLong(2, resourceId);
                resultSet2 = selectPreparedStatement3.executeQuery();
            }
            while (resultSet2.next()) {
                CPConfigurationEntry cpConfigurationEntry;
                long cpConfigurationListId = resultSet2.getLong("CPConfigurationListId");
                if (cpConfigurationListIds.contains(cpConfigurationListId) || (cpConfigurationEntry = this._cpConfigurationEntryLocalService.fetchCPConfigurationEntry(cpDefinitionClassNameId, classPK, cpConfigurationListId)) != null) continue;
                cpConfigurationListIds.add(cpConfigurationListId);
                this._cpConfigurationEntryLocalService.addCPConfigurationEntry(null, masterCPConfigurationEntry.getUserId(), masterCPConfigurationEntry.getGroupId(), cpDefinitionClassNameId, classPK, cpConfigurationListId, masterCPConfigurationEntry.getCPTaxCategoryId(), masterCPConfigurationEntry.getAllowedOrderQuantities(), masterCPConfigurationEntry.isBackOrders(), masterCPConfigurationEntry.getCommerceAvailabilityEstimateId(), masterCPConfigurationEntry.getCPDefinitionInventoryEngine(), masterCPConfigurationEntry.getDepth(), masterCPConfigurationEntry.isDisplayAvailability(), masterCPConfigurationEntry.isDisplayStockQuantity(), masterCPConfigurationEntry.isFreeShipping(), masterCPConfigurationEntry.getHeight(), masterCPConfigurationEntry.getLowStockActivity(), masterCPConfigurationEntry.getMaxOrderQuantity(), masterCPConfigurationEntry.getMinOrderQuantity(), masterCPConfigurationEntry.getMinStockQuantity(), masterCPConfigurationEntry.getMultipleOrderQuantity(), masterCPConfigurationEntry.isPurchasable(), masterCPConfigurationEntry.isShippable(), masterCPConfigurationEntry.getShippingExtraPrice(), masterCPConfigurationEntry.isShipSeparately(), masterCPConfigurationEntry.isTaxExempt(), true, masterCPConfigurationEntry.getWeight(), masterCPConfigurationEntry.getWidth());
            }
        }
    }

    private void _addCPConfigurationLists(CPConfigurationList masterCPConfigurationList, PreparedStatement preparedStatement) throws PortalException, SQLException {
        long currentClassPK = 0L;
        String currentType = "";
        boolean monoType = true;
        ArrayList<Set<String>> monoTypeList = new ArrayList<Set<String>>();
        ArrayList<Set<String>> multiTypeList = new ArrayList<Set<String>>();
        HashSet<CallSite> typeSet = new HashSet<CallSite>();
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            long classPK = resultSet.getLong("classPK");
            long resourceId = resultSet.getLong("resourceId");
            String type = resultSet.getString("type_");
            if (classPK != currentClassPK) {
                if (monoType) {
                    monoTypeList.add(typeSet);
                } else {
                    multiTypeList.add(typeSet);
                }
                currentClassPK = classPK;
                currentType = type;
                monoType = true;
                typeSet = new HashSet();
            }
            if (!type.equals(currentType) && monoType) {
                monoType = false;
            }
            typeSet.add((CallSite)((Object)(type + resourceId)));
        }
        if (monoType) {
            monoTypeList.add(typeSet);
        } else {
            multiTypeList.add(typeSet);
        }
        this._clearList(monoTypeList);
        this._clearList(multiTypeList);
        Calendar calendar = Calendar.getInstance();
        long index = 0L;
        ArrayList<Set<String>> typeList = new ArrayList<Set<String>>();
        typeList.addAll(monoTypeList);
        typeList.addAll(multiTypeList);
        for (Set set : typeList) {
            if (set.isEmpty()) continue;
            CPConfigurationList cpConfigurationList = this._cpConfigurationListLocalService.addCPConfigurationList(null, masterCPConfigurationList.getGroupId(), masterCPConfigurationList.getUserId(), masterCPConfigurationList.getCPConfigurationListId(), false, masterCPConfigurationList.getName() + " " + ++index, masterCPConfigurationList.getPriority(), calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), 0, 0, 0, 0, 0, true);
            for (String type : set) {
                long resourceId = GetterUtil.getLong((String)type.substring(1));
                if (type.startsWith("A")) {
                    this._cpConfigurationListRelLocalService.addCPConfigurationListRel(cpConfigurationList.getUserId(), AccountGroup.class.getName(), resourceId, cpConfigurationList.getCPConfigurationListId());
                    continue;
                }
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(cpConfigurationList.getCompanyId());
                serviceContext.setUserId(cpConfigurationList.getUserId());
                this._commerceChannelRelLocalService.addCommerceChannelRel(CPConfigurationList.class.getName(), cpConfigurationList.getCPConfigurationListId(), resourceId, serviceContext);
            }
        }
    }

    private void _clearList(List<Set<String>> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            Set<String> set1 = list.get(i);
            if (set1.isEmpty()) continue;
            for (int j = 0; j < list.size(); ++j) {
                Set<String> set2;
                if (j == i || (set2 = list.get(j)).isEmpty()) continue;
                if (set2.containsAll(set1)) {
                    list.set(i, new HashSet());
                    continue block0;
                }
                if (!set1.containsAll(set2)) continue;
                list.set(j, new HashSet());
                continue block0;
            }
        }
    }

    private void _updateMasterCPConfigurationEntries(long cpDefinitionClassNameId, long groupId, CPConfigurationList masterCPConfigurationList, PreparedStatement preparedStatement) throws Exception {
        preparedStatement.setBoolean(1, false);
        preparedStatement.setLong(2, cpDefinitionClassNameId);
        preparedStatement.setLong(3, masterCPConfigurationList.getCPConfigurationListId());
        preparedStatement.setLong(4, groupId);
        preparedStatement.setLong(5, cpDefinitionClassNameId);
        preparedStatement.setLong(6, masterCPConfigurationList.getCPConfigurationListId());
        preparedStatement.setLong(7, groupId);
        preparedStatement.executeUpdate();
    }
}

