/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v11_4_1;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class SupplierRoleUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(SupplierRoleUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public SupplierRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._updateSupplierPermissions(company.getCompanyId());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private void _updateSupplierPermissions(long companyId) throws PortalException {
        Role accountSupplierRole = this._roleLocalService.fetchRole(companyId, "Supplier");
        if (accountSupplierRole != null) {
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.product.model.CPOption", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.product.model.CPOption", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.product.model.CPOptionCategory", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.product.model.CPOptionCategory", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.product.model.CPSpecificationOption", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.product.model.CPSpecificationOption", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.expando.kernel.model.ExpandoColumn", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.expando.kernel.model.ExpandoColumn", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "VIEW");
            }
            if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.document.library", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "ADD_DOCUMENT")) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.document.library", 1, String.valueOf(companyId), accountSupplierRole.getRoleId(), "ADD_DOCUMENT");
            }
        }
    }
}

