/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Iterator;
import java.util.List;

public class CommerceOrderModelResourcePermissionLogic
implements ModelResourcePermissionLogic<CommerceOrder> {
    private final AccountEntryLocalService _accountEntryLocalService;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final ConfigurationProvider _configurationProvider;
    private final GroupLocalService _groupLocalService;
    private final PortletResourcePermission _portletResourcePermission;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public CommerceOrderModelResourcePermissionLogic(AccountEntryLocalService accountEntryLocalService, CommerceChannelLocalService commerceChannelLocalService, CommerceOrderLocalService commerceOrderLocalService, ConfigurationProvider configurationProvider, GroupLocalService groupLocalService, PortletResourcePermission portletResourcePermission, UserGroupRoleLocalService userGroupRoleLocalService, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._configurationProvider = configurationProvider;
        this._groupLocalService = groupLocalService;
        this._portletResourcePermission = portletResourcePermission;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }

    public Boolean contains(PermissionChecker permissionChecker, String name, CommerceOrder commerceOrder, String actionId) throws PortalException {
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (accountEntry.getAccountEntryId() == -1L && permissionChecker.isSignedIn() && this._hasOwnerPermission(permissionChecker, commerceOrder) && actionId.equals("VIEW")) {
            return true;
        }
        if (accountEntry.getAccountEntryId() == -1L && permissionChecker.isSignedIn()) {
            return this._hasPermission(permissionChecker, 0L, "MANAGE_COMMERCE_ORDERS");
        }
        if (permissionChecker.isCompanyAdmin(commerceOrder.getCompanyId()) || permissionChecker.isGroupAdmin(commerceOrder.getGroupId()) || accountEntry.getAccountEntryId() != -1L && this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "MANAGE_COMMERCE_ORDERS")) {
            return true;
        }
        if ((actionId.equals("UPDATE") || actionId.equals("VIEW")) && this._hasRoleAccountSupplier(permissionChecker, commerceOrder)) {
            return true;
        }
        if (accountEntry.getAccountEntryId() != -1L && actionId.equals("APPROVE_COMMERCE_ORDER")) {
            return this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS");
        }
        if (actionId.equals("CHECKOUT_COMMERCE_ORDER")) {
            return this._containsCheckoutPermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("DELETE")) {
            return this._containsDeletePermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_DELIVERY_TERMS")) {
            return this._containsManageDeliveryTerms(permissionChecker, commerceOrder);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_NOTES")) {
            return this._containsManageNotes(permissionChecker, commerceOrder, false);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_PAYMENT_METHODS")) {
            return this._containsManagePaymentMethods(permissionChecker, commerceOrder);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_PAYMENT_TERMS")) {
            return this._containsManagePaymentTerms(permissionChecker, commerceOrder);
        }
        if (accountEntry.getAccountEntryId() != -1L && actionId.equals("MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES")) {
            return this._containsManageNotes(permissionChecker, commerceOrder, true);
        }
        if (actionId.equals("MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS")) {
            return this._containsManageShippingOptions(permissionChecker, commerceOrder);
        }
        if (actionId.equals("UPDATE")) {
            return this._containsUpdatePermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("VIEW")) {
            return this._containsViewPermission(permissionChecker, commerceOrder);
        }
        if (actionId.equals("VIEW_BILLING_ADDRESS")) {
            return this._containsViewBillingAddress(permissionChecker, commerceOrder);
        }
        return false;
    }

    private boolean _containsCheckoutPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen() && commerceOrder.getOrderStatus() != 6) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (commerceOrder.isPending() && !this._hasPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS")) {
            return false;
        }
        if (commerceOrder.isApproved() && this._hasOwnerPermission(permissionChecker, commerceOrder)) {
            return true;
        }
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "CHECKOUT_OPEN_COMMERCE_ORDERS");
    }

    private boolean _containsDeletePermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isOpen()) {
            if (commerceOrder.isDraft()) {
                return this._hasOwnerPermission(permissionChecker, commerceOrder);
            }
            if (this._hasOwnerPermission(permissionChecker, commerceOrder)) {
                return true;
            }
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "DELETE_COMMERCE_ORDERS");
    }

    private boolean _containsManageDeliveryTerms(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS");
    }

    private boolean _containsManageNotes(PermissionChecker permissionChecker, CommerceOrder commerceOrder, boolean restricted) throws PortalException {
        String actionIds;
        if (!restricted && this._hasOwnerPermission(permissionChecker, commerceOrder)) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        String string = actionIds = restricted ? "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES" : "MANAGE_COMMERCE_ORDER_NOTES";
        if (this._hasRoleAccountSupplier(permissionChecker, commerceOrder) && this._hasPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), actionIds)) {
            return true;
        }
        return this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "MANAGE_COMMERCE_ORDERS");
    }

    private boolean _containsManagePaymentMethods(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS");
    }

    private boolean _containsManagePaymentTerms(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS");
    }

    private boolean _containsManageShippingOptions(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS");
    }

    private boolean _containsUpdatePermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (commerceOrder.isOpen()) {
            if (this._hasOwnerPermission(permissionChecker, commerceOrder)) {
                return true;
            }
            if (commerceOrder.isDraft()) {
                return false;
            }
            if (this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "ADD_COMMERCE_ORDER")) {
                return true;
            }
            if (this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L)) {
                return this._hasPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS");
            }
        }
        if (commerceOrder.isQuote()) {
            return this._hasPermission(permissionChecker, commerceOrder.getGroupId(), "MANAGE_QUOTES");
        }
        return this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "MANAGE_COMMERCE_ORDERS");
    }

    private boolean _containsViewBillingAddress(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        User user = permissionChecker.getUser();
        if (user.isGuestUser() && commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        return this._portletResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryGroup(), "VIEW_BILLING_ADDRESS");
    }

    private boolean _containsViewPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        if (this._hasOwnerPermission(permissionChecker, commerceOrder) || commerceOrder.isGuestOrder()) {
            return true;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (commerceOrder.isOpen()) {
            if (commerceOrder.isDraft()) {
                return false;
            }
            return this._hasPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "APPROVE_OPEN_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS");
        }
        return this._hasAncestorPermission(permissionChecker, accountEntry.getAccountEntryGroupId(), "MANAGE_COMMERCE_ORDERS", "VIEW_COMMERCE_ORDERS");
    }

    private boolean _hasAncestorPermission(PermissionChecker permissionChecker, long groupId, String ... actionIds) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        List groups = ListUtil.copy((List)group.getAncestors());
        groups.add(group);
        for (Group curGroup : groups) {
            if (!this._hasPermission(permissionChecker, curGroup.getGroupId(), actionIds)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasOwnerPermission(PermissionChecker permissionChecker, CommerceOrder commerceOrder) {
        long userId = permissionChecker.getUserId();
        return userId == commerceOrder.getUserId();
    }

    private boolean _hasPermission(PermissionChecker permissionChecker, long groupId, String ... actionIds) {
        for (String actionId : actionIds) {
            if (!this._portletResourcePermission.contains(permissionChecker, groupId, actionId)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasRoleAccountSupplier(PermissionChecker permissionChecker, CommerceOrder commerceOrder) throws PortalException {
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), "", new String[]{"supplier"}, -1, -1);
        for (AccountEntry accountEntry : accountEntries) {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelByGroupClassPK(commerceOrder.getGroupId());
            if (accountEntry.getAccountEntryId() == commerceChannel.getAccountEntryId() && this._userGroupRoleLocalService.hasUserGroupRole(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId(), "Account Supplier")) {
                return true;
            }
            Iterator iterator = commerceOrder.getSupplierCommerceOrderIds().iterator();
            while (iterator.hasNext()) {
                long commerceOrderIds = (Long)iterator.next();
                CommerceOrder supplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderIds);
                commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelByGroupClassPK(supplierCommerceOrder.getGroupId());
                if (accountEntry.getAccountEntryId() != commerceChannel.getAccountEntryId() || !this._userGroupRoleLocalService.hasUserGroupRole(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId(), "Account Supplier")) continue;
                return true;
            }
        }
        return false;
    }
}

