/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRelModel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.account.model.AccountEntry"}, service={ModelDocumentContributor.class})
public class AccountEntryModelDocumentContributor
implements ModelDocumentContributor<AccountEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryModelDocumentContributor.class);
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;

    public void contribute(Document document, AccountEntry accountEntry) {
        block2: {
            try {
                document.addKeyword("commerceChannelIds", this.getCommerceChannelIds(accountEntry));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index account entry " + accountEntry.getAccountEntryId()), (Throwable)exception);
            }
        }
    }

    protected long[] getCommerceChannelIds(AccountEntry accountEntry) {
        long[] commerceChannelIds = ListUtil.toLongArray((List)this._commerceChannelAccountEntryRelLocalService.getCommerceChannelAccountEntryRels(accountEntry.getAccountEntryId(), 9, -1, -1, null), CommerceChannelAccountEntryRelModel::getCommerceChannelId);
        if (commerceChannelIds.length == 0) {
            commerceChannelIds = new long[]{0L};
        }
        return commerceChannelIds;
    }
}

