/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;

public class CommerceOrderBatchReindexer {
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final IndexerDocumentBuilder _indexerDocumentBuilder;
    private final IndexerWriter<CommerceOrder> _indexerWriter;

    public CommerceOrderBatchReindexer(CommerceOrderLocalService commerceOrderLocalService, IndexerDocumentBuilder indexerDocumentBuilder, IndexerWriter<CommerceOrder> indexerWriter) {
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._indexerDocumentBuilder = indexerDocumentBuilder;
        this._indexerWriter = indexerWriter;
    }

    public void reindex(long commerceAccountId, long companyId) {
        BatchIndexingActionable batchIndexingActionable = this._indexerWriter.getBatchIndexingActionable();
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property commerceAccountIdProperty = PropertyFactoryUtil.forName((String)"commerceAccountId");
            dynamicQuery.add(commerceAccountIdProperty.eq((Object)commerceAccountId));
        });
        batchIndexingActionable.setCompanyId(companyId);
        batchIndexingActionable.setPerformActionMethod(commerceOrder -> batchIndexingActionable.addDocuments(new Document[]{this._indexerDocumentBuilder.getDocument((BaseModel)commerceOrder)}));
        batchIndexingActionable.performActions();
    }
}

