/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.order.validator.key=default", "commerce.order.validator.priority:Integer=10"}, service={CommerceOrderValidator.class})
public class DefaultCommerceOrderValidatorImpl
implements CommerceOrderValidator {
    public static final String KEY = "default";
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private Language _language;

    public String getKey() {
        return KEY;
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrder commerceOrder, CPInstance cpInstance, String json, BigDecimal quantity, boolean child) throws PortalException {
        if (cpInstance == null) {
            return new CommerceOrderValidatorResult(false);
        }
        if (!commerceOrder.isOpen()) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "this-order-has-already-been-checked-out", null));
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        BigDecimal minOrderQuantity = cpDefinitionInventoryEngine.getMinOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (BigDecimalUtil.lt((BigDecimal)quantity, (BigDecimal)minOrderQuantity)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-minimum-quantity-is-x", new Object[]{minOrderQuantity}));
        }
        BigDecimal maxOrderQuantity = cpDefinitionInventoryEngine.getMaxOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (BigDecimalUtil.gt((BigDecimal)maxOrderQuantity, (BigDecimal)BigDecimal.ZERO) && BigDecimalUtil.gt((BigDecimal)quantity, (BigDecimal)maxOrderQuantity)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-maximum-quantity-is-x", new Object[]{maxOrderQuantity}));
        }
        Object[] allowedOrderQuantities = cpDefinitionInventoryEngine.getAllowedOrderQuantities(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (allowedOrderQuantities.length > 0 && !ArrayUtil.contains((Object[])allowedOrderQuantities, (Object)String.valueOf(quantity.intValue()))) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-specified-quantity-is-not-allowed", null));
        }
        BigDecimal multipleOrderQuantity = cpDefinitionInventoryEngine.getMultipleOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (!BigDecimalUtil.eq((BigDecimal)quantity.remainder(multipleOrderQuantity), (BigDecimal)BigDecimal.ZERO)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-specified-quantity-is-not-a-multiple-of-x", new Object[]{multipleOrderQuantity}));
        }
        return new CommerceOrderValidatorResult(true);
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrderItem commerceOrderItem) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            return new CommerceOrderValidatorResult(false);
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        BigDecimal minOrderQuantity = cpDefinitionInventoryEngine.getMinOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        BigDecimal quantity = commerceOrderItem.getQuantity();
        if (BigDecimalUtil.lt((BigDecimal)quantity, (BigDecimal)minOrderQuantity)) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-minimum-quantity-is-x", new Object[]{minOrderQuantity}));
        }
        BigDecimal maxOrderQuantity = cpDefinitionInventoryEngine.getMaxOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (BigDecimalUtil.gt((BigDecimal)maxOrderQuantity, (BigDecimal)BigDecimal.ZERO) && BigDecimalUtil.gt((BigDecimal)quantity, (BigDecimal)maxOrderQuantity)) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-maximum-quantity-is-x", new Object[]{maxOrderQuantity}));
        }
        Object[] allowedOrderQuantities = cpDefinitionInventoryEngine.getAllowedOrderQuantities(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (allowedOrderQuantities.length > 0 && !ArrayUtil.contains((Object[])allowedOrderQuantities, (Object)String.valueOf(quantity.intValue()))) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-specified-quantity-is-not-allowed", null));
        }
        BigDecimal multipleOrderQuantity = cpDefinitionInventoryEngine.getMultipleOrderQuantity(commerceOrder.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance);
        if (!BigDecimalUtil.eq((BigDecimal)quantity.remainder(multipleOrderQuantity), (BigDecimal)BigDecimal.ZERO)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-specified-quantity-is-not-a-multiple-of-x", new Object[]{multipleOrderQuantity}));
        }
        return new CommerceOrderValidatorResult(true);
    }

    private String _getLocalizedMessage(Locale locale, String key, Object[] arguments) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        if (arguments == null) {
            return this._language.get(resourceBundle, key);
        }
        return this._language.format(resourceBundle, key, arguments);
    }
}

