/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.internal.order.comparator.CommerceReturnReasonOrderComparator;
import com.liferay.commerce.order.CommerceReturnReason;
import com.liferay.commerce.order.CommerceReturnReasonRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={CommerceReturnReasonRegistry.class})
public class CommerceReturnReasonRegistryImpl
implements CommerceReturnReasonRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceReturnReasonRegistryImpl.class);
    private final Comparator<CommerceReturnReason> _commerceReturnReasonOrderComparator = new CommerceReturnReasonOrderComparator();
    private ServiceTrackerMap<String, CommerceReturnReason> _serviceTrackerMap;

    public CommerceReturnReason getCommerceReturnReason(String key) {
        if (Validator.isNull((String)key) || !FeatureFlagManagerUtil.isEnabled((String)"LPD-10562")) {
            return null;
        }
        CommerceReturnReason commerceReturnReason = (CommerceReturnReason)this._serviceTrackerMap.getService((Object)key);
        if (commerceReturnReason == null && _log.isDebugEnabled()) {
            _log.debug((Object)("No commerce return reason registered with key " + key));
        }
        return commerceReturnReason;
    }

    public List<CommerceReturnReason> getCommerceReturnReasons() {
        List<CommerceReturnReason> commerceReturnReasons;
        block3: {
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-10562")) {
                return Collections.emptyList();
            }
            commerceReturnReasons = new ArrayList();
            try {
                commerceReturnReasons = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
                commerceReturnReasons.sort(this._commerceReturnReasonOrderComparator);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return Collections.unmodifiableList(commerceReturnReasons);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceReturnReason.class, null, (serviceReference, emitter) -> {
            CommerceReturnReason commerceReturnReason = (CommerceReturnReason)bundleContext.getService(serviceReference);
            try {
                if (commerceReturnReason.getKey() != null) {
                    emitter.emit((Object)commerceReturnReason.getKey());
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

