/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.internal.order.comparator.CommerceOrderValidatorServiceWrapperPriorityComparator;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceOrderValidatorRegistry.class})
public class CommerceOrderValidatorRegistryImpl
implements CommerceOrderValidatorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderValidatorRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceOrderValidator>> _commerceOrderValidatorServiceWrapperPriorityComparator = new CommerceOrderValidatorServiceWrapperPriorityComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceOrderValidator>> _serviceTrackerMap;

    public CommerceOrderValidator getCommerceOrderValidator(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderValidatorServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceOrderValidatorServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce order validator registered with key " + key));
            }
            return null;
        }
        return (CommerceOrderValidator)commerceOrderValidatorServiceWrapper.getService();
    }

    public Map<Long, List<CommerceOrderValidatorResult>> getCommerceOrderValidatorResults(Locale locale, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<CommerceOrderValidatorResult>> commerceOrderValidatorResultsMap = new HashMap<Long, List<CommerceOrderValidatorResult>>();
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            ArrayList<CommerceOrderValidatorResult> filteredCommerceOrderValidatorResults = new ArrayList<CommerceOrderValidatorResult>();
            List<CommerceOrderValidatorResult> commerceOrderValidatorResults = this.validate(locale, commerceOrderItem);
            for (CommerceOrderValidatorResult commerceOrderValidatorResult : commerceOrderValidatorResults) {
                if (commerceOrderValidatorResult.getCommerceOrderItemId() <= 0L || commerceOrderItem.getCommerceOrderItemId() != commerceOrderValidatorResult.getCommerceOrderItemId()) continue;
                filteredCommerceOrderValidatorResults.add(commerceOrderValidatorResult);
            }
            commerceOrderValidatorResultsMap.put(commerceOrderItem.getCommerceOrderItemId(), filteredCommerceOrderValidatorResults);
        }
        return commerceOrderValidatorResultsMap;
    }

    public List<CommerceOrderValidator> getCommerceOrderValidators() {
        ArrayList<CommerceOrderValidator> commerceOrderValidators = new ArrayList<CommerceOrderValidator>();
        List commerceOrderValidatorServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceOrderValidatorServiceWrappers, _commerceOrderValidatorServiceWrapperPriorityComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderValidatorServiceWrapper : commerceOrderValidatorServiceWrappers) {
            commerceOrderValidators.add((CommerceOrderValidator)commerceOrderValidatorServiceWrapper.getService());
        }
        return Collections.unmodifiableList(commerceOrderValidators);
    }

    public boolean isValid(Locale locale, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder == null) {
            return false;
        }
        ArrayList<CommerceOrderValidatorResult> commerceOrderValidatorResults = new ArrayList<CommerceOrderValidatorResult>();
        commerceOrderValidatorResults.addAll(this.validate(locale, commerceOrder));
        return commerceOrderValidatorResults.isEmpty();
    }

    public List<CommerceOrderValidatorResult> validate(Locale locale, CommerceOrder commerceOrder) throws PortalException {
        ArrayList<CommerceOrderValidatorResult> commerceOrderValidatorResults = new ArrayList<CommerceOrderValidatorResult>();
        List<CommerceOrderValidator> commerceOrderValidators = this.getCommerceOrderValidators();
        for (CommerceOrderValidator commerceOrderValidator : commerceOrderValidators) {
            CommerceOrderValidatorResult commerceOrderValidatorResult = commerceOrderValidator.validate(locale, commerceOrder);
            if (commerceOrderValidatorResult.isValid()) continue;
            commerceOrderValidatorResults.add(commerceOrderValidatorResult);
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            commerceOrderValidatorResults.addAll(this.validate(locale, commerceOrderItem));
        }
        return commerceOrderValidatorResults;
    }

    public List<CommerceOrderValidatorResult> validate(Locale locale, CommerceOrder commerceOrder, CPInstance cpInstance, String json, BigDecimal quantity, boolean child) throws PortalException {
        return TransformUtil.transform(this.getCommerceOrderValidators(), commerceOrderValidator -> {
            CommerceOrderValidatorResult commerceOrderValidatorResult = commerceOrderValidator.validate(locale, commerceOrder, cpInstance, json, quantity, child);
            if (!commerceOrderValidatorResult.isValid()) {
                return commerceOrderValidatorResult;
            }
            return null;
        });
    }

    public List<CommerceOrderValidatorResult> validate(Locale locale, CommerceOrderItem commerceOrderItem) throws PortalException {
        return TransformUtil.transform(this.getCommerceOrderValidators(), commerceOrderValidator -> {
            CommerceOrderValidatorResult commerceOrderValidatorResult = commerceOrderValidator.validate(locale, commerceOrderItem);
            if (!commerceOrderValidatorResult.isValid()) {
                return commerceOrderValidatorResult;
            }
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceOrderValidator.class, (String)"commerce.order.validator.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

