/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.validation.rule;

import com.liferay.commerce.internal.object.validation.rule.BasePermissionObjectValidationRuleEngineImpl;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectValidationRuleEngine.class})
public class CommerceReturnItemPermissionObjectValidationRuleEngineImpl
extends BasePermissionObjectValidationRuleEngineImpl {
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.return)")
    private PortletResourcePermission _portletResourcePermission;

    @Override
    protected String getObjectDefinitionName() {
        return "CommerceReturnItem";
    }

    @Override
    protected boolean hasValidationCriteriaMet(Map<String, Object> inputObjects) {
        Map originalEntryDTO = (Map)inputObjects.get("originalEntryDTO");
        if (MapUtil.isEmpty((Map)originalEntryDTO)) {
            return true;
        }
        Map originalProperties = (Map)originalEntryDTO.get("properties");
        ObjectEntry originalObjectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong(originalProperties.get("r_commerceReturnToCommerceReturnItems_l_commerceReturnId")));
        Map originalValues = originalObjectEntry.getValues();
        String currentReturnStatus = GetterUtil.getString(originalValues.get("returnStatus"));
        Map entryDTO = (Map)inputObjects.get("entryDTO");
        Map properties = (Map)entryDTO.get("properties");
        if (StringUtil.equalsIgnoreCase((String)currentReturnStatus, (String)"draft")) {
            if (StringUtil.equals((String)GetterUtil.getString(entryDTO.get("externalReferenceCode")), (String)GetterUtil.getString(originalEntryDTO.get("externalReferenceCode"))) && this.equals(originalProperties, properties, "authorized", "authorizeReturnWithoutReturningProducts", "received")) {
                return true;
            }
            return this._portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), null, "MANAGE_RETURNS");
        }
        if (StringUtil.equals((String)GetterUtil.getString(entryDTO.get("externalReferenceCode")), (String)GetterUtil.getString(originalEntryDTO.get("externalReferenceCode"))) && this.equals(originalProperties, properties, "authorized", "authorizeReturnWithoutReturningProducts", "quantity", "received", "returnReason")) {
            return true;
        }
        return this._portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), null, "MANAGE_RETURNS");
    }
}

