/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassTable;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroup;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductGroupResource;
import com.liferay.object.field.builder.IntegerObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, service={SystemObjectDefinitionManager.class})
public class CommercePricingClassSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;
    @Reference
    private ProductGroupResource.Factory _productGroupResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        ProductGroupResource productGroupResource = this._buildProductGroupResource(false, user);
        ProductGroup productGroup = productGroupResource.postProductGroup(this._toProductGroup(values));
        this.setExtendedProperties(ProductGroup.class.getName(), productGroup, user, values);
        return productGroup.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commercePricingClassLocalService.deleteCommercePricingClass((CommercePricingClass)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._commercePricingClassLocalService.fetchCommercePricingClassByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commercePricingClassLocalService.getCommercePricingClassByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        CommercePricingClass commercePricingClass = this._commercePricingClassLocalService.getCommercePricingClass(primaryKey);
        return commercePricingClass.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_COMMERCE_PRODUCT_GROUP";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Catalog", "headless-commerce-admin-catalog", "product-groups", "v1.0");
    }

    public Map<String, String> getLabelKeys() {
        return HashMapBuilder.put((Object)"label", (Object)"commerce-product-group").put((Object)"pluralLabel", (Object)"commerce-product-groups").build();
    }

    public Class<?> getModelClass() {
        return CommercePricingClass.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new TextObjectFieldBuilder().labelMap(this.createLabelMap("description")).name("description").system(true).build(), new IntegerObjectFieldBuilder().labelMap(this.createLabelMap("number-of-products")).name("productsCount").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("title")).name("title").required(true).system(true).build());
    }

    public Page<?> getPage(User user, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        ProductGroupResource productGroupResource = this._buildProductGroupResource(true, user);
        return productGroupResource.getProductGroupsPage(search, filter, pagination, sorts);
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommercePricingClassTable.INSTANCE.commercePricingClassId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommercePricingClassTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "title";
    }

    public int getVersion() {
        return 3;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        ProductGroupResource productGroupResource = this._buildProductGroupResource(false, user);
        productGroupResource.patchProductGroup(Long.valueOf(primaryKey), this._toProductGroup(values));
        this.setExtendedProperties(ProductGroup.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private ProductGroupResource _buildProductGroupResource(boolean checkPermissions, User user) {
        ProductGroupResource.Builder builder = this._productGroupResourceFactory.create();
        return builder.checkPermissions(checkPermissions).preferredLocale(user.getLocale()).user(user).build();
    }

    private ProductGroup _toProductGroup(final Map<String, Object> values) {
        return new ProductGroup(){
            {
                this.setDescription(() -> CommercePricingClassSystemObjectDefinitionManager.this.getLanguageIdMap("description", values));
                this.setExternalReferenceCode(() -> GetterUtil.getString(values.get("externalReferenceCode")));
                this.setProductsCount(() -> GetterUtil.getInteger(values.get("productsCount")));
                this.setTitle(() -> CommercePricingClassSystemObjectDefinitionManager.this.getLanguageIdMap("title", values));
            }
        };
    }
}

