/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.term.evaluator;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;

public class CommerceOrderAddressNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final ObjectDefinition _objectDefinition;

    public CommerceOrderAddressNotificationTermEvaluator(CommerceOrderLocalService commerceOrderLocalService, ObjectDefinition objectDefinition) {
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._objectDefinition = objectDefinition;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map) || !StringUtil.equalsIgnoreCase((String)"CommerceOrder", (String)this._objectDefinition.getShortName())) {
            return termName;
        }
        Map termValues = (Map)object;
        return this._getAddress(termName, termValues);
    }

    private String _getAddress(String termName, Map<String, Object> termValues) throws PortalException {
        String billingAddressPrefix = "[%COMMERCEORDER_BILLING_ADDRESS_";
        String shippingAddressPrefix = "[%COMMERCEORDER_SHIPPING_ADDRESS_";
        if (!termName.startsWith(billingAddressPrefix) && !termName.startsWith(shippingAddressPrefix)) {
            return termName;
        }
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(GetterUtil.getLong((Object)termValues.get("id")));
        if (commerceOrder.getBillingAddress() != null && termName.startsWith(billingAddressPrefix)) {
            return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)billingAddressPrefix), commerceOrder.getBillingAddress());
        }
        if (commerceOrder.getShippingAddress() != null && termName.startsWith(shippingAddressPrefix)) {
            return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)shippingAddressPrefix), commerceOrder.getShippingAddress());
        }
        return termName;
    }

    private String _getTermValue(String partialTermName, CommerceAddress commerceAddress) throws PortalException {
        if (partialTermName.equals("CITY%]")) {
            return commerceAddress.getCity();
        }
        if (partialTermName.equals("COUNTRY%]")) {
            Country country = commerceAddress.getCountry();
            if (country == null) {
                return null;
            }
            return country.getTitle();
        }
        if (partialTermName.equals("NAME%]")) {
            return commerceAddress.getName();
        }
        if (partialTermName.equals("PHONE_NUMBER%]")) {
            return commerceAddress.getPhoneNumber();
        }
        if (partialTermName.equals("REGION%]")) {
            Region region = commerceAddress.getRegion();
            if (region == null) {
                return null;
            }
            return region.getTitle();
        }
        if (partialTermName.equals("STREET1%]")) {
            return commerceAddress.getStreet1();
        }
        if (partialTermName.equals("STREET2%]")) {
            return commerceAddress.getStreet2();
        }
        if (partialTermName.equals("STREET3%]")) {
            return commerceAddress.getStreet3();
        }
        if (partialTermName.equals("ZIP%]")) {
            return commerceAddress.getZip();
        }
        return null;
    }
}

