/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.exception.CommerceAccountOrdersException;
import com.liferay.commerce.internal.search.CommerceOrderBatchReindexer;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class AccountEntryModelListener
extends BaseModelListener<AccountEntry> {
    private CommerceOrderBatchReindexer _commerceOrderBatchReindexer;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceShippingOptionAccountEntryRelLocalService _commerceShippingOptionAccountEntryRelLocalService;
    @Reference(target="(indexer.class.name=com.liferay.commerce.model.CommerceOrder)")
    private IndexerDocumentBuilder _indexerDocumentBuilder;
    @Reference(target="(indexer.class.name=com.liferay.commerce.model.CommerceOrder)")
    private IndexerWriter<CommerceOrder> _indexerWriter;

    public void onAfterUpdate(AccountEntry originalAccountEntry, AccountEntry accountEntry) throws ModelListenerException {
        if (StringUtil.equals((String)originalAccountEntry.getName(), (String)accountEntry.getName())) {
            return;
        }
        this._commerceOrderBatchReindexer.reindex(accountEntry.getAccountEntryId(), accountEntry.getCompanyId());
    }

    public void onBeforeRemove(AccountEntry accountEntry) {
        int accountOrders = this._commerceOrderLocalService.getCommerceOrdersCountByCommerceAccountId(accountEntry.getAccountEntryId());
        if (accountOrders > 0) {
            throw new CommerceAccountOrdersException();
        }
        this._commerceShippingOptionAccountEntryRelLocalService.deleteCommerceShippingOptionAccountEntryRelsByAccountEntryId(accountEntry.getAccountEntryId());
    }

    @Activate
    protected void activate() {
        this._commerceOrderBatchReindexer = new CommerceOrderBatchReindexer(this._commerceOrderLocalService, this._indexerDocumentBuilder, this._indexerWriter);
    }
}

