/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.service.base;

import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelLocalService;
import com.liferay.commerce.service.persistence.CommerceShippingOptionAccountEntryRelPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;

import java.io.Serializable;

import java.util.List;

import javax.sql.DataSource;

import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the commerce shipping option account entry rel local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.commerce.service.impl.CommerceShippingOptionAccountEntryRelLocalServiceImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see com.liferay.commerce.service.impl.CommerceShippingOptionAccountEntryRelLocalServiceImpl
 * @generated
 */
public abstract class CommerceShippingOptionAccountEntryRelLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements AopService, CommerceShippingOptionAccountEntryRelLocalService,
			   IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>CommerceShippingOptionAccountEntryRelLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelLocalServiceUtil</code>.
	 */

	/**
	 * Adds the commerce shipping option account entry rel to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceShippingOptionAccountEntryRelLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceShippingOptionAccountEntryRel the commerce shipping option account entry rel
	 * @return the commerce shipping option account entry rel that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public CommerceShippingOptionAccountEntryRel
		addCommerceShippingOptionAccountEntryRel(
			CommerceShippingOptionAccountEntryRel
				commerceShippingOptionAccountEntryRel) {

		commerceShippingOptionAccountEntryRel.setNew(true);

		return commerceShippingOptionAccountEntryRelPersistence.update(
			commerceShippingOptionAccountEntryRel);
	}

	/**
	 * Creates a new commerce shipping option account entry rel with the primary key. Does not add the commerce shipping option account entry rel to the database.
	 *
	 * @param CommerceShippingOptionAccountEntryRelId the primary key for the new commerce shipping option account entry rel
	 * @return the new commerce shipping option account entry rel
	 */
	@Override
	@Transactional(enabled = false)
	public CommerceShippingOptionAccountEntryRel
		createCommerceShippingOptionAccountEntryRel(
			long CommerceShippingOptionAccountEntryRelId) {

		return commerceShippingOptionAccountEntryRelPersistence.create(
			CommerceShippingOptionAccountEntryRelId);
	}

	/**
	 * Deletes the commerce shipping option account entry rel with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceShippingOptionAccountEntryRelLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param CommerceShippingOptionAccountEntryRelId the primary key of the commerce shipping option account entry rel
	 * @return the commerce shipping option account entry rel that was removed
	 * @throws PortalException if a commerce shipping option account entry rel with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public CommerceShippingOptionAccountEntryRel
			deleteCommerceShippingOptionAccountEntryRel(
				long CommerceShippingOptionAccountEntryRelId)
		throws PortalException {

		return commerceShippingOptionAccountEntryRelPersistence.remove(
			CommerceShippingOptionAccountEntryRelId);
	}

	/**
	 * Deletes the commerce shipping option account entry rel from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceShippingOptionAccountEntryRelLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceShippingOptionAccountEntryRel the commerce shipping option account entry rel
	 * @return the commerce shipping option account entry rel that was removed
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public CommerceShippingOptionAccountEntryRel
		deleteCommerceShippingOptionAccountEntryRel(
			CommerceShippingOptionAccountEntryRel
				commerceShippingOptionAccountEntryRel) {

		return commerceShippingOptionAccountEntryRelPersistence.remove(
			commerceShippingOptionAccountEntryRel);
	}

	@Override
	public <T> T dslQuery(DSLQuery dslQuery) {
		return commerceShippingOptionAccountEntryRelPersistence.dslQuery(
			dslQuery);
	}

	@Override
	public int dslQueryCount(DSLQuery dslQuery) {
		Long count = dslQuery(dslQuery);

		return count.intValue();
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			CommerceShippingOptionAccountEntryRel.class,
			clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return commerceShippingOptionAccountEntryRelPersistence.
			findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return commerceShippingOptionAccountEntryRelPersistence.
			findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return commerceShippingOptionAccountEntryRelPersistence.
			findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return commerceShippingOptionAccountEntryRelPersistence.
			countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return commerceShippingOptionAccountEntryRelPersistence.
			countWithDynamicQuery(dynamicQuery, projection);
	}

	@Override
	public CommerceShippingOptionAccountEntryRel
		fetchCommerceShippingOptionAccountEntryRel(
			long CommerceShippingOptionAccountEntryRelId) {

		return commerceShippingOptionAccountEntryRelPersistence.
			fetchByPrimaryKey(CommerceShippingOptionAccountEntryRelId);
	}

	/**
	 * Returns the commerce shipping option account entry rel with the primary key.
	 *
	 * @param CommerceShippingOptionAccountEntryRelId the primary key of the commerce shipping option account entry rel
	 * @return the commerce shipping option account entry rel
	 * @throws PortalException if a commerce shipping option account entry rel with the primary key could not be found
	 */
	@Override
	public CommerceShippingOptionAccountEntryRel
			getCommerceShippingOptionAccountEntryRel(
				long CommerceShippingOptionAccountEntryRelId)
		throws PortalException {

		return commerceShippingOptionAccountEntryRelPersistence.
			findByPrimaryKey(CommerceShippingOptionAccountEntryRelId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(
			commerceShippingOptionAccountEntryRelLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(
			CommerceShippingOptionAccountEntryRel.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"CommerceShippingOptionAccountEntryRelId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			commerceShippingOptionAccountEntryRelLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(
			CommerceShippingOptionAccountEntryRel.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"CommerceShippingOptionAccountEntryRelId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(
			commerceShippingOptionAccountEntryRelLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(
			CommerceShippingOptionAccountEntryRel.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"CommerceShippingOptionAccountEntryRelId");
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel createPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return commerceShippingOptionAccountEntryRelPersistence.create(
			((Long)primaryKeyObj).longValue());
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		if (_log.isWarnEnabled()) {
			_log.warn(
				"Implement CommerceShippingOptionAccountEntryRelLocalServiceImpl#deleteCommerceShippingOptionAccountEntryRel(CommerceShippingOptionAccountEntryRel) to avoid orphaned data");
		}

		return commerceShippingOptionAccountEntryRelLocalService.
			deleteCommerceShippingOptionAccountEntryRel(
				(CommerceShippingOptionAccountEntryRel)persistedModel);
	}

	@Override
	public BasePersistence<CommerceShippingOptionAccountEntryRel>
		getBasePersistence() {

		return commerceShippingOptionAccountEntryRelPersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return commerceShippingOptionAccountEntryRelPersistence.
			findByPrimaryKey(primaryKeyObj);
	}

	/**
	 * Returns a range of all the commerce shipping option account entry rels.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of commerce shipping option account entry rels
	 * @param end the upper bound of the range of commerce shipping option account entry rels (not inclusive)
	 * @return the range of commerce shipping option account entry rels
	 */
	@Override
	public List<CommerceShippingOptionAccountEntryRel>
		getCommerceShippingOptionAccountEntryRels(int start, int end) {

		return commerceShippingOptionAccountEntryRelPersistence.findAll(
			start, end);
	}

	/**
	 * Returns the number of commerce shipping option account entry rels.
	 *
	 * @return the number of commerce shipping option account entry rels
	 */
	@Override
	public int getCommerceShippingOptionAccountEntryRelsCount() {
		return commerceShippingOptionAccountEntryRelPersistence.countAll();
	}

	/**
	 * Updates the commerce shipping option account entry rel in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceShippingOptionAccountEntryRelLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceShippingOptionAccountEntryRel the commerce shipping option account entry rel
	 * @return the commerce shipping option account entry rel that was updated
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public CommerceShippingOptionAccountEntryRel
		updateCommerceShippingOptionAccountEntryRel(
			CommerceShippingOptionAccountEntryRel
				commerceShippingOptionAccountEntryRel) {

		return commerceShippingOptionAccountEntryRelPersistence.update(
			commerceShippingOptionAccountEntryRel);
	}

	@Deactivate
	protected void deactivate() {
	}

	@Override
	public Class<?>[] getAopInterfaces() {
		return new Class<?>[] {
			CommerceShippingOptionAccountEntryRelLocalService.class,
			IdentifiableOSGiService.class, PersistedModelLocalService.class
		};
	}

	@Override
	public void setAopProxy(Object aopProxy) {
		commerceShippingOptionAccountEntryRelLocalService =
			(CommerceShippingOptionAccountEntryRelLocalService)aopProxy;
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return CommerceShippingOptionAccountEntryRelLocalService.class.
			getName();
	}

	protected Class<?> getModelClass() {
		return CommerceShippingOptionAccountEntryRel.class;
	}

	protected String getModelClassName() {
		return CommerceShippingOptionAccountEntryRel.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource =
				commerceShippingOptionAccountEntryRelPersistence.
					getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	protected CommerceShippingOptionAccountEntryRelLocalService
		commerceShippingOptionAccountEntryRelLocalService;

	@Reference
	protected CommerceShippingOptionAccountEntryRelPersistence
		commerceShippingOptionAccountEntryRelPersistence;

	@Reference
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceShippingOptionAccountEntryRelLocalServiceBaseImpl.class);

}