/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentInactiveWarehouseException;
import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.exception.DuplicateCommerceShipmentItemException;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.product.exception.NoSuchCPInstanceUnitOfMeasureException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.base.CommerceShipmentItemLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceShipmentItem"}, service={AopService.class})
public class CommerceShipmentItemLocalServiceImpl
extends CommerceShipmentItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentItemLocalServiceImpl.class);
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceShipmentPersistence _commerceShipmentPersistence;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, BigDecimal quantity, String unitOfMeasureKey, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this._validateExternalReferenceCode(0L, serviceContext.getCompanyId(), externalReferenceCode);
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        if (validateInventory) {
            this._validate(commerceOrderItem, this._commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId), commerceInventoryWarehouseId, quantity, quantity);
        }
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setExternalReferenceCode(externalReferenceCode);
        commerceShipmentItem.setGroupId(commerceOrderItem.getGroupId());
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        if (Validator.isNotNull((String)unitOfMeasureKey)) {
            CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(commerceOrderItem.getCPInstanceId(), unitOfMeasureKey);
            if (cpInstanceUnitOfMeasure == null) {
                throw new NoSuchCPInstanceUnitOfMeasureException("No commerce product instance unit of measure exists with the primary key " + unitOfMeasureKey);
            }
            commerceShipmentItem.setUnitOfMeasureKey(unitOfMeasureKey);
        } else {
            commerceShipmentItem.setUnitOfMeasureKey(commerceOrderItem.getUnitOfMeasureKey());
        }
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), commerceShipmentItem.getQuantity());
        this._commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantity);
        return commerceShipmentItem;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem addDeliverySubscriptionCommerceShipmentItem(long groupId, long userId, long commerceShipmentId, long commerceOrderItemId) throws PortalException {
        long commerceShipmentItemId = this.counterLocalService.increment();
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.create(commerceShipmentItemId);
        commerceShipmentItem.setGroupId(groupId);
        User user = this._userLocalService.getUser(userId);
        commerceShipmentItem.setCompanyId(user.getCompanyId());
        commerceShipmentItem.setUserId(user.getUserId());
        commerceShipmentItem.setUserName(user.getFullName());
        commerceShipmentItem.setCommerceShipmentId(commerceShipmentId);
        commerceShipmentItem.setCommerceOrderItemId(commerceOrderItemId);
        return (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
    }

    public CommerceShipmentItem addOrUpdateCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, BigDecimal quantity, String unitOfMeasureKey, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        CommerceShipmentItem commerceShipmentItem = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceShipmentItem = this.commerceShipmentItemPersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId());
        }
        if (commerceShipmentItem == null) {
            return this.commerceShipmentItemLocalService.addCommerceShipmentItem(externalReferenceCode, commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, quantity, unitOfMeasureKey, validateInventory, serviceContext);
        }
        return this.commerceShipmentItemLocalService.updateCommerceShipmentItem(commerceShipmentItem.getCommerceShipmentItemId(), commerceInventoryWarehouseId, quantity, validateInventory);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipmentItem deleteCommerceShipmentItem(CommerceShipmentItem commerceShipmentItem, boolean restoreStockQuantity) throws PortalException {
        this.commerceShipmentItemPersistence.remove((BaseModel)commerceShipmentItem);
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        if (!restoreStockQuantity) {
            if (commerceOrderItem != null) {
                this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId(), 0L);
            }
            return commerceShipmentItem;
        }
        BigDecimal shippedQuantity = commerceShipmentItem.getQuantity();
        try {
            commerceOrderItem = this._commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), shippedQuantity.negate());
            if (commerceShipmentItem.getCommerceInventoryWarehouseId() > 0L && shippedQuantity.compareTo(BigDecimal.ZERO) > 0) {
                this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, commerceShipmentItem.getQuantity());
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return commerceShipmentItem;
    }

    public void deleteCommerceShipmentItem(long commerceShipmentItemId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
    }

    public void deleteCommerceShipmentItems(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        List commerceShipmentItems = this.commerceShipmentItemPersistence.findByCommerceShipmentId(commerceShipmentId);
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
        }
    }

    public CommerceShipmentItem fetchCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) {
        return this.commerceShipmentItemPersistence.fetchByC_C_C(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
    }

    @Deprecated
    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) {
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByCommerceShipmentId(commerceShipmentId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, long commerceOrderItemId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) {
        return this.commerceShipmentItemPersistence.findByC_C(commerceShipmentId, commerceOrderItemId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItemsByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.findByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) {
        return this.commerceShipmentItemPersistence.countByCommerceShipmentId(commerceShipmentId);
    }

    public int getCommerceShipmentItemsCountByCommerceOrderItemId(long commerceOrderItemId) {
        return this.commerceShipmentItemPersistence.countByCommerceOrderItemId(commerceOrderItemId);
    }

    public BigDecimal getCommerceShipmentOrderItemsQuantity(long commerceShipmentId, long commerceOrderItemId) {
        return this.commerceShipmentItemFinder.getCommerceShipmentOrderItemsQuantity(commerceShipmentId, commerceOrderItemId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, long commerceInventoryWarehouseId, BigDecimal quantity, boolean validateInventory) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
        BigDecimal originalQuantity = commerceShipmentItem.getQuantity();
        if (validateInventory) {
            this._validate(commerceOrderItem, commerceShipmentItem.getCommerceShipment(), commerceInventoryWarehouseId, originalQuantity, quantity);
        }
        commerceShipmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceShipmentItem.setQuantity(quantity);
        commerceShipmentItem = (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
        BigDecimal quantityDelta = quantity.subtract(originalQuantity);
        if (BigDecimalUtil.eq((BigDecimal)commerceOrderItem.getQuantity(), (BigDecimal)commerceOrderItem.getShippedQuantity())) {
            this._restoreStockQuantity(commerceOrderItem, commerceShipmentItem, quantityDelta.abs());
        } else {
            this._updateStockQuantity(commerceOrderItem, commerceShipmentItem.getCommerceShipmentItemId(), quantityDelta);
        }
        this._commerceOrderItemLocalService.incrementShippedQuantity(commerceShipmentItem.getCommerceOrderItemId(), quantityDelta);
        return commerceShipmentItem;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipmentItem updateExternalReferenceCode(long commerceShipmentItemId, String externalReferenceCode) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        if (Objects.equals(commerceShipmentItem.getExternalReferenceCode(), externalReferenceCode)) {
            return commerceShipmentItem;
        }
        this._validateExternalReferenceCode(commerceShipmentItemId, commerceShipmentItem.getCompanyId(), externalReferenceCode);
        commerceShipmentItem.setExternalReferenceCode(externalReferenceCode);
        return (CommerceShipmentItem)this.commerceShipmentItemPersistence.update((BaseModel)commerceShipmentItem);
    }

    private CommerceInventoryWarehouseItem _fetchCommerceInventoryWarehouseItem(long commerceShipmentItemId, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        return this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceShipmentItem.getCommerceInventoryWarehouseId(), sku, unitOfMeasureKey);
    }

    private void _restoreStockQuantity(CommerceOrderItem commerceOrderItem, CommerceShipmentItem commerceShipmentItem, BigDecimal quantity) throws PortalException {
        long commerceCatalogGroupId = 0L;
        CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
        if (cpDefinition != null) {
            commerceCatalogGroupId = cpDefinition.getGroupId();
        }
        this._commerceInventoryEngine.increaseStockQuantity(commerceShipmentItem.getUserId(), commerceCatalogGroupId, commerceShipmentItem.getCommerceInventoryWarehouseId(), quantity, commerceOrderItem.getSku(), commerceOrderItem.getUnitOfMeasureKey());
        this._commerceInventoryBookedQuantityLocalService.resetCommerceInventoryBookedQuantity(commerceOrderItem.getCommerceInventoryBookedQuantityId(), commerceOrderItem.getUserId(), null, quantity, commerceOrderItem.getSku(), commerceOrderItem.getUnitOfMeasureKey(), (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).put((Object)"shipmentId", (Object)String.valueOf(commerceShipmentItem.getCommerceShipmentId())).build());
    }

    private void _updateStockQuantity(CommerceOrderItem commerceOrderItem, long commerceShipmentItemId, BigDecimal quantity) throws PortalException {
        if (commerceOrderItem == null) {
            return;
        }
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._fetchCommerceInventoryWarehouseItem(commerceShipmentItemId, commerceOrderItem.getSku(), commerceOrderItem.getUnitOfMeasureKey());
        if (commerceInventoryWarehouseItem == null) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        long commerceCatalogGroupId = 0L;
        CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
        if (cpDefinition != null) {
            commerceCatalogGroupId = cpDefinition.getGroupId();
        }
        this._commerceInventoryEngine.consumeQuantity(commerceShipmentItem.getUserId(), commerceOrderItem.getCommerceInventoryBookedQuantityId(), commerceCatalogGroupId, commerceShipmentItem.getCommerceInventoryWarehouseId(), quantity, commerceOrderItem.getSku(), commerceOrderItem.getUnitOfMeasureKey(), (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).put((Object)"shipmentId", (Object)String.valueOf(commerceShipmentItem.getCommerceShipmentId())).put((Object)"shipmentItemId", (Object)String.valueOf(commerceShipmentItemId)).build());
    }

    private void _validate(CommerceOrderItem commerceOrderItem, CommerceShipment commerceShipment, long commerceInventoryWarehouseId, BigDecimal quantity, BigDecimal newQuantity) throws PortalException {
        if (commerceShipment != null && commerceShipment.getStatus() != 0) {
            throw new CommerceShipmentStatusException();
        }
        if (commerceInventoryWarehouseId <= 0L) {
            return;
        }
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (!commerceInventoryWarehouse.isActive()) {
            throw new CommerceShipmentInactiveWarehouseException();
        }
        BigDecimal commerceOrderItemQuantity = commerceOrderItem.getQuantity();
        BigDecimal availableQuantity = commerceOrderItemQuantity.subtract(commerceOrderItem.getShippedQuantity());
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.fetchByC_C_C(commerceShipment.getCommerceShipmentId(), commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (commerceShipmentItem != null) {
            availableQuantity = availableQuantity.add(commerceShipmentItem.getQuantity());
        }
        BigDecimal commerceInventoryWarehouseQuantity = this._commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryWarehouseId);
        if (BigDecimalUtil.gt((BigDecimal)newQuantity, (BigDecimal)quantity) && BigDecimalUtil.gt((BigDecimal)newQuantity, (BigDecimal)availableQuantity) || BigDecimalUtil.gt((BigDecimal)newQuantity, (BigDecimal)commerceInventoryWarehouseQuantity)) {
            throw new CommerceShipmentItemQuantityException();
        }
    }

    private void _validateExternalReferenceCode(long commerceShipmentItemId, long companyId, String externalReferenceCode) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.fetchByERC_C(externalReferenceCode, companyId);
        if (commerceShipmentItem == null) {
            return;
        }
        if (commerceShipmentItem.getCommerceShipmentItemId() != commerceShipmentItemId) {
            throw new DuplicateCommerceShipmentItemException("There is another commerce shipment item with external reference code " + externalReferenceCode);
        }
    }
}

