/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import java.util.Objects;
import java.util.function.ToLongFunction;

public class CommerceOrderWorkflowedModelPermissionLogic
implements ModelResourcePermissionLogic<CommerceOrder> {
    private final ModelResourcePermission<CommerceOrder> _modelResourcePermission;
    private final ToLongFunction<CommerceOrder> _primKeyToLongFunction;

    public CommerceOrderWorkflowedModelPermissionLogic(ModelResourcePermission<CommerceOrder> modelResourcePermission, ToLongFunction<CommerceOrder> primKeyToLongFunction) {
        this._modelResourcePermission = Objects.requireNonNull(modelResourcePermission);
        this._primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
    }

    public Boolean contains(PermissionChecker permissionChecker, String name, CommerceOrder commerceOrder, String actionId) throws PortalException {
        if (commerceOrder.isDraft() || commerceOrder.isScheduled()) {
            if (!actionId.equals("VIEW") || this._modelResourcePermission.contains(permissionChecker, (ClassedModel)commerceOrder, "UPDATE")) {
                return null;
            }
            return false;
        }
        if (commerceOrder.isPending()) {
            return WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)commerceOrder.getGroupId(), (String)name, (long)this._primKeyToLongFunction.applyAsLong(commerceOrder), (String)actionId);
        }
        return null;
    }
}

