/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPSubscriptionInfo;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.product.util.CPSubscriptionType;
import com.liferay.commerce.product.util.CPSubscriptionTypeRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.content.contributor.name=subscriptionInfo"}, service={CPContentContributor.class})
public class SubscriptionInfoCPContentContributor
implements CPContentContributor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CPSubscriptionTypeRegistry _cpSubscriptionTypeRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public String getName() {
        return "subscriptionInfo";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
        if (commerceChannel == null) {
            return jsonObject;
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (cpDefinition.isSubscriptionEnabled()) {
            jsonObject.put("subscriptionInfo", this._getSubscriptionInfo(cpInstance.getCPSubscriptionInfo(), httpServletRequest));
        }
        return jsonObject;
    }

    private String _getPeriodKey(long count, String period) {
        if (count != 1L) {
            return StringUtil.toLowerCase((String)(period + 's'));
        }
        return period;
    }

    private String _getSubscriptionInfo(CPSubscriptionInfo cpSubscriptionInfo, HttpServletRequest httpServletRequest) {
        if (cpSubscriptionInfo == null) {
            return "";
        }
        long maxSubscriptionCycles = cpSubscriptionInfo.getMaxSubscriptionCycles();
        int subscriptionLength = cpSubscriptionInfo.getSubscriptionLength();
        String period = "";
        CPSubscriptionType cpSubscriptionType = this._cpSubscriptionTypeRegistry.getCPSubscriptionType(cpSubscriptionInfo.getSubscriptionType());
        if (cpSubscriptionType != null) {
            period = cpSubscriptionType.getLabel(LocaleUtil.US);
        }
        StringBundler sb = new StringBundler(maxSubscriptionCycles > 0L ? 6 : 3);
        sb.append(this._language.get(httpServletRequest, "payment-subscription"));
        sb.append("(");
        String subscriptionPeriodKey = this._getPeriodKey(subscriptionLength, period);
        String subscriptionMessage = this._language.format(httpServletRequest, "every-x-x", new Object[]{subscriptionLength, subscriptionPeriodKey}, true);
        sb.append(subscriptionMessage);
        sb.append(")");
        if (maxSubscriptionCycles > 0L) {
            long totalLength = (long)subscriptionLength * maxSubscriptionCycles;
            sb.append(" ");
            String durationPeriodKey = this._getPeriodKey(totalLength, period);
            String durationMessage = this._language.format(httpServletRequest, "duration-x-x", new Object[]{totalLength, durationPeriodKey}, true);
            sb.append(durationMessage);
            sb.append(" ");
        }
        return sb.toString();
    }
}

