/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.content.contributor.name=availability"}, service={CPContentContributor.class})
public class AvailabilityCPContentContributor
implements CPContentContributor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public String getName() {
        return "availability";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
        if (commerceChannel == null) {
            return jsonObject;
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        boolean displayAvailability = cpDefinitionInventoryEngine.isDisplayAvailability(cpInstance);
        if (displayAvailability) {
            String availabilityStatus = this._commerceInventoryEngine.getAvailabilityStatus(cpInstance.getCompanyId(), cpInstance.getGroupId(), commerceChannel.getGroupId(), cpDefinitionInventoryEngine.getMinStockQuantity(cpInstance), cpInstance.getSku(), "");
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            jsonObject.put("availability", this._language.get(themeDisplay.getLocale(), availabilityStatus));
            String availabilityDisplayType = "success";
            if (!Objects.equals(availabilityStatus, "available")) {
                availabilityDisplayType = "danger";
            }
            jsonObject.put("availabilityDisplayType", availabilityDisplayType);
        }
        return jsonObject;
    }
}

