/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategyRegistry;
import com.liferay.commerce.internal.price.BaseCommerceProductPriceCalculation;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.price.list.discovery.CommercePriceListDiscovery;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.pricing.modifier.CommercePriceModifierHelper;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceProductPriceCalculation.class})
public class CommerceProductPriceCalculationV2Impl
extends BaseCommerceProductPriceCalculation {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;
    private static final Log _log = LogFactoryUtil.getLog(CommerceProductPriceCalculationV2Impl.class);
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountApplicationStrategyRegistry _commerceDiscountApplicationStrategyRegistry;
    @Reference
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommercePriceModifierHelper _commercePriceModifierHelper;
    @Reference
    private CommerceTierPriceEntryLocalService _commerceTierPriceEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    private ServiceTrackerMap<String, CommercePriceListDiscovery> _serviceTrackerMap;

    public CommerceMoney getBasePrice(long cpInstanceId, CommerceCurrency commerceCurrency, String unitOfMeasureKey) throws PortalException {
        return this.commerceMoneyFactory.create(commerceCurrency, this._getBasePrice(cpInstanceId, commerceCurrency, "price-list", unitOfMeasureKey));
    }

    public CommerceMoney getBasePromoPrice(long cpInstanceId, CommerceCurrency commerceCurrency, String unitOfMeasureKey) throws PortalException {
        return this.commerceMoneyFactory.create(commerceCurrency, this._getBasePrice(cpInstanceId, commerceCurrency, "promotion", unitOfMeasureKey));
    }

    public CommerceProductPrice getCommerceProductPrice(CommerceProductPriceRequest commerceProductPriceRequest) throws PortalException {
        CommerceMoney discountAmountCommerceMoney;
        CommerceDiscountValue commerceDiscountValue;
        long cpInstanceId = commerceProductPriceRequest.getCpInstanceId();
        BigDecimal quantity = commerceProductPriceRequest.getQuantity();
        String unitOfMeasureKey = commerceProductPriceRequest.getUnitOfMeasureKey();
        CommerceContext commerceContext = commerceProductPriceRequest.getCommerceContext();
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, commerceProductPriceRequest.getUnitOfMeasureKey(), commerceContext);
        CommercePriceEntry unitCommercePriceEntry = this._getUnitPriceEntry(commercePriceListId, cpInstanceId, unitOfMeasureKey);
        BigDecimal unitOfMeasureIncrementalOrderQuantity = BigDecimal.ONE;
        if (unitCommercePriceEntry != null && unitCommercePriceEntry.getQuantity() != null) {
            unitOfMeasureIncrementalOrderQuantity = unitCommercePriceEntry.getQuantity();
        }
        CommerceMoney unitPriceCommerceMoney = this._getUnitPrice(unitCommercePriceEntry, commercePriceListId, quantity, commerceContext);
        boolean priceOnApplication = unitPriceCommerceMoney.isPriceOnApplication();
        BigDecimal finalPrice = unitPriceCommerceMoney.getPrice();
        long commercePromoPriceListId = this._getCommercePromoPriceListId(cpInstanceId, commerceContext, unitOfMeasureKey);
        CommerceMoney promoPriceCommerceMoney = this._getPromoPrice(commercePromoPriceListId, cpInstanceId, quantity, unitOfMeasureKey, commerceContext);
        if (!promoPriceCommerceMoney.isEmpty() && BigDecimalUtil.gt((BigDecimal)promoPriceCommerceMoney.getPrice(), (BigDecimal)BigDecimal.ZERO) && (BigDecimalUtil.lt((BigDecimal)promoPriceCommerceMoney.getPrice(), (BigDecimal)unitPriceCommerceMoney.getPrice()) || unitPriceCommerceMoney.isPriceOnApplication())) {
            commercePriceListId = commercePromoPriceListId;
            finalPrice = promoPriceCommerceMoney.getPrice();
            priceOnApplication = priceOnApplication && promoPriceCommerceMoney.isPriceOnApplication();
        } else {
            promoPriceCommerceMoney = this.commerceMoneyFactory.emptyCommerceMoney();
        }
        BigDecimal[] updatedPrices = this.getUpdatedPrices(unitPriceCommerceMoney, promoPriceCommerceMoney, finalPrice, commerceContext, commerceProductPriceRequest.getCommerceOptionValues());
        finalPrice = updatedPrices[2];
        BigDecimal finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        boolean discountsTargetNetPrice = true;
        CommerceChannel commerceChannel = this.commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            discountsTargetNetPrice = commerceChannel.isDiscountsTargetNetPrice();
        }
        BigDecimal baseQuantity = quantity.divide(unitOfMeasureIncrementalOrderQuantity, unitOfMeasureIncrementalOrderQuantity.scale(), RoundingMode.HALF_UP);
        if (discountsTargetNetPrice) {
            commerceDiscountValue = this._getCommerceDiscountValue(cpInstanceId, commercePriceListId, baseQuantity, finalPrice, unitOfMeasureKey, commerceContext);
            finalPrice = finalPrice.multiply(baseQuantity);
            if (commerceDiscountValue != null) {
                discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
                finalPrice = finalPrice.subtract(discountAmountCommerceMoney.getPrice());
            }
            finalPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, finalPrice, false, commerceContext);
        } else {
            commerceDiscountValue = this._getCommerceDiscountValue(cpInstanceId, commercePriceListId, baseQuantity, finalPriceWithTaxAmount, unitOfMeasureKey, commerceContext);
            finalPriceWithTaxAmount = finalPriceWithTaxAmount.multiply(baseQuantity);
            if (commerceDiscountValue != null) {
                discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
                finalPriceWithTaxAmount = finalPriceWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
            }
            finalPrice = this.getConvertedPrice(cpInstanceId, finalPriceWithTaxAmount, true, commerceContext);
        }
        CommerceProductPriceImpl commerceProductPriceImpl = this._getCommerceProductPriceImpl();
        commerceProductPriceImpl.setCommercePriceListId(commercePriceListId);
        commerceProductPriceImpl.setPriceOnApplication(priceOnApplication);
        commerceProductPriceImpl.setQuantity(quantity);
        commerceProductPriceImpl.setUnitOfMeasureKey(unitOfMeasureKey);
        commerceProductPriceImpl.setUnitOfMeasureIncrementalOrderQuantity(unitOfMeasureIncrementalOrderQuantity);
        if (unitPriceCommerceMoney.isEmpty()) {
            if (unitPriceCommerceMoney.isPriceOnApplication()) {
                commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.priceOnApplicationCommerceMoney());
            } else {
                commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.emptyCommerceMoney());
            }
        } else {
            commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[0]));
        }
        if (promoPriceCommerceMoney.isEmpty()) {
            if (promoPriceCommerceMoney.isPriceOnApplication()) {
                commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.priceOnApplicationCommerceMoney());
            } else if (BigDecimalUtil.gt((BigDecimal)updatedPrices[1], (BigDecimal)BigDecimal.ZERO)) {
                commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[1]));
            } else {
                commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.emptyCommerceMoney());
            }
        } else {
            commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), updatedPrices[1]));
        }
        if (discountsTargetNetPrice) {
            commerceProductPriceImpl.setCommerceDiscountValue(commerceDiscountValue);
        } else {
            CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
            commerceProductPriceImpl.setCommerceDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(commerceDiscountValue, updatedPrices[2].multiply(baseQuantity), finalPrice, this.commerceMoneyFactory, RoundingMode.valueOf(commerceCurrency.getRoundingMode())));
        }
        commerceProductPriceImpl.setFinalPrice(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPrice));
        if (commerceProductPriceRequest.isCalculateTax() || this._hasGrossPricePriceList(cpInstanceId, unitOfMeasureKey, commerceContext)) {
            this.setCommerceProductPriceWithTaxAmount(cpInstanceId, finalPriceWithTaxAmount, commerceProductPriceImpl, commerceContext, commerceDiscountValue, discountsTargetNetPrice);
        }
        return commerceProductPriceImpl;
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, BigDecimal quantity, boolean secure, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(Collections.emptyList());
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(secure);
        commerceProductPriceRequest.setUnitOfMeasureKey(unitOfMeasureKey);
        return this.getCommerceProductPrice(commerceProductPriceRequest);
    }

    public CommerceProductPrice getCommerceProductPrice(long cpInstanceId, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceProductPrice(cpInstanceId, quantity, true, unitOfMeasureKey, commerceContext);
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, BigDecimal quantity, boolean secure, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommerceProductPrice commerceProductPrice = this.getCommerceProductPrice(cpInstanceId, quantity, secure, unitOfMeasureKey, commerceContext);
        if (commerceProductPrice == null) {
            return this.commerceMoneyFactory.emptyCommerceMoney();
        }
        if (commerceProductPrice.isPriceOnApplication()) {
            return this.commerceMoneyFactory.priceOnApplicationCommerceMoney();
        }
        return commerceProductPrice.getFinalPrice();
    }

    public CommerceMoney getFinalPrice(long cpInstanceId, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        return this.getFinalPrice(cpInstanceId, quantity, true, unitOfMeasureKey, commerceContext);
    }

    public CommerceMoney getPromoPrice(long cpInstanceId, BigDecimal quantity, CommerceCurrency commerceCurrency, boolean secure, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        return this._getPromoPrice(this._getCommercePromoPriceListId(cpInstanceId, commerceContext, unitOfMeasureKey), cpInstanceId, quantity, unitOfMeasureKey, commerceContext);
    }

    public CommercePriceEntry getUnitCommercePriceEntry(CommerceContext commerceContext, long cpInstanceId, String unitOfMeasureKey) throws PortalException {
        CPInstance cpInstance;
        CommercePriceEntry commercePriceEntry;
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "price-list", unitOfMeasureKey);
        long commercePriceListId = 0L;
        if (commercePriceList != null) {
            commercePriceListId = commercePriceList.getCommercePriceListId();
        }
        if ((commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, (cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId)).getCPInstanceUuid(), unitOfMeasureKey, true)) != null) {
            return commercePriceEntry;
        }
        CommerceCatalog commerceCatalog = cpInstance.getCommerceCatalog();
        CommercePriceList basePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceList(commerceCatalog.getGroupId());
        if (basePriceList != null) {
            return this._commercePriceEntryLocalService.fetchCommercePriceEntry(basePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid(), unitOfMeasureKey, true);
        }
        return null;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, BigDecimal quantity, boolean secure, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = this.commerceMoneyFactory.emptyCommerceMoney();
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            CommerceMoney cpInstanceCommerceMoney = this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, unitOfMeasureKey, commerceContext);
            if (!commerceMoney.isEmpty() && !BigDecimalUtil.lt((BigDecimal)commerceMoney.getPrice(), (BigDecimal)cpInstanceCommerceMoney.getPrice())) continue;
            commerceMoney = cpInstanceCommerceMoney;
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMaxPrice(long cpDefinitionId, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMaxPrice(cpDefinitionId, quantity, true, unitOfMeasureKey, commerceContext);
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, BigDecimal quantity, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = this.commerceMoneyFactory.emptyCommerceMoney();
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            List cpInstanceUnitOfMeasures = this._cpInstanceUnitOfMeasureLocalService.getActiveCPInstanceUnitOfMeasures(cpInstance.getCPInstanceId());
            if (cpInstanceUnitOfMeasures.isEmpty()) {
                commerceMoney = this._getCommerceMoney(commerceMoney, this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, "", commerceContext));
                continue;
            }
            for (CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure : cpInstanceUnitOfMeasures) {
                commerceMoney = this._getCommerceMoney(commerceMoney, this.getUnitPrice(cpInstance.getCPInstanceId(), quantity, commerceContext.getCommerceCurrency(), secure, cpInstanceUnitOfMeasure.getKey(), commerceContext));
            }
        }
        return commerceMoney;
    }

    public CommerceMoney getUnitMinPrice(long cpDefinitionId, BigDecimal quantity, CommerceContext commerceContext) throws PortalException {
        return this.getUnitMinPrice(cpDefinitionId, quantity, true, commerceContext);
    }

    public CommerceMoney getUnitPrice(long cpInstanceId, BigDecimal quantity, CommerceCurrency commerceCurrency, boolean secure, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        long commercePriceListId = this._getCommercePriceListId(cpInstanceId, unitOfMeasureKey, commerceContext);
        return this._getUnitPrice(this._getUnitPriceEntry(commercePriceListId, cpInstanceId, unitOfMeasureKey), commercePriceListId, quantity, commerceContext);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommercePriceListDiscovery.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (commercePriceListDiscovery, emitter) -> emitter.emit((Object)commercePriceListDiscovery.getCommercePriceListDiscoveryKey())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private CommerceDiscountValue _calculateCommerceDiscountValue(BigDecimal[] values, BigDecimal quantity, BigDecimal finalPrice, CommerceContext commerceContext) throws PortalException {
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._getCommerceDiscountApplicationStrategy();
        BigDecimal discountedAmount = commerceDiscountApplicationStrategy.applyCommerceDiscounts(finalPrice, values);
        BigDecimal currentDiscountAmount = finalPrice.subtract(discountedAmount);
        currentDiscountAmount = currentDiscountAmount.setScale(10, roundingMode);
        CommerceMoney discountAmountCommerceMoney = this.commerceMoneyFactory.create(commerceCurrency, currentDiscountAmount.multiply(quantity));
        return new CommerceDiscountValue(0L, discountAmountCommerceMoney, this._getDiscountPercentage(discountedAmount, finalPrice, roundingMode), values);
    }

    private BigDecimal _getBasePrice(long cpInstanceId, CommerceCurrency commerceCurrency, String type, String unitOfMeasureKey) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceListByType(cpInstance.getGroupId(), type);
        if (commercePriceList == null) {
            return BigDecimal.ZERO;
        }
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid(), unitOfMeasureKey, false);
        if (commercePriceEntry == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = commercePriceEntry.getPrice();
        CommerceCurrency priceListCurrency = commercePriceList.getCommerceCurrency();
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        return price;
    }

    private long _getBasePriceListId(CPInstance cpInstance) throws PortalException {
        CommerceCatalog commerceCatalog = cpInstance.getCommerceCatalog();
        CommercePriceList basePriceList = this._commercePriceListLocalService.fetchCatalogBaseCommercePriceList(commerceCatalog.getGroupId());
        if (basePriceList != null) {
            return basePriceList.getCommercePriceListId();
        }
        _log.error((Object)"There is no base price list configured for the current catalog");
        return 0L;
    }

    private CommerceDiscountApplicationStrategy _getCommerceDiscountApplicationStrategy() throws ConfigurationException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String commerceDiscountApplicationStrategyKey = commercePricingConfiguration.commerceDiscountApplicationStrategy();
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._commerceDiscountApplicationStrategyRegistry.get(commerceDiscountApplicationStrategyKey);
        if (commerceDiscountApplicationStrategy == null && _log.isWarnEnabled()) {
            _log.warn((Object)("No commerce discount application strategy specified for " + commerceDiscountApplicationStrategyKey));
        }
        return commerceDiscountApplicationStrategy;
    }

    private CommerceDiscountValue _getCommerceDiscountValue(long cpInstanceId, long commercePriceListId, BigDecimal quantity, BigDecimal finalPrice, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        if (finalPrice == null || BigDecimalUtil.lte((BigDecimal)finalPrice, (BigDecimal)BigDecimal.ZERO)) {
            return null;
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), unitOfMeasureKey, true);
        if (commercePriceEntry == null) {
            return this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, unitOfMeasureKey, commerceContext);
        }
        BigDecimal[] values = new BigDecimal[4];
        if (!commercePriceEntry.isHasTierPrice() && !commercePriceEntry.isDiscountDiscovery()) {
            values[0] = commercePriceEntry.getDiscountLevel1();
            values[1] = commercePriceEntry.getDiscountLevel2();
            values[2] = commercePriceEntry.getDiscountLevel3();
            values[3] = commercePriceEntry.getDiscountLevel4();
            return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
        }
        if (!commercePriceEntry.isBulkPricing()) {
            return this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, unitOfMeasureKey, commerceContext);
        }
        CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.fetchClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity);
        if (commerceTierPriceEntry == null || commerceTierPriceEntry.isDiscountDiscovery()) {
            return this._commerceDiscountCalculation.getProductCommerceDiscountValue(cpInstanceId, quantity, finalPrice, unitOfMeasureKey, commerceContext);
        }
        values[0] = commerceTierPriceEntry.getDiscountLevel1();
        values[1] = commerceTierPriceEntry.getDiscountLevel2();
        values[2] = commerceTierPriceEntry.getDiscountLevel3();
        values[3] = commerceTierPriceEntry.getDiscountLevel4();
        return this._calculateCommerceDiscountValue(values, quantity, finalPrice, commerceContext);
    }

    private CommerceMoney _getCommerceMoney(CommerceMoney commerceMoney, CommerceMoney cpInstanceCommerceMoney) {
        if (commerceMoney.isEmpty()) {
            commerceMoney = cpInstanceCommerceMoney;
        } else if (!cpInstanceCommerceMoney.isPriceOnApplication() && BigDecimalUtil.gt((BigDecimal)commerceMoney.getPrice(), (BigDecimal)cpInstanceCommerceMoney.getPrice())) {
            commerceMoney = cpInstanceCommerceMoney;
        }
        return commerceMoney;
    }

    private CommerceMoney _getCommerceMoney(long commercePriceListId, CommerceCurrency commerceCurrency, BigDecimal price) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommerceCurrency priceListCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        if (priceListCurrency.getCommerceCurrencyId() != commerceCurrency.getCommerceCurrencyId()) {
            price = price.divide(priceListCurrency.getRate(), RoundingMode.valueOf(priceListCurrency.getRoundingMode()));
            price = price.multiply(commerceCurrency.getRate());
        }
        if (price != null) {
            return this.commerceMoneyFactory.create(commerceCurrency, price);
        }
        return this.commerceMoneyFactory.emptyCommerceMoney();
    }

    private BigDecimal _getCommercePrice(long commercePriceListId, CommercePriceEntry commercePriceEntry, BigDecimal quantity) throws PortalException {
        if (commercePriceEntry == null) {
            return null;
        }
        BigDecimal commercePrice = commercePriceEntry.getPrice();
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceEntry.getCommercePriceListId());
        CommercePriceList modifierCommercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commercePriceList.getCommerceCurrencyId());
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCProductInstance(commercePriceEntry.getCProductId(), commercePriceEntry.getCPInstanceUuid());
        if (cpInstance != null && !commercePriceEntry.isHasTierPrice()) {
            if (commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
                commercePrice = this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commercePriceEntry.getPriceCommerceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commercePrice;
        }
        if (commercePriceEntry.isBulkPricing()) {
            CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryLocalService.fetchClosestCommerceTierPriceEntry(commercePriceEntry.getCommercePriceEntryId(), quantity);
            if (commerceTierPriceEntry == null) {
                return commercePriceEntry.getPrice();
            }
            if (cpInstance != null && commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
                return this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), commerceTierPriceEntry.getPriceCommerceMoney(commerceCurrency.getCommerceCurrencyId()));
            }
            return commerceTierPriceEntry.getPrice();
        }
        if (commercePriceEntry.getCommercePriceListId() != commercePriceListId && commercePriceList.isNetPrice() == modifierCommercePriceList.isNetPrice()) {
            return this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), this.commerceMoneyFactory.create(commerceCurrency, commercePrice));
        }
        List commerceTierPriceEntries = this._commerceTierPriceEntryLocalService.getCommerceTierPriceEntries(commercePriceEntry.getCommercePriceEntryId(), quantity);
        if (commerceTierPriceEntries.isEmpty()) {
            return commercePrice;
        }
        commercePrice = BigDecimal.ZERO;
        CommerceTierPriceEntry commerceTierPriceEntry1 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(0);
        BigDecimal totalTierCounter = BigDecimal.ZERO;
        BigDecimal minQuantity1 = commerceTierPriceEntry1.getMinQuantity();
        BigDecimal tierCounter = minQuantity1.subtract(totalTierCounter.add(BigDecimal.ONE));
        BigDecimal currentPrice = commercePriceEntry.getPrice();
        currentPrice = currentPrice.multiply(tierCounter);
        commercePrice = commercePrice.add(currentPrice);
        totalTierCounter = totalTierCounter.add(tierCounter);
        for (int i = 0; i < commerceTierPriceEntries.size() - 1; ++i) {
            CommerceTierPriceEntry commerceTierPriceEntry2 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i);
            currentPrice = commerceTierPriceEntry2.getPrice();
            CommerceTierPriceEntry commerceTierPriceEntry3 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(i + 1);
            BigDecimal minQuantity = commerceTierPriceEntry3.getMinQuantity();
            tierCounter = minQuantity.subtract(totalTierCounter.add(BigDecimal.ONE));
            currentPrice = currentPrice.multiply(tierCounter);
            commercePrice = commercePrice.add(currentPrice);
            totalTierCounter = totalTierCounter.add(tierCounter);
        }
        totalTierCounter = quantity.subtract(totalTierCounter);
        CommerceTierPriceEntry commerceTierPriceEntry2 = (CommerceTierPriceEntry)commerceTierPriceEntries.get(commerceTierPriceEntries.size() - 1);
        currentPrice = commerceTierPriceEntry2.getPrice();
        currentPrice = currentPrice.multiply(totalTierCounter);
        commercePrice = commercePrice.add(currentPrice);
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        return commercePrice.divide(quantity, 10, roundingMode);
    }

    private BigDecimal _getCommercePrice(long cpInstanceId, long commercePriceListId, CommerceMoney unitPriceCommerceMoney) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchCommercePriceList(commercePriceListId);
        if (commercePriceList == null) {
            return null;
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        return this._commercePriceModifierHelper.applyCommercePriceModifier(commercePriceListId, cpInstance.getCPDefinitionId(), unitPriceCommerceMoney);
    }

    private CommercePriceList _getCommercePriceList(long cpInstanceId, CommerceContext commerceContext, String type, String unitOfMeasureKey) throws PortalException {
        long commerceAccountId = CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext);
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this.commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceAccountId, commerceContext.getCommerceChannelId(), 4);
        if (commerceChannelAccountEntryRel != null && commerceChannelAccountEntryRel.isOverrideEligibility()) {
            return this._commercePriceListLocalService.getCommercePriceList(commerceChannelAccountEntryRel.getClassPK());
        }
        CommercePriceListDiscovery commercePriceListDiscovery = this._getCommercePriceListDiscovery(type);
        if (commercePriceListDiscovery == null) {
            return null;
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        long commerceOrderTypeId = 0L;
        if (commerceOrder != null) {
            commerceOrderTypeId = commerceOrder.getCommerceOrderTypeId();
        }
        return commercePriceListDiscovery.getCommercePriceList(cpInstance.getGroupId(), commerceAccountId, commerceContext.getCommerceChannelId(), commerceOrderTypeId, cpInstance.getCPInstanceUuid(), type, unitOfMeasureKey);
    }

    private CommercePriceListDiscovery _getCommercePriceListDiscovery(String type) throws PortalException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String discoveryMethod = "hierarchy";
        if (type.equals("price-list")) {
            discoveryMethod = commercePricingConfiguration.commercePriceListDiscovery();
        } else if (type.equals("promotion")) {
            discoveryMethod = commercePricingConfiguration.commercePromotionDiscovery();
        }
        CommercePriceListDiscovery commercePriceListDiscovery = (CommercePriceListDiscovery)this._serviceTrackerMap.getService((Object)discoveryMethod);
        if (commercePriceListDiscovery == null && _log.isWarnEnabled()) {
            _log.warn((Object)("No commerce price list discovery specified for " + discoveryMethod));
        }
        return commercePriceListDiscovery;
    }

    private long _getCommercePriceListId(long cpInstanceId, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance;
        CommercePriceEntry commercePriceEntry;
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "price-list", unitOfMeasureKey);
        long commercePriceListId = 0L;
        if (commercePriceList != null) {
            commercePriceListId = commercePriceList.getCommercePriceListId();
        }
        if ((commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, (cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId)).getCPInstanceUuid(), unitOfMeasureKey, true)) != null) {
            return commercePriceEntry.getCommercePriceListId();
        }
        boolean hasCommercePriceModifiers = this._commercePriceModifierHelper.hasCommercePriceModifiers(commercePriceListId, cpInstance.getCPDefinitionId());
        if (hasCommercePriceModifiers) {
            return commercePriceListId;
        }
        return this._getBasePriceListId(cpInstance);
    }

    private CommerceProductPriceImpl _getCommerceProductPriceImpl() {
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        commerceProductPriceImpl.setFinalPrice(this.commerceMoneyFactory.emptyCommerceMoney());
        commerceProductPriceImpl.setFinalPriceWithTaxAmount(this.commerceMoneyFactory.emptyCommerceMoney());
        commerceProductPriceImpl.setPriceOnApplication(false);
        commerceProductPriceImpl.setUnitPrice(this.commerceMoneyFactory.emptyCommerceMoney());
        commerceProductPriceImpl.setUnitPriceWithTaxAmount(this.commerceMoneyFactory.emptyCommerceMoney());
        commerceProductPriceImpl.setUnitPromoPrice(this.commerceMoneyFactory.emptyCommerceMoney());
        commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this.commerceMoneyFactory.emptyCommerceMoney());
        return commerceProductPriceImpl;
    }

    private long _getCommercePromoPriceListId(long cpInstanceId, CommerceContext commerceContext, String unitOfMeasureKey) throws PortalException {
        CommercePriceList commercePriceList = this._getCommercePriceList(cpInstanceId, commerceContext, "promotion", unitOfMeasureKey);
        if (commercePriceList != null) {
            return commercePriceList.getCommercePriceListId();
        }
        return 0L;
    }

    private BigDecimal _getDiscountPercentage(BigDecimal discountedAmount, BigDecimal amount, RoundingMode roundingMode) {
        double actualPrice = discountedAmount.doubleValue();
        double originalPrice = amount.doubleValue();
        double percentage = actualPrice / originalPrice;
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private CommerceMoney _getPromoPrice(long commercePriceListId, long cpInstanceId, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        if (commercePriceListId <= 0L) {
            return this.commerceMoneyFactory.emptyCommerceMoney();
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceListId, cpInstance.getCPInstanceUuid(), unitOfMeasureKey, true);
        if (commercePriceEntry != null) {
            if (commercePriceEntry.isPriceOnApplication()) {
                return this.commerceMoneyFactory.priceOnApplicationCommerceMoney();
            }
            BigDecimal promoPrice = this._getCommercePrice(commercePriceListId, commercePriceEntry, quantity);
            if (!commercePriceList.isNetPrice()) {
                promoPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), promoPrice, true, commerceContext);
            }
            return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
        }
        if (!this._commercePriceModifierHelper.hasCommercePriceModifiers(commercePriceListId, cpInstance.getCPDefinitionId())) {
            return this.commerceMoneyFactory.emptyCommerceMoney();
        }
        CommerceMoney unitPriceCommerceMoney = this.getUnitPrice(cpInstanceId, quantity, commerceContext.getCommerceCurrency(), false, unitOfMeasureKey, commerceContext);
        if (unitPriceCommerceMoney.isPriceOnApplication()) {
            return this.commerceMoneyFactory.priceOnApplicationCommerceMoney();
        }
        BigDecimal promoPrice = this._getCommercePrice(cpInstanceId, commercePriceListId, unitPriceCommerceMoney);
        if (!commercePriceList.isNetPrice()) {
            promoPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), promoPrice, true, commerceContext);
        }
        return this._getCommerceMoney(commercePriceListId, commerceContext.getCommerceCurrency(), promoPrice);
    }

    private CommerceMoney _getUnitPrice(CommercePriceEntry commercePriceEntry, long commercePriceListId, BigDecimal quantity, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance;
        if (commercePriceEntry == null) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), BigDecimal.ZERO);
        }
        if (commercePriceEntry.isPriceOnApplication()) {
            return this.commerceMoneyFactory.priceOnApplicationCommerceMoney();
        }
        BigDecimal unitPrice = this._getCommercePrice(commercePriceListId, commercePriceEntry, quantity);
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        if (!commercePriceList.isNetPrice() && (cpInstance = this._cpInstanceLocalService.fetchCProductInstance(commercePriceEntry.getCProductId(), commercePriceEntry.getCPInstanceUuid())) != null) {
            unitPrice = this.getConvertedPrice(cpInstance.getCPInstanceId(), unitPrice, true, commerceContext);
        }
        return this._getCommerceMoney(commercePriceEntry.getCommercePriceListId(), commerceContext.getCommerceCurrency(), unitPrice);
    }

    private CommercePriceEntry _getUnitPriceEntry(long commercePriceListId, long cpInstanceId, String unitOfMeasureKey) throws PortalException {
        if (commercePriceListId == 0L) {
            return null;
        }
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid(), unitOfMeasureKey, true);
        if (commercePriceEntry != null) {
            return commercePriceEntry;
        }
        return this._commercePriceEntryLocalService.fetchCommercePriceEntry(this._getBasePriceListId(cpInstance), cpInstance.getCPInstanceUuid(), unitOfMeasureKey, false);
    }

    private boolean _hasGrossPricePriceList(long cpInstanceId, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.fetchCommercePriceList(this._getCommercePriceListId(cpInstanceId, unitOfMeasureKey, commerceContext));
        if (commercePriceList != null && !commercePriceList.isNetPrice()) {
            return true;
        }
        CommercePriceList commercePromoPriceList = this._commercePriceListLocalService.fetchCommercePriceList(this._getCommercePromoPriceListId(cpInstanceId, commerceContext, unitOfMeasureKey));
        return commercePromoPriceList != null && !commercePromoPriceList.isNetPrice();
    }
}

