/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.util.PriceFormat;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.CommerceProductOptionValueRelativePriceRequest;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceProductPriceCalculation
implements CommerceProductPriceCalculation {
    @Reference
    protected AccountEntryLocalService accountEntryLocalService;
    @Reference
    protected CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService;
    @Reference
    protected CommerceChannelLocalService commerceChannelLocalService;
    @Reference
    protected CommerceMoneyFactory commerceMoneyFactory;
    @Reference
    protected CommerceTaxCalculation commerceTaxCalculation;
    @Reference
    protected CPDefinitionOptionRelLocalService cpDefinitionOptionRelLocalService;
    @Reference
    protected CPInstanceLocalService cpInstanceLocalService;
    @Reference
    protected CPInstanceUnitOfMeasureLocalService cpInstanceUnitOfMeasureLocalService;

    public CommerceMoney getCPDefinitionMinimumPrice(long cpDefinitionId, CommerceContext commerceContext) throws PortalException {
        CommerceMoney commerceMoney = this.getUnitMinPrice(cpDefinitionId, BigDecimal.ONE, commerceContext);
        if (commerceMoney.isEmpty()) {
            return commerceMoney;
        }
        BigDecimal cpDefinitionMinimumPrice = BigDecimal.ZERO;
        cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(commerceMoney.getPrice());
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId);
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (!this._isRequiredPriceContributor(cpDefinitionOptionRel)) continue;
            if (cpDefinitionOptionRel.isPriceTypeStatic()) {
                cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(this._getCPDefinitionOptionMinStaticPrice(cpDefinitionOptionRel, commerceContext));
                continue;
            }
            cpDefinitionMinimumPrice = cpDefinitionMinimumPrice.add(this._getCPDefinitionOptionMinDynamicPrice(cpDefinitionOptionRel, commerceContext));
        }
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), cpDefinitionMinimumPrice);
    }

    public CommerceMoney getCPDefinitionOptionValueRelativePrice(CommerceProductOptionValueRelativePriceRequest commerceProductOptionValueRelativePriceRequest) throws PortalException {
        this._validate(commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel(), commerceProductOptionValueRelativePriceRequest.getSelectedCPDefinitionOptionValueRel());
        BigDecimal relativePrice = BigDecimal.ZERO;
        CommerceContext commerceContext = commerceProductOptionValueRelativePriceRequest.getCommerceContext();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel();
        CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionValueRel.getCPDefinitionOptionRel();
        if (!cpDefinitionOptionRel.isPriceContributor()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), relativePrice, PriceFormat.RELATIVE);
        }
        relativePrice = relativePrice.add(this._getCPInstancePriceDifference(commerceProductOptionValueRelativePriceRequest.getCPInstanceId(), commerceProductOptionValueRelativePriceRequest.getCPInstanceMinQuantity(), commerceProductOptionValueRelativePriceRequest.getCPInstanceUnitOfMeasureKey(), commerceProductOptionValueRelativePriceRequest.getSelectedCPInstanceId(), commerceProductOptionValueRelativePriceRequest.getSelectedCPInstanceMinQuantity(), commerceProductOptionValueRelativePriceRequest.getSelectedCPInstanceUnitOfMeasureKey(), commerceContext));
        relativePrice = relativePrice.add(this._getCPDefinitionOptionValuePriceDifference(commerceProductOptionValueRelativePriceRequest.getCPDefinitionOptionValueRel(), commerceProductOptionValueRelativePriceRequest.getSelectedCPDefinitionOptionValueRel(), cpDefinitionOptionRel.getPriceType(), commerceContext));
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), relativePrice, PriceFormat.RELATIVE);
    }

    protected BigDecimal getConvertedPrice(long cpInstanceId, BigDecimal price, boolean includeTax, CommerceContext commerceContext) throws PortalException {
        long commerceChannelGroupId = commerceContext.getCommerceChannelGroupId();
        long commerceBillingAddressId = 0L;
        long commerceShippingAddressId = 0L;
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        if (commerceOrder != null) {
            commerceChannelGroupId = commerceOrder.getGroupId();
            commerceBillingAddressId = commerceOrder.getBillingAddressId();
            commerceShippingAddressId = commerceOrder.getShippingAddressId();
        } else {
            AccountEntry accountEntry = commerceContext.getAccountEntry();
            if (accountEntry != null) {
                CommerceChannelAccountEntryRel shippingAddressCommerceChannelAccountEntryRel;
                CommerceChannelAccountEntryRel billingAddressCommerceChannelAccountEntryRel = this.commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceContext.getCommerceChannelId(), 2);
                if (billingAddressCommerceChannelAccountEntryRel != null) {
                    commerceBillingAddressId = billingAddressCommerceChannelAccountEntryRel.getClassPK();
                }
                if ((shippingAddressCommerceChannelAccountEntryRel = this.commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceContext.getCommerceChannelId(), 3)) != null) {
                    commerceShippingAddressId = shippingAddressCommerceChannelAccountEntryRel.getClassPK();
                }
            }
        }
        return CommercePriceConverterUtil.getConvertedPrice(commerceChannelGroupId, cpInstanceId, commerceBillingAddressId, commerceShippingAddressId, price, includeTax, this.commerceTaxCalculation);
    }

    protected BigDecimal[] getUpdatedPrices(CommerceMoney unitPriceCommerceMoney, CommerceMoney promoPriceCommerceMoney, BigDecimal finalPrice, CommerceContext commerceContext, List<CommerceOptionValue> commerceOptionValues) throws PortalException {
        if (commerceOptionValues.isEmpty()) {
            return this._toPriceArray(unitPriceCommerceMoney, promoPriceCommerceMoney, finalPrice);
        }
        BigDecimal promoPrice = BigDecimal.ZERO;
        if (!promoPriceCommerceMoney.isEmpty()) {
            promoPrice = promoPriceCommerceMoney.getPrice();
        }
        BigDecimal unitPrice = BigDecimal.ZERO;
        if (!unitPriceCommerceMoney.isEmpty()) {
            unitPrice = unitPriceCommerceMoney.getPrice();
        }
        for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
            BigDecimal price;
            CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure;
            if (this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                BigDecimal optionValuePrice = commerceOptionValue.getPrice();
                if (optionValuePrice == null || !BigDecimalUtil.gt((BigDecimal)optionValuePrice, (BigDecimal)BigDecimal.ZERO)) continue;
                if (commerceOptionValue.getCPInstanceId() > 0L) {
                    optionValuePrice = optionValuePrice.multiply(commerceOptionValue.getQuantity());
                }
                unitPrice = unitPrice.add(optionValuePrice);
                if (BigDecimalUtil.gt((BigDecimal)promoPrice, (BigDecimal)BigDecimal.ZERO)) {
                    promoPrice = promoPrice.add(optionValuePrice);
                }
                finalPrice = finalPrice.add(optionValuePrice);
                continue;
            }
            if (!Objects.equals(commerceOptionValue.getPriceType(), "dynamic") || commerceOptionValue.getCPInstanceId() <= 0L) continue;
            BigDecimal optionValueQuantity = commerceOptionValue.getQuantity();
            CommerceProductPrice optionValueProductPrice = this.getCommerceProductPrice(commerceOptionValue.getCPInstanceId(), optionValueQuantity, true, commerceOptionValue.getUnitOfMeasureKey(), commerceContext);
            CommerceMoney optionValueUnitPriceCommerceMoney = optionValueProductPrice.getUnitPrice();
            BigDecimal optionValueUnitPrice = optionValueUnitPriceCommerceMoney.getPrice();
            CommerceMoney optionValueUnitPromoPriceCommerceMoney = optionValueProductPrice.getUnitPromoPrice();
            BigDecimal optionValueUnitPromoPrice = BigDecimal.ZERO;
            if (!optionValueUnitPromoPriceCommerceMoney.isEmpty()) {
                optionValueUnitPromoPrice = optionValueUnitPromoPriceCommerceMoney.getPrice();
            }
            BigDecimal incrementalOrderQuantity = BigDecimal.ONE;
            if (Validator.isNotNull((String)commerceOptionValue.getUnitOfMeasureKey()) && (cpInstanceUnitOfMeasure = this.cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(commerceOptionValue.getCPInstanceId(), commerceOptionValue.getUnitOfMeasureKey())) != null) {
                incrementalOrderQuantity = cpInstanceUnitOfMeasure.getIncrementalOrderQuantity();
            }
            CommerceCurrency commerceCurrency = optionValueUnitPriceCommerceMoney.getCommerceCurrency();
            int precision = commerceCurrency.getMaxFractionDigits();
            if (BigDecimalUtil.gt((BigDecimal)optionValueUnitPromoPrice, (BigDecimal)BigDecimal.ZERO) && BigDecimalUtil.isZero((BigDecimal)promoPrice)) {
                promoPrice = promoPrice.add(unitPrice);
            } else if (BigDecimalUtil.isZero((BigDecimal)optionValueUnitPromoPrice) && BigDecimalUtil.gt((BigDecimal)promoPrice, (BigDecimal)BigDecimal.ZERO)) {
                price = optionValueUnitPrice.multiply(optionValueQuantity);
                promoPrice = promoPrice.add(price.divide(incrementalOrderQuantity, precision, RoundingMode.HALF_UP));
            }
            price = optionValueUnitPrice.multiply(optionValueQuantity);
            unitPrice = unitPrice.add(price.divide(incrementalOrderQuantity, precision, RoundingMode.HALF_UP));
            price = optionValueUnitPromoPrice.multiply(optionValueQuantity);
            promoPrice = promoPrice.add(price.divide(incrementalOrderQuantity, precision, RoundingMode.HALF_UP));
            CommerceMoney optionValueFinalPriceCommerceMoney = optionValueProductPrice.getFinalPrice();
            finalPrice = finalPrice.add(optionValueFinalPriceCommerceMoney.getPrice());
        }
        return new BigDecimal[]{unitPrice, promoPrice, finalPrice};
    }

    protected void setCommerceProductPriceWithTaxAmount(long cpInstanceId, BigDecimal finalPriceWithTaxAmount, CommerceProductPriceImpl commerceProductPriceImpl, CommerceContext commerceContext, CommerceDiscountValue commerceDiscountValue, boolean discountsTargetNetPrice) throws PortalException {
        BigDecimal unitPriceWithTaxAmount;
        CommerceMoney unitPriceCommerceMoney = commerceProductPriceImpl.getUnitPrice();
        BigDecimal activePrice = unitPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, unitPriceCommerceMoney.getPrice(), false, commerceContext);
        CommerceMoney promoPriceCommerceMoney = commerceProductPriceImpl.getUnitPromoPrice();
        if (!promoPriceCommerceMoney.isEmpty() && BigDecimalUtil.gt((BigDecimal)promoPriceCommerceMoney.getPrice(), (BigDecimal)BigDecimal.ZERO)) {
            BigDecimal unitPromoPriceWithTaxAmount = this.getConvertedPrice(cpInstanceId, promoPriceCommerceMoney.getPrice(), false, commerceContext);
            commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), unitPromoPriceWithTaxAmount));
            activePrice = unitPromoPriceWithTaxAmount;
        } else {
            commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this.commerceMoneyFactory.emptyCommerceMoney());
        }
        commerceProductPriceImpl.setUnitPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), unitPriceWithTaxAmount));
        BigDecimal quantity = commerceProductPriceImpl.getQuantity();
        if (activePrice == null) {
            activePrice = BigDecimal.ZERO;
        }
        if (discountsTargetNetPrice) {
            CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
            activePrice = activePrice.multiply(quantity);
            commerceProductPriceImpl.setCommerceDiscountValueWithTaxAmount(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(commerceDiscountValue, activePrice, finalPriceWithTaxAmount, this.commerceMoneyFactory, RoundingMode.valueOf(commerceCurrency.getRoundingMode())));
        } else {
            commerceProductPriceImpl.setCommerceDiscountValueWithTaxAmount(commerceDiscountValue);
        }
        commerceProductPriceImpl.setFinalPriceWithTaxAmount(this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), finalPriceWithTaxAmount));
    }

    private BigDecimal _getCPDefinitionOptionMinDynamicPrice(CPDefinitionOptionRel cpDefinitionOptionRel, CommerceContext commerceContext) throws PortalException {
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Iterator iterator = cpDefinitionOptionValueRels.iterator();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
        BigDecimal quantity = cpDefinitionOptionValueRel.getQuantity();
        BigDecimal cpDefinitionOptionMinDynamicPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), quantity, cpDefinitionOptionValueRel.getUnitOfMeasureKey(), commerceContext);
        while (iterator.hasNext()) {
            cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
            quantity = cpDefinitionOptionValueRel.getQuantity();
            BigDecimal cpInstanceFinalPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), quantity, cpDefinitionOptionValueRel.getUnitOfMeasureKey(), commerceContext);
            if (!BigDecimalUtil.gt((BigDecimal)cpDefinitionOptionMinDynamicPrice, (BigDecimal)cpInstanceFinalPrice)) continue;
            cpDefinitionOptionMinDynamicPrice = cpInstanceFinalPrice;
        }
        return cpDefinitionOptionMinDynamicPrice;
    }

    private BigDecimal _getCPDefinitionOptionMinStaticPrice(CPDefinitionOptionRel cpDefinitionOptionRel, CommerceContext commerceContext) throws PortalException {
        List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Iterator iterator = cpDefinitionOptionValueRels.iterator();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
        BigDecimal quantity = cpDefinitionOptionValueRel.getQuantity();
        BigDecimal cpDefinitionOptionMinStaticPrice = this._getCPDefinitionOptionValueFinalPrice(cpDefinitionOptionValueRel.getPrice(), quantity);
        while (iterator.hasNext()) {
            cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)iterator.next();
            quantity = cpDefinitionOptionValueRel.getQuantity();
            BigDecimal cpDefinitionOptionValueFinalPrice = this._getCPDefinitionOptionValueFinalPrice(cpDefinitionOptionValueRel.getPrice(), quantity);
            if (!BigDecimalUtil.gt((BigDecimal)cpDefinitionOptionMinStaticPrice, (BigDecimal)cpDefinitionOptionValueFinalPrice)) continue;
            cpDefinitionOptionMinStaticPrice = cpDefinitionOptionValueFinalPrice;
        }
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        return cpDefinitionOptionMinStaticPrice.multiply(commerceCurrency.getRate());
    }

    private BigDecimal _getCPDefinitionOptionValueFinalPrice(BigDecimal price, BigDecimal quantity) {
        return price.multiply(quantity);
    }

    private BigDecimal _getCPDefinitionOptionValuePriceDifference(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, CPDefinitionOptionValueRel selectedCPDefinitionOptionValueRel, String priceType, CommerceContext commerceContext) throws PortalException {
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (this._isStaticPriceType(priceType)) {
            BigDecimal price = cpDefinitionOptionValueRel.getPrice();
            if (selectedCPDefinitionOptionValueRel != null) {
                price = price.subtract(selectedCPDefinitionOptionValueRel.getPrice());
            }
            return price.multiply(commerceCurrency.getRate());
        }
        BigDecimal cpInstanceFinalPrice = this._getCPInstanceFinalPrice(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid(), cpDefinitionOptionValueRel.getQuantity(), cpDefinitionOptionValueRel.getUnitOfMeasureKey(), commerceContext);
        if (selectedCPDefinitionOptionValueRel == null) {
            return cpInstanceFinalPrice;
        }
        BigDecimal selectedCPInstanceFinalPrice = this._getCPInstanceFinalPrice(selectedCPDefinitionOptionValueRel.getCProductId(), selectedCPDefinitionOptionValueRel.getCPInstanceUuid(), selectedCPDefinitionOptionValueRel.getQuantity(), selectedCPDefinitionOptionValueRel.getUnitOfMeasureKey(), commerceContext);
        return cpInstanceFinalPrice.subtract(selectedCPInstanceFinalPrice);
    }

    private BigDecimal _getCPInstanceFinalPrice(long cProductId, String cpInstanceUuid, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.fetchCProductInstance(cProductId, cpInstanceUuid);
        if (cpInstance == null) {
            return BigDecimal.ZERO;
        }
        CommerceMoney commerceMoney = this.getFinalPrice(cpInstance.getCPInstanceId(), quantity, unitOfMeasureKey, commerceContext);
        if (commerceMoney.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return commerceMoney.getPrice();
    }

    private BigDecimal _getCPInstancePriceDifference(long cpInstanceId1, BigDecimal cpInstance1MinQuantity, String cpInstance1UnitOfMeasureKey, long cpInstanceId2, BigDecimal cpInstance2MinQuantity, String cpInstance2UnitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommerceMoney cpInstance2FinalPriceCommerceMoney;
        CommerceMoney cpInstance1FinalPriceCommerceMoney;
        BigDecimal priceDifference = BigDecimal.ZERO;
        if (cpInstanceId1 > 0L && !(cpInstance1FinalPriceCommerceMoney = this.getFinalPrice(cpInstanceId1, cpInstance1MinQuantity, cpInstance1UnitOfMeasureKey, commerceContext)).isEmpty()) {
            priceDifference = priceDifference.add(cpInstance1FinalPriceCommerceMoney.getPrice());
        }
        if (cpInstanceId2 > 0L && !(cpInstance2FinalPriceCommerceMoney = this.getFinalPrice(cpInstanceId2, cpInstance2MinQuantity, cpInstance2UnitOfMeasureKey, commerceContext)).isEmpty()) {
            priceDifference = priceDifference.subtract(cpInstance2FinalPriceCommerceMoney.getPrice());
        }
        return priceDifference;
    }

    private boolean _isRequiredPriceContributor(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return cpDefinitionOptionRel.isPriceContributor() && (cpDefinitionOptionRel.isRequired() || cpDefinitionOptionRel.isSkuContributor());
    }

    private boolean _isStaticPriceType(String value) {
        return Objects.equals(value, "static");
    }

    private BigDecimal[] _toPriceArray(CommerceMoney unitPriceCommerceMoney, CommerceMoney promoPriceCommerceMoney, BigDecimal finalPrice) {
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, finalPrice};
        if (!unitPriceCommerceMoney.isEmpty()) {
            prices[0] = unitPriceCommerceMoney.getPrice();
        }
        if (!promoPriceCommerceMoney.isEmpty()) {
            prices[1] = promoPriceCommerceMoney.getPrice();
        }
        return prices;
    }

    private void _validate(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, CPDefinitionOptionValueRel selectedCPDefinitionOptionValueRel) {
        if (selectedCPDefinitionOptionValueRel != null && cpDefinitionOptionValueRel.getCPDefinitionOptionRelId() != selectedCPDefinitionOptionValueRel.getCPDefinitionOptionRelId()) {
            throw new IllegalArgumentException("Provided CPDefinitionOptionValueRel parameters must belong to the same CPDefinitionOptionRel");
        }
    }
}

