/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.contributor;

import com.liferay.commerce.constants.CommerceReturnConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceReturnThreadLocal;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.object.entry.ObjectEntryContext;
import com.liferay.object.entry.contributor.ObjectEntryValuesContributor;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryValuesContributor.class})
public class CommerceReturnObjectEntryValuesContributor
implements ObjectEntryValuesContributor {
    private static final Log _log = LogFactoryUtil.getLog(CommerceReturnObjectEntryValuesContributor.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public void contribute(ObjectEntryContext objectEntryContext) {
        try {
            this._contribute(objectEntryContext);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _contribute(ObjectEntryContext objectEntryContext) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntryContext.getObjectDefinitionId());
        if (!StringUtil.equals((String)objectDefinition.getName(), (String)"CommerceReturn")) {
            return;
        }
        Map values = objectEntryContext.getValues();
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(GetterUtil.getLong(values.get("commerceOrderId")));
        values.put("channelGroupId", commerceOrder.getGroupId());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        values.put("channelId", commerceChannel.getCommerceChannelId());
        values.put("channelName", commerceChannel.getName());
        if (!values.containsKey("c_commerceReturnId") && !values.containsKey("externalReferenceCode")) {
            return;
        }
        ObjectEntry originalObjectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong(values.get("c_commerceReturnId")));
        if (originalObjectEntry == null) {
            originalObjectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getString(values.get("externalReferenceCode")), objectDefinition.getObjectDefinitionId());
        }
        Map originalValues = originalObjectEntry.getValues();
        String currentReturnStatus = GetterUtil.getString(originalValues.get("returnStatus"));
        String newReturnStatus = GetterUtil.getString(values.get("returnStatus"));
        if (StringUtil.equalsIgnoreCase((String)currentReturnStatus, (String)"draft") && StringUtil.equalsIgnoreCase((String)newReturnStatus, (String)"pending")) {
            return;
        }
        List objectEntries = this._objectEntryLocalService.getOneToManyObjectEntries(originalObjectEntry.getGroupId(), this._objectRelationshipLocalService.getObjectRelationship(originalObjectEntry.getObjectDefinitionId(), "commerceReturnToCommerceReturnItems").getObjectRelationshipId(), originalObjectEntry.getObjectEntryId(), true, null, -1, -1);
        Map<String, List<ObjectEntry>> returnItemStatusObjectEntriesMap = this._toReturnItemStatusObjectEntriesMap(objectEntries);
        if (CommerceReturnThreadLocal.isMarkAsCompleted()) {
            CommerceReturnThreadLocal.setMarkAsCompleted((boolean)false);
            for (ObjectEntry objectEntry : returnItemStatusObjectEntriesMap.getOrDefault("processedReturnItems", Collections.emptyList())) {
                Map objectEntryValues = objectEntry.getValues();
                objectEntryValues.put("returnItemStatus", "completed");
                CommerceReturnThreadLocal.setSkipCommerceReturnItemContributor((boolean)true);
                this._objectEntryLocalService.updateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntryValues, new ServiceContext());
            }
            values.put("returnStatus", "completed");
            return;
        }
        if (CommerceReturnThreadLocal.isMarkAsProcessed()) {
            CommerceReturnThreadLocal.setMarkAsProcessed((boolean)false);
            for (ObjectEntry objectEntry : returnItemStatusObjectEntriesMap.getOrDefault("toBeProcessedReturnItems", Collections.emptyList())) {
                Map objectEntryValues = objectEntry.getValues();
                objectEntryValues.put("returnItemStatus", "processed");
                CommerceReturnThreadLocal.setSkipCommerceReturnItemContributor((boolean)true);
                this._objectEntryLocalService.updateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntryValues, new ServiceContext());
            }
            return;
        }
        String nextReturnStatus = this._getNextReturnStatus(objectEntries.size(), currentReturnStatus, returnItemStatusObjectEntriesMap);
        if (StringUtil.equals((String)currentReturnStatus, (String)nextReturnStatus)) {
            return;
        }
        if (StringUtil.equals((String)nextReturnStatus, (String)"authorized")) {
            for (ObjectEntry objectEntry : returnItemStatusObjectEntriesMap.getOrDefault("authorizedReturnItems", Collections.emptyList())) {
                Map objectEntryValues = objectEntry.getValues();
                objectEntryValues.put("returnItemStatus", "awaitingReceipt");
                CommerceReturnThreadLocal.setSkipCommerceReturnItemContributor((boolean)true);
                this._objectEntryLocalService.updateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntryValues, new ServiceContext());
            }
        }
        values.put("returnStatus", nextReturnStatus);
    }

    private String _getNextReturnStatus(int commerceReturnItemsSize, String currentReturnStatus, Map<String, List<ObjectEntry>> returnItemStatusObjectEntriesMap) {
        List notAuthorizedReturnItemObjectEntries = returnItemStatusObjectEntriesMap.getOrDefault("notAuthorizedReturnItems", Collections.emptyList());
        List receiptRejectedReturnItemObjectEntries = returnItemStatusObjectEntriesMap.getOrDefault("receiptRejectedReturnItems", Collections.emptyList());
        List receivedReturnItemObjectEntries = returnItemStatusObjectEntriesMap.getOrDefault("receivedReturnItems", Collections.emptyList());
        List toBeProcessedReturnItemObjectEntries = returnItemStatusObjectEntriesMap.getOrDefault("toBeProcessedReturnItems", Collections.emptyList());
        if (StringUtil.equalsIgnoreCase((String)currentReturnStatus, (String)"authorized")) {
            if (commerceReturnItemsSize == notAuthorizedReturnItemObjectEntries.size() + receiptRejectedReturnItemObjectEntries.size()) {
                return "rejected";
            }
            int count = ListUtil.count(receivedReturnItemObjectEntries, receivedReturnItemObjectEntry -> {
                Map values = receivedReturnItemObjectEntry.getValues();
                return Validator.isNotNull(values.get("returnResolutionMethod"));
            });
            if (commerceReturnItemsSize == count || ListUtil.isNotEmpty(toBeProcessedReturnItemObjectEntries)) {
                return "processing";
            }
        }
        if (StringUtil.equalsIgnoreCase((String)currentReturnStatus, (String)"pending")) {
            if (!toBeProcessedReturnItemObjectEntries.isEmpty() && commerceReturnItemsSize == notAuthorizedReturnItemObjectEntries.size() + toBeProcessedReturnItemObjectEntries.size()) {
                return "processing";
            }
            if (commerceReturnItemsSize == notAuthorizedReturnItemObjectEntries.size()) {
                return "rejected";
            }
            List authorizedReturnItemObjectEntries = returnItemStatusObjectEntriesMap.getOrDefault("authorizedReturnItems", Collections.emptyList());
            if (commerceReturnItemsSize == authorizedReturnItemObjectEntries.size() + notAuthorizedReturnItemObjectEntries.size() + receivedReturnItemObjectEntries.size() + toBeProcessedReturnItemObjectEntries.size()) {
                return "authorized";
            }
        }
        if (StringUtil.equalsIgnoreCase((String)currentReturnStatus, (String)"processing") && commerceReturnItemsSize == notAuthorizedReturnItemObjectEntries.size() + receiptRejectedReturnItemObjectEntries.size()) {
            return "rejected";
        }
        return currentReturnStatus;
    }

    private Map<String, List<ObjectEntry>> _toReturnItemStatusObjectEntriesMap(List<ObjectEntry> objectEntries) {
        HashMap<String, List<ObjectEntry>> returnItemStatusObjectEntriesMap = new HashMap<String, List<ObjectEntry>>();
        for (ObjectEntry objectEntry : objectEntries) {
            String key = null;
            Map values = objectEntry.getValues();
            String returnItemStatus = GetterUtil.getString(values.get("returnItemStatus"));
            if (ArrayUtil.contains((Object[])CommerceReturnConstants.RETURN_ITEM_STATUSES_AUTHORIZED, (Object)returnItemStatus)) {
                key = "authorizedReturnItems";
            } else if (StringUtil.equals((String)returnItemStatus, (String)"notAuthorized")) {
                key = "notAuthorizedReturnItems";
            } else if (StringUtil.equals((String)returnItemStatus, (String)"processed")) {
                key = "processedReturnItems";
            } else if (StringUtil.equals((String)returnItemStatus, (String)"receiptRejected")) {
                key = "receiptRejectedReturnItems";
            } else if (ArrayUtil.contains((Object[])CommerceReturnConstants.RETURN_ITEM_STATUSES_RECEIVED, (Object)returnItemStatus)) {
                key = "receivedReturnItems";
            } else if (StringUtil.equals((String)returnItemStatus, (String)"toBeProcessed")) {
                key = "toBeProcessedReturnItems";
            }
            if (Validator.isNull((String)key)) continue;
            ArrayList<ObjectEntry> returnItemStatusObjectEntries = (ArrayList<ObjectEntry>)returnItemStatusObjectEntriesMap.get(key);
            if (returnItemStatusObjectEntries == null) {
                returnItemStatusObjectEntries = new ArrayList<ObjectEntry>();
            }
            returnItemStatusObjectEntries.add(objectEntry);
            returnItemStatusObjectEntriesMap.put(key, returnItemStatusObjectEntries);
        }
        return returnItemStatusObjectEntriesMap;
    }
}

