/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.contributor;

import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceReturnThreadLocal;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.object.entry.ObjectEntryContext;
import com.liferay.object.entry.contributor.ObjectEntryValuesContributor;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryValuesContributor.class})
public class CommerceReturnItemObjectEntryValuesContributor
implements ObjectEntryValuesContributor {
    private static final Log _log = LogFactoryUtil.getLog(CommerceReturnItemObjectEntryValuesContributor.class);
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    public void contribute(ObjectEntryContext objectEntryContext) {
        try {
            this._contribute(objectEntryContext);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _contribute(ObjectEntryContext objectEntryContext) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntryContext.getObjectDefinitionId());
        if (!StringUtil.equals((String)objectDefinition.getName(), (String)"CommerceReturnItem")) {
            return;
        }
        Map values = objectEntryContext.getValues();
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(GetterUtil.getLong(values.get("r_commerceOrderItemToCommerceReturnItems_commerceOrderItemId")));
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommerceOrderItemPrice commerceOrderItemPrice = this._commerceOrderPriceCalculation.getCommerceOrderItemPricePerUnit(commerceOrder.getCommerceCurrency(), commerceOrderItem);
        CommerceMoney commerceMoney = commerceOrderItemPrice.getFinalPrice();
        values.put("amount", BigDecimalUtil.multiply((Number)new BigDecimal(String.valueOf(values.get("quantity"))), (Number)commerceMoney.getPrice()));
        if (CommerceReturnThreadLocal.isSkipCommerceReturnItemContributor()) {
            CommerceReturnThreadLocal.setSkipCommerceReturnItemContributor((boolean)false);
            return;
        }
        ObjectEntry originalObjectEntry = this._objectEntryLocalService.getObjectEntry(GetterUtil.getLong(values.get("r_commerceReturnToCommerceReturnItems_c_commerceReturnId")));
        Map originalValues = originalObjectEntry.getValues();
        String returnStatus = GetterUtil.getString(originalValues.get("returnStatus"));
        if (StringUtil.equals((String)returnStatus, (String)"draft")) {
            return;
        }
        values.put("returnItemStatus", this._getNextReturnItemStatus(values, returnStatus));
    }

    private String _getNextReturnItemStatus(Map<String, Serializable> values, String returnStatus) {
        long authorized = GetterUtil.getLong((Object)values.get("authorized"));
        if (authorized == 0L) {
            return "notAuthorized";
        }
        if (GetterUtil.getBoolean((Object)values.get("authorizeReturnWithoutReturningProducts"))) {
            if (Validator.isNotNull((String)String.valueOf(values.get("returnResolutionMethod")))) {
                return "toBeProcessed";
            }
            return "received";
        }
        long received = GetterUtil.getLong((Object)values.get("received"));
        if (received == 0L) {
            if (StringUtil.equals((String)returnStatus, (String)"pending")) {
                long quantity = GetterUtil.getLong((Object)values.get("quantity"));
                if (authorized < quantity) {
                    return "partiallyAuthorized";
                }
                if (authorized == quantity) {
                    return "authorized";
                }
            }
            if (StringUtil.equals((String)returnStatus, (String)"authorized") && authorized > 0L) {
                return "receiptRejected";
            }
        }
        if (Validator.isNotNull((String)String.valueOf(values.get("returnResolutionMethod")))) {
            return "toBeProcessed";
        }
        if (received < authorized) {
            return "partiallyReceived";
        }
        return "received";
    }
}

