/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.base.CommerceShipmentItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceShipmentItem"}, service={AopService.class})
public class CommerceShipmentItemServiceImpl
extends CommerceShipmentItemServiceBaseImpl {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.commerce.shipment)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceShipmentItem addCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, BigDecimal quantity, String unitOfMeasureKey, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.addCommerceShipmentItem(externalReferenceCode, commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, quantity, unitOfMeasureKey, validateInventory, serviceContext);
    }

    public CommerceShipmentItem addOrUpdateCommerceShipmentItem(String externalReferenceCode, long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId, BigDecimal quantity, String unitOfMeasureKey, boolean validateInventory, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.addOrUpdateCommerceShipmentItem(externalReferenceCode, commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId, quantity, unitOfMeasureKey, validateInventory, serviceContext);
    }

    @Deprecated
    public void deleteCommerceShipmentItem(long commerceShipmentItemId) throws PortalException {
        this.deleteCommerceShipmentItem(commerceShipmentItemId, false);
    }

    public void deleteCommerceShipmentItem(long commerceShipmentItemId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentItem commerceShipmentItem = this.commerceShipmentItemPersistence.findByPrimaryKey(commerceShipmentItemId);
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItem(commerceShipmentItem, restoreStockQuantity);
    }

    public void deleteCommerceShipmentItems(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItems(commerceShipmentId, restoreStockQuantity);
    }

    public CommerceShipmentItem fetchCommerceShipmentItem(long commerceShipmentId, long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.fetchCommerceShipmentItem(commerceShipmentId, commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public CommerceShipmentItem fetchCommerceShipmentItemByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.fetchCommerceShipmentItemByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public CommerceShipmentItem getCommerceShipmentItem(long commerceShipmentItemId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItem(commerceShipmentItemId);
    }

    @Deprecated
    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceOrderItemId) throws PortalException {
        return this.commerceShipmentItemService.getCommerceShipmentItemsByCommerceOrderItemId(commerceOrderItemId);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItems(long commerceShipmentId, int start, int end, OrderByComparator<CommerceShipmentItem> orderByComparator) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, start, end, orderByComparator);
    }

    public List<CommerceShipmentItem> getCommerceShipmentItemsByCommerceOrderItemId(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsByCommerceOrderItemId(commerceOrderItemId);
    }

    public int getCommerceShipmentItemsCount(long commerceShipmentId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsCount(commerceShipmentId);
    }

    public int getCommerceShipmentItemsCountByCommerceOrderItemId(long commerceOrderItemId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentItemsCountByCommerceOrderItemId(commerceOrderItemId);
    }

    public BigDecimal getCommerceShipmentOrderItemsQuantity(long commerceShipmentId, long commerceOrderItemId) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.getCommerceShipmentOrderItemsQuantity(commerceShipmentId, commerceOrderItemId);
    }

    public CommerceShipmentItem updateCommerceShipmentItem(long commerceShipmentItemId, long commerceInventoryWarehouseId, BigDecimal quantity, boolean validateInventory) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.updateCommerceShipmentItem(commerceShipmentItemId, commerceInventoryWarehouseId, quantity, validateInventory);
    }

    public CommerceShipmentItem updateExternalReferenceCode(long commerceShipmentItemId, String externalReferenceCode) throws PortalException {
        this._portletResourcePermission.contains(this.getPermissionChecker(), null, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentItemLocalService.updateExternalReferenceCode(commerceShipmentItemId, externalReferenceCode);
    }
}

