/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.base.CommerceOrderServiceBaseImpl;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceOrder"}, service={AopService.class})
public class CommerceOrderServiceImpl
extends CommerceOrderServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.order)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId) throws PortalException {
        AccountEntry accountEntry = this._getAccountEntry(commerceAccountId);
        if (accountEntry.isBusinessAccount()) {
            this._portletResourcePermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryGroupId(), "ADD_COMMERCE_ORDER");
        }
        return this.commerceOrderLocalService.addCommerceOrder(this.getUserId(), groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId);
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (commerceOrder == null) {
            AccountEntry accountEntry = this._getAccountEntry(commerceAccountId);
            if (accountEntry.isBusinessAccount()) {
                this._portletResourcePermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryGroupId(), "ADD_COMMERCE_ORDER");
            }
        } else {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE");
        }
        return this.commerceOrderLocalService.addOrUpdateCommerceOrder(externalReferenceCode, this.getUserId(), groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, 0, 0, 0, 0, 0, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "DELETE");
        this.commerceOrderLocalService.deleteCommerceOrder(commerceOrderId);
    }

    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.executeWorkflowTransition(this.getUserId(), commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public CommerceOrder fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrder != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceOrderId);
        if (commerceOrder != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
        if (commerceOrder != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
        if (commerceOrder != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
        if (commerceOrder != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        }
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceOrder, "VIEW");
        return commerceOrder;
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public int getCommerceOrdersCount(long groupId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "MANAGE_COMMERCE_ORDERS");
        return this.commerceOrderLocalService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false, start, end);
    }

    public long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, "", new int[]{2}, false);
    }

    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_OPEN_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false);
    }

    public List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, "", new int[]{2}, true, start, end);
    }

    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, true, start, end);
    }

    public long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, "", new int[]{2}, true);
    }

    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        this._checkAccountOrder(groupId, commerceAccountId, "VIEW_COMMERCE_ORDERS");
        Group group = this._groupLocalService.getGroup(groupId);
        return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, true);
    }

    public List<CommerceOrder> getUserCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{-1}, true, start, end);
    }

    public long getUserCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{-1}, true);
    }

    public List<CommerceOrder> getUserOpenCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, false, start, end, sort);
    }

    public List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this.commerceOrderService.getUserOpenCommerceOrders(companyId, groupId, keywords, start, end, null);
    }

    public long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, false);
    }

    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this.getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end, null);
    }

    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, true, start, end, sort);
    }

    public long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        long[] commerceAccountIds = this._getCommerceAccountIds(groupId);
        return this.commerceOrderLocalService.getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, new int[]{2}, true);
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), guestCommerceOrderId, "VIEW");
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), userCommerceOrderId, "UPDATE");
        this.commerceOrderLocalService.mergeGuestCommerceOrder(this.getUserId(), guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
    }

    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderLocalService.reorderCommerceOrder(this.getUserId(), commerceOrderId, commerceContext);
    }

    public CommerceOrder resetCommerceOrderAddresses(long commerceOrderId, boolean billingAddress, boolean shippingAddress) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.resetCommerceOrderAddresses(commerceOrderId, billingAddress, shippingAddress);
    }

    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean deliveryCommerceTermEntry, boolean paymentCommerceTermEntry) throws PortalException {
        if (deliveryCommerceTermEntry) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS");
        }
        if (paymentCommerceTermEntry) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS");
        }
        return this.commerceOrderLocalService.resetTermsAndConditions(commerceOrderId, deliveryCommerceTermEntry, paymentCommerceTermEntry);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, billingAddressId);
    }

    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrder.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(commerceOrder);
    }

    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount, CommerceContext commerceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, totalDiscountAmount, commerceContext);
    }

    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total, CommerceContext commerceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, purchaseOrderNumber, shippingAmount, shippingOptionName, subtotal, total, commerceContext);
    }

    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceOrderExternalReferenceCode(externalReferenceCode, commerceOrderId);
    }

    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, shippingDiscountPercentageLevel1WithTaxAmount, shippingDiscountPercentageLevel2WithTaxAmount, shippingDiscountPercentageLevel3WithTaxAmount, shippingDiscountPercentageLevel4WithTaxAmount, shippingDiscountWithTaxAmount, shippingWithTaxAmount, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, subtotalDiscountPercentageLevel1WithTaxAmount, subtotalDiscountPercentageLevel2WithTaxAmount, subtotalDiscountPercentageLevel3WithTaxAmount, subtotalDiscountPercentageLevel4WithTaxAmount, subtotalDiscountWithTaxAmount, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, totalDiscountPercentageLevel1WithTaxAmount, totalDiscountPercentageLevel2WithTaxAmount, totalDiscountPercentageLevel3WithTaxAmount, totalDiscountPercentageLevel4WithTaxAmount, totalDiscountWithTaxAmount, totalWithTaxAmount);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "CHECKOUT_COMMERCE_ORDER");
        return this.commerceOrderLocalService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateCommerceShippingMethod(commerceOrderId, commerceShippingMethodId, commerceShippingOptionName, commerceContext, locale);
    }

    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Deprecated
    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePrintedNote(commerceOrderId, printedNote);
    }

    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderLocalService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        if (deliveryCommerceTermEntryId > 0L) {
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS");
        }
        if (paymentCommerceTermEntryId > 0L) {
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS");
        }
        return this.commerceOrderLocalService.updateTermsAndConditions(commerceOrderId, deliveryCommerceTermEntryId, paymentCommerceTermEntryId, languageId);
    }

    private void _checkAccountOrder(long groupId, long accountEntryId, String action) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
        if (accountEntry == null) {
            this._portletResourcePermission.check(this.getPermissionChecker(), groupId, action);
        } else if (accountEntry.isBusinessAccount()) {
            this._portletResourcePermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryGroup(), action);
        }
    }

    private AccountEntry _getAccountEntry(long accountEntryId) throws PortalException {
        User user = this.getUser();
        if (user == null || user.isGuestUser()) {
            return this._accountEntryLocalService.getGuestAccountEntry(user.getCompanyId());
        }
        return this._accountEntryLocalService.getAccountEntry(accountEntryId);
    }

    private long[] _getCommerceAccountIds(long groupId) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceOrderModelResourcePermission.getPortletResourcePermission();
        if (!portletResourcePermission.contains(this.getPermissionChecker(), groupId, "MANAGE_ALL_ACCOUNTS")) {
            return this._commerceAccountHelper.getUserCommerceAccountIds(this.getUserId(), groupId);
        }
        return null;
    }
}

