/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.base;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.commerce.service.persistence.CommerceShipmentFinder;
import com.liferay.commerce.service.persistence.CommerceShipmentPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class CommerceShipmentLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
CommerceShipmentLocalService,
IdentifiableOSGiService {
    protected CommerceShipmentLocalService commerceShipmentLocalService;
    @Reference
    protected CommerceShipmentPersistence commerceShipmentPersistence;
    @Reference
    protected CommerceShipmentFinder commerceShipmentFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceShipment(CommerceShipment commerceShipment) {
        commerceShipment.setNew(true);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Transactional(enabled=false)
    public CommerceShipment createCommerceShipment(long commerceShipmentId) {
        return this.commerceShipmentPersistence.create(commerceShipmentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceShipment deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        return this.commerceShipmentPersistence.remove(commerceShipmentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceShipment deleteCommerceShipment(CommerceShipment commerceShipment) {
        return (CommerceShipment)this.commerceShipmentPersistence.remove((BaseModel)commerceShipment);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.commerceShipmentPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(CommerceShipment.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.commerceShipmentPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.commerceShipmentPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.commerceShipmentPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.commerceShipmentPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.commerceShipmentPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public CommerceShipment fetchCommerceShipment(long commerceShipmentId) {
        return this.commerceShipmentPersistence.fetchByPrimaryKey(commerceShipmentId);
    }

    public CommerceShipment fetchCommerceShipmentByUuidAndGroupId(String uuid, long groupId) {
        return this.commerceShipmentPersistence.fetchByUUID_G(uuid, groupId);
    }

    public CommerceShipment fetchCommerceShipmentByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.commerceShipmentPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public CommerceShipment getCommerceShipmentByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.commerceShipmentPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        return this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.commerceShipmentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(CommerceShipment.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("commerceShipmentId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.commerceShipmentLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(CommerceShipment.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("commerceShipmentId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.commerceShipmentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(CommerceShipment.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("commerceShipmentId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<CommerceShipment>(){

            public void performAction(CommerceShipment commerceShipment) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)commerceShipment);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)CommerceShipment.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.commerceShipmentPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement CommerceShipmentLocalServiceImpl#deleteCommerceShipment(CommerceShipment) to avoid orphaned data");
        }
        return this.commerceShipmentLocalService.deleteCommerceShipment((CommerceShipment)persistedModel);
    }

    public BasePersistence<CommerceShipment> getBasePersistence() {
        return this.commerceShipmentPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.commerceShipmentPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<CommerceShipment> getCommerceShipmentsByUuidAndCompanyId(String uuid, long companyId) {
        return this.commerceShipmentPersistence.findByUuid_C(uuid, companyId);
    }

    public List<CommerceShipment> getCommerceShipmentsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public CommerceShipment getCommerceShipmentByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.commerceShipmentPersistence.findByUUID_G(uuid, groupId);
    }

    public List<CommerceShipment> getCommerceShipments(int start, int end) {
        return this.commerceShipmentPersistence.findAll(start, end);
    }

    public int getCommerceShipmentsCount() {
        return this.commerceShipmentPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCommerceShipment(CommerceShipment commerceShipment) {
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{CommerceShipmentLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.commerceShipmentLocalService = (CommerceShipmentLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return CommerceShipmentLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return CommerceShipment.class;
    }

    protected String getModelClassName() {
        return CommerceShipment.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.commerceShipmentPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

