/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration"}, service={CommerceOrderItemQuantityFormatter.class})
public class CommerceOrderItemQuantityFormatterImpl
implements CommerceOrderItemQuantityFormatter {
    private volatile CommerceOrderItemDecimalQuantityConfiguration _commerceOrderItemDecimalQuantityConfiguration;

    public String format(CommerceOrderItem commerceOrderItem, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, Locale locale) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = commerceOrderItem.fetchCPMeasurementUnit();
        DecimalFormat decimalFormat = this._getDecimalFormat(true, true, locale);
        BigDecimal quantity = commerceOrderItem.getQuantity();
        if (cpMeasurementUnit != null) {
            return StringBundler.concat((String[])new String[]{decimalFormat.format(quantity), " ", cpMeasurementUnit.getName(locale)});
        }
        if (cpInstanceUnitOfMeasure != null) {
            return decimalFormat.format(quantity.setScale(cpInstanceUnitOfMeasure.getPrecision(), RoundingMode.HALF_UP));
        }
        return decimalFormat.format(quantity);
    }

    public String format(CommerceOrderItem commerceOrderItem, Locale locale) throws PortalException {
        DecimalFormat decimalFormat = this._getDecimalFormat(true, false, locale);
        return decimalFormat.format(commerceOrderItem.getQuantity());
    }

    public BigDecimal parse(ActionRequest actionRequest, String param) throws Exception {
        String quantity = ParamUtil.getString((PortletRequest)actionRequest, (String)param, (String)BigDecimal.ZERO.toString());
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.parse(quantity, themeDisplay.getLocale());
    }

    public BigDecimal parse(String quantity, Locale locale) throws Exception {
        if (Validator.isNull((String)quantity)) {
            quantity = BigDecimal.ZERO.toString();
        }
        DecimalFormat decimalFormat = this._getDecimalFormat(true, true, locale);
        return (BigDecimal)decimalFormat.parse(quantity);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderItemDecimalQuantityConfiguration = (CommerceOrderItemDecimalQuantityConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderItemDecimalQuantityConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._commerceOrderItemDecimalQuantityConfiguration = null;
    }

    private DecimalFormat _getDecimalFormat(boolean maximumFractionDigits, boolean minimumFractionDigits, Locale locale) {
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00", DecimalFormatSymbols.getInstance(locale));
        if (maximumFractionDigits) {
            decimalFormat.setMaximumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.maximumFractionDigits());
        }
        if (minimumFractionDigits) {
            decimalFormat.setMinimumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.minimumFractionDigits());
        }
        decimalFormat.setParseBigDecimal(true);
        decimalFormat.setRoundingMode(this._commerceOrderItemDecimalQuantityConfiguration.roundingMode());
        return decimalFormat;
    }
}

