/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v9_3_0;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import org.apache.felix.cm.file.ConfigurationHandler;

public class ConfigurationUpgradeProcess
extends UpgradeProcess {
    public void doUpgrade() throws Exception {
        if (!this.hasTable("Configuration_")) {
            return;
        }
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from Configuration_ where configurationId LIKE '%com.liferay.commerce.account%'");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Configuration_ set configurationId = ?, dictionary = ? where configurationId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String serviceFactoryPid;
                String dictionaryString = resultSet.getString("dictionary");
                if (Validator.isNull((String)dictionaryString)) continue;
                Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
                String configurationId = resultSet.getString("configurationId");
                String servicePid = (String)dictionary.get("service.pid");
                if (servicePid != null) {
                    dictionary.put("service.pid", StringUtil.replace((String)servicePid, (String)"com.liferay.commerce.account", (String)"com.liferay.commerce"));
                }
                if ((serviceFactoryPid = (String)dictionary.get("service.factoryPid")) != null) {
                    dictionary.put("service.factoryPid", StringUtil.replace((String)serviceFactoryPid, (String)"com.liferay.commerce.account", (String)"com.liferay.commerce"));
                }
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ConfigurationHandler.write((OutputStream)unsyncByteArrayOutputStream, (Dictionary)dictionary);
                preparedStatement2.setString(1, StringUtil.replace((String)configurationId, (String)"com.liferay.commerce.account", (String)"com.liferay.commerce"));
                preparedStatement2.setString(2, unsyncByteArrayOutputStream.toString());
                preparedStatement2.setString(3, configurationId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

