/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_7_1;

import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryLocalService;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class AccountEntryUpgradeProcess
extends UpgradeProcess {
    private final AddressLocalService _addressLocalService;
    private final CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    private final CommerceTermEntryLocalService _commerceTermEntryLocalService;

    public AccountEntryUpgradeProcess(AddressLocalService addressLocalService, CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService, CommerceTermEntryLocalService commerceTermEntryLocalService) {
        this._addressLocalService = addressLocalService;
        this._commerceChannelAccountEntryRelLocalService = commerceChannelAccountEntryRelLocalService;
        this._commerceTermEntryLocalService = commerceTermEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (this.hasColumn("AccountEntry", "defaultBillingAddressId") && this.hasColumn("AccountEntry", "defaultShippingAddressId")) {
            this._updateDefaultAddresses();
        }
        if (this.hasColumn("AccountEntry", "defaultDeliveryCTermEntryId") && this.hasColumn("AccountEntry", "defaultPaymentCTermEntryId")) {
            this._updateDefaultCommerceTermEntries();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"AccountEntry", (String[])new String[]{"defaultDeliveryCTermEntryId", "defaultPaymentCTermEntryId"})};
    }

    private void _updateDefaultAddresses() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select accountEntryId, userId, defaultBillingAddressId, defaultShippingAddressId from AccountEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                CommerceChannelAccountEntryRel existingCommerceChannelAccountEntryRel;
                long defaultShippingAddressId;
                Address shippingAddress;
                long userId = resultSet.getLong("userId");
                long accountEntryId = resultSet.getLong("accountEntryId");
                long defaultBillingAddressId = resultSet.getLong("defaultBillingAddressId");
                Address billingAddress = this._addressLocalService.fetchAddress(defaultBillingAddressId);
                if (billingAddress != null) {
                    CommerceChannelAccountEntryRel existingCommerceChannelAccountEntryRel2 = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, Address.class.getName(), billingAddress.getAddressId(), 0L, 2);
                    if (existingCommerceChannelAccountEntryRel2 != null) continue;
                    this._commerceChannelAccountEntryRelLocalService.addCommerceChannelAccountEntryRel(userId, accountEntryId, Address.class.getName(), billingAddress.getAddressId(), 0L, false, 0.0, 2);
                }
                if ((shippingAddress = this._addressLocalService.fetchAddress(defaultShippingAddressId = resultSet.getLong("defaultShippingAddressId"))) == null || (existingCommerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, Address.class.getName(), shippingAddress.getAddressId(), 0L, 3)) != null) continue;
                this._commerceChannelAccountEntryRelLocalService.addCommerceChannelAccountEntryRel(userId, accountEntryId, Address.class.getName(), shippingAddress.getAddressId(), 0L, false, 0.0, 3);
            }
        }
    }

    private void _updateDefaultCommerceTermEntries() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select accountEntryId, userId, defaultDeliveryCTermEntryId, defaultPaymentCTermEntryId from AccountEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                CommerceTermEntry paymentCommerceTermEntry;
                long userId = resultSet.getLong("userId");
                long accountEntryId = resultSet.getLong("accountEntryId");
                long defaultDeliveryCTermEntryId = resultSet.getLong("defaultDeliveryCTermEntryId");
                long defaultPaymentCTermEntryId = resultSet.getLong("defaultPaymentCTermEntryId");
                CommerceTermEntry deliveryCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(defaultDeliveryCTermEntryId);
                if (deliveryCommerceTermEntry != null) {
                    this._commerceChannelAccountEntryRelLocalService.addCommerceChannelAccountEntryRel(userId, accountEntryId, CommerceTermEntry.class.getName(), defaultDeliveryCTermEntryId, 0L, false, 0.0, 0);
                }
                if ((paymentCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(defaultPaymentCTermEntryId)) == null) continue;
                this._commerceChannelAccountEntryRelLocalService.addCommerceChannelAccountEntryRel(userId, accountEntryId, CommerceTermEntry.class.getName(), defaultPaymentCTermEntryId, 0L, false, 0.0, 1);
            }
        }
    }
}

