/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v7_0_0;

import com.liferay.account.constants.AccountListTypeConstants;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Objects;

public class CommerceAddressUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAddressUpgradeProcess.class);
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AddressLocalService _addressLocalService;
    private final ListTypeLocalService _listTypeLocalService;
    private final PhoneLocalService _phoneLocalService;
    private final UserLocalService _userLocalService;

    public CommerceAddressUpgradeProcess(AddressLocalService addressLocalService, AccountEntryLocalService accountEntryLocalService, ListTypeLocalService listTypeLocalService, PhoneLocalService phoneLocalService, UserLocalService userLocalService) {
        this._addressLocalService = addressLocalService;
        this._accountEntryLocalService = accountEntryLocalService;
        this._listTypeLocalService = listTypeLocalService;
        this._phoneLocalService = phoneLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery("select * from CommerceAddress order by commerceAddressId");
            while (resultSet.next()) {
                Address address = this._addressLocalService.createAddress(resultSet.getLong("commerceAddressId"));
                address.setExternalReferenceCode(resultSet.getString("externalReferenceCode"));
                address.setCompanyId(resultSet.getLong("companyId"));
                if (resultSet.getLong("userId") == 0L) {
                    address.setUserId(this._userLocalService.getGuestUserId(resultSet.getLong("companyId")));
                } else {
                    address.setUserId(resultSet.getLong("userId"));
                }
                address.setUserName(resultSet.getString("userName"));
                address.setCreateDate((Date)resultSet.getTimestamp("createDate"));
                address.setModifiedDate((Date)resultSet.getTimestamp("modifiedDate"));
                address.setClassNameId(resultSet.getLong("classNameId"));
                address.setClassPK(resultSet.getLong("classPK"));
                address.setCountryId(resultSet.getLong("countryId"));
                address.setListTypeId(this._getListTypeId(resultSet.getInt("type_"), resultSet.getLong("companyId")));
                address.setRegionId(resultSet.getLong("regionId"));
                address.setCity(resultSet.getString("city"));
                address.setDescription(resultSet.getString("description"));
                address.setLatitude(resultSet.getDouble("latitude"));
                address.setLongitude(resultSet.getDouble("longitude"));
                address.setName(resultSet.getString("name"));
                address.setStreet1(resultSet.getString("street1"));
                address.setStreet2(resultSet.getString("street2"));
                address.setStreet3(resultSet.getString("street3"));
                address.setZip(resultSet.getString("zip"));
                address = this._addressLocalService.addAddress(address);
                this._setPhoneNumber(address, resultSet.getString("phoneNumber"));
                this._setDefaultBilling(address, resultSet.getBoolean("defaultBilling"));
                this._setDefaultShipping(address, resultSet.getBoolean("defaultShipping"));
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"CommerceAddress"})};
    }

    private long _getListTypeId(int commerceAddressType, long companyId) {
        String name = null;
        name = 1 == commerceAddressType ? "billing" : (3 == commerceAddressType ? "shipping" : "billing-and-shipping");
        ListType listType = this._listTypeLocalService.getListType(companyId, name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        if (listType == null) {
            listType = this._listTypeLocalService.addListType(companyId, name, AccountListTypeConstants.ACCOUNT_ENTRY_ADDRESS);
        }
        return listType.getListTypeId();
    }

    private void _setDefaultBilling(Address address, boolean defaultBilling) {
        String className = address.getClassName();
        if (defaultBilling && (Objects.equals(AccountEntry.class.getName(), className) || Objects.equals(className, "com.liferay.commerce.account.model.CommerceAccount"))) {
            try {
                this._accountEntryLocalService.updateDefaultBillingAddressId(address.getClassPK(), address.getAddressId());
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    private void _setDefaultShipping(Address address, boolean defaultShipping) {
        String className = address.getClassName();
        if (defaultShipping && (Objects.equals(AccountEntry.class.getName(), className) || Objects.equals(className, "com.liferay.commerce.account.model.CommerceAccount"))) {
            try {
                this._accountEntryLocalService.updateDefaultShippingAddressId(address.getClassPK(), address.getAddressId());
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    private void _setPhoneNumber(Address address, String phoneNumber) {
        if (phoneNumber == null) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(address.getUserId());
        try {
            this._phoneLocalService.addPhone(serviceContext.getUserId(), Address.class.getName(), address.getAddressId(), phoneNumber, null, this._listTypeLocalService.getListTypeId(address.getCompanyId(), "phone-number", ListTypeConstants.ADDRESS_PHONE), false, serviceContext);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }
}

