/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v6_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class CommerceCountryUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"CommerceAddress", "CommerceAddressRestriction", "CommerceRegion", "CommerceTaxFixedRateAddressRel", "CShippingFixedOptionRel"};
    private final CountryLocalService _countryLocalService;

    public CommerceCountryUpgradeProcess(CountryLocalService countryLocalService) {
        this._countryLocalService = countryLocalService;
    }

    protected void doUpgrade() throws Exception {
        ResultSet resultSet;
        try (Statement selectStatement = this.connection.createStatement();){
            resultSet = selectStatement.executeQuery("select * from CommerceCountry where twoLettersISOCode is null or threeLettersISOCode is null or numericISOCode = 0");
            if (resultSet.next()) {
                throw new UpgradeException("Unable to migrate data in CommerceCountry to Country because it contains countries with missing ISO codes");
            }
        }
        selectStatement = this.connection.createStatement();
        var2_2 = null;
        try {
            resultSet = selectStatement.executeQuery("select * from CommerceCountry order by commerceCountryId asc");
            while (resultSet.next()) {
                String a2 = resultSet.getString("twoLettersISOCode");
                String a3 = resultSet.getString("threeLettersISOCode");
                boolean active = resultSet.getBoolean("active_");
                boolean billingAllowed = resultSet.getBoolean("billingAllowed");
                boolean channelFilterEnabled = resultSet.getBoolean("channelFilterEnabled");
                long commerceCountryId = resultSet.getLong("commerceCountryId");
                long companyId = resultSet.getLong("companyId");
                Timestamp lastPublishDate = resultSet.getTimestamp("lastPublishDate");
                String name = resultSet.getString("name");
                String numericISOCode = resultSet.getString("numericISOCode");
                Double priority = resultSet.getDouble("priority");
                boolean shippingAllowed = resultSet.getBoolean("shippingAllowed");
                boolean subjectToVAT = resultSet.getBoolean("subjectToVAT");
                Country country = this._countryLocalService.fetchCountryByA2(companyId, a2);
                country = country != null ? this._updateCountry(country, a2, a3, active, billingAllowed, channelFilterEnabled, name, numericISOCode, priority, shippingAllowed, subjectToVAT, lastPublishDate) : this._addCountry(commerceCountryId, companyId, resultSet.getLong("userId"), resultSet.getString("userName"), resultSet.getTimestamp("createDate"), resultSet.getTimestamp("modifiedDate"), a2, a3, active, billingAllowed, channelFilterEnabled, name, numericISOCode, priority, shippingAllowed, subjectToVAT, lastPublishDate);
                if (country.getCountryId() == commerceCountryId) continue;
                for (String tableName : _TABLE_NAMES) {
                    this._updateCountryId(tableName, country.getCountryId(), commerceCountryId);
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (selectStatement != null) {
                if (var2_2 != null) {
                    try {
                        selectStatement.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    selectStatement.close();
                }
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"CommerceCountry"})};
    }

    private Country _addCountry(long countryId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, String a2, String a3, boolean active, boolean billingAllowed, boolean groupFilterEnabled, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, Date lastPublishDate) throws Exception {
        if (this._countryLocalService.fetchCountry(countryId) != null) {
            countryId = this.increment();
        }
        Country country = this._countryLocalService.createCountry(countryId);
        country.setDefaultLanguageId(LocalizationUtil.getDefaultLanguageId((String)name));
        country.setCompanyId(companyId);
        country.setUserId(userId);
        country.setUserName(userName);
        country.setCreateDate(createDate);
        country.setModifiedDate(modifiedDate);
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setGroupFilterEnabled(groupFilterEnabled);
        country.setName(LocalizationUtil.getLocalization((String)name, (String)LocalizationUtil.getDefaultLanguageId((String)name)));
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        country.setLastPublishDate(lastPublishDate);
        this._countryLocalService.addCountry(country);
        for (String languageId : LocalizationUtil.getAvailableLanguageIds((String)name)) {
            this._countryLocalService.updateCountryLocalization(country, languageId, LocalizationUtil.getLocalization((String)name, (String)languageId));
        }
        return country;
    }

    private Country _updateCountry(Country country, String a2, String a3, boolean active, boolean billingAllowed, boolean groupFilterEnabled, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, Date lastPublishDate) throws Exception {
        country.setDefaultLanguageId(LocalizationUtil.getDefaultLanguageId((String)name));
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setGroupFilterEnabled(groupFilterEnabled);
        country.setName(LocalizationUtil.getLocalization((String)name, (String)LocalizationUtil.getDefaultLanguageId((String)name)));
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        country.setLastPublishDate(lastPublishDate);
        for (String languageId : LocalizationUtil.getAvailableLanguageIds((String)name)) {
            this._countryLocalService.updateCountryLocalization(country, languageId, LocalizationUtil.getLocalization((String)name, (String)languageId));
        }
        return this._countryLocalService.updateCountry(country);
    }

    private void _updateCountryId(String tableName, long newCountryId, long oldCountryId) throws Exception {
        String columnName = "countryId";
        if (tableName.equals("CommerceRegion")) {
            columnName = "commerceCountryId";
        }
        this.runSQL(StringBundler.concat((Object[])new Object[]{"update ", tableName, " set ", columnName, " = ", newCountryId, " where ", columnName, " = ", oldCountryId}));
    }
}

