/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={ModelPreFilterContributor.class})
public class CommerceOrderModelPreFilterContributor
implements ModelPreFilterContributor {
    private static final int _MAX_CLAUSES_COUNT = 1024;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByCommerceAccountIds(booleanFilter, searchContext);
        this._filterByGroupIds(booleanFilter, searchContext);
        this._filterByOrderStatuses(booleanFilter, searchContext);
    }

    private void _filterByCommerceAccountIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] commerceAccountIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountIds"), null);
        if (commerceAccountIds == null) {
            return;
        }
        BooleanFilter commerceAccountIdBooleanFilter = new BooleanFilter();
        BooleanFilter nestedBooleanFilter = new BooleanFilter();
        for (int i = 0; i < commerceAccountIds.length; ++i) {
            TermFilter termFilter = new TermFilter("commerceAccountId", String.valueOf(commerceAccountIds[i]));
            nestedBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            if ((i + 1) % 1024 != 0) continue;
            commerceAccountIdBooleanFilter.add((Filter)nestedBooleanFilter, BooleanClauseOccur.SHOULD);
            nestedBooleanFilter = new BooleanFilter();
        }
        if (nestedBooleanFilter.hasClauses()) {
            commerceAccountIdBooleanFilter.add((Filter)nestedBooleanFilter, BooleanClauseOccur.SHOULD);
        }
        commerceAccountIdBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)commerceAccountIdBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByGroupIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] groupIds = searchContext.getGroupIds();
        if (groupIds == null || groupIds.length == 0) {
            booleanFilter.addTerm("groupId", "-1", BooleanClauseOccur.MUST);
        }
    }

    private void _filterByOrderStatuses(BooleanFilter booleanFilter, SearchContext searchContext) {
        int[] orderStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("orderStatuses"), null);
        if (orderStatuses == null) {
            return;
        }
        BooleanFilter orderStatusesBooleanFilter = new BooleanFilter();
        int[] nArray = orderStatuses;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long orderStatus = nArray[i];
            TermFilter termFilter = new TermFilter("orderStatus", String.valueOf(orderStatus));
            orderStatusesBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
        }
        orderStatusesBooleanFilter.add((Filter)new MissingFilter("orderStatus"), BooleanClauseOccur.SHOULD);
        if (GetterUtil.getBoolean((Object)searchContext.getAttribute("negateOrderStatuses"))) {
            booleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
        } else {
            booleanFilter.add((Filter)orderStatusesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }
}

