/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={ModelDocumentContributor.class})
public class CommerceOrderModelDocumentContributor
implements ModelDocumentContributor<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelDocumentContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CommerceOrder commerceOrder) {
        block4: {
            try {
                CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
                document.addNumberSortable("entryClassPK", Long.valueOf(commerceOrder.getCommerceOrderId()));
                document.addKeyword("status", commerceOrder.getStatus());
                AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(commerceOrder.getCommerceAccountId());
                if (accountEntry != null) {
                    document.addKeyword("accountName", accountEntry.getName());
                }
                document.addKeyword("advanceStatus", commerceOrder.getAdvanceStatus());
                document.addKeyword("commerceAccountId", commerceOrder.getCommerceAccountId());
                document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
                CommerceOrderType commerceOrderType = this._commerceOrderTypeLocalService.fetchCommerceOrderType(commerceOrder.getCommerceOrderTypeId());
                if (commerceOrderType != null) {
                    document.addKeyword("commerceOrderTypeExternalReferenceCode", commerceOrderType.getExternalReferenceCode());
                }
                document.addKeyword("commerceOrderTypeId", commerceOrder.getCommerceOrderTypeId());
                document.addKeyword("externalReferenceCode", commerceOrder.getExternalReferenceCode());
                document.addNumber("itemsQuantity", this._getItemsQuantity(commerceOrder));
                document.addKeyword("name", this._getCommerceOrderItemNames(commerceOrder));
                User user = this._userLocalService.getUser(commerceOrder.getUserId());
                document.addKeyword("orderCreatorEmailAddress", user.getEmailAddress());
                document.addDate("orderDate", commerceOrder.getOrderDate());
                document.addDateSortable("orderDate", commerceOrder.getOrderDate());
                document.addKeyword("orderStatus", commerceOrder.getOrderStatus());
                document.addKeyword("purchaseOrderNumber", commerceOrder.getPurchaseOrderNumber());
                document.addKeyword("sku", this._getCommerceOrderItemSKUs(commerceOrder));
                document.addNumber("total", commerceOrder.getTotal());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to index commerce order " + commerceOrder.getCommerceOrderId()), (Throwable)exception);
            }
        }
    }

    private String[] _getCommerceOrderItemNames(CommerceOrder commerceOrder) {
        ArrayList<String> commerceOrderItemNamesList = new ArrayList<String>();
        for (Locale locale : this._language.getAvailableLocales(commerceOrder.getGroupId())) {
            for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
                String commerceOrderItemName = commerceOrderItem.getName(locale);
                if (Validator.isNull((String)commerceOrderItemName)) {
                    commerceOrderItemName = this._localization.getDefaultLanguageId(commerceOrderItem.getName());
                }
                commerceOrderItemNamesList.add(commerceOrderItemName);
            }
        }
        return commerceOrderItemNamesList.toArray(new String[0]);
    }

    private String[] _getCommerceOrderItemSKUs(CommerceOrder commerceOrder) {
        ArrayList<String> commerceOrderItemSKUsList = new ArrayList<String>();
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            commerceOrderItemSKUsList.add(commerceOrderItem.getSku());
        }
        return commerceOrderItemSKUsList.toArray(new String[0]);
    }

    private BigDecimal _getItemsQuantity(CommerceOrder commerceOrder) {
        BigDecimal count = BigDecimal.ZERO;
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            count = count.add(commerceOrderItem.getQuantity());
        }
        return count;
    }
}

