/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=10", "commerce.order.status.priority:Integer=50"}, service={CommerceOrderStatus.class})
public class ProcessingCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 10;
    public static final int PRIORITY = 50;
    @Reference
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(10);
        commerceOrder = secure ? this._commerceOrderService.updateCommerceOrder(commerceOrder) : this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return commerceOrder;
    }

    public int getKey() {
        return 10;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)10));
    }

    public int getPriority() {
        return 50;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return !commerceOrder.isOpen() && commerceOrder.isApproved() && commerceOrder.getOrderStatus() != 1;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        return !commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return commerceOrder.getOrderStatus() == 1 || commerceOrder.getOrderStatus() == 20;
    }
}

