/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.membershippolicy.RoleMembershipPolicyUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserGroupRoleModelListener
extends BaseModelListener<UserGroupRole> {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupRoleModelListener.class);
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Role supplierRole;
            AccountRole accountRole = this._accountRoleLocalService.fetchAccountRoleByRoleId(userGroupRole.getRoleId());
            if (accountRole != null && "Account Supplier".contentEquals(accountRole.getRoleName()) && (supplierRole = this._roleLocalService.fetchRole(userGroupRole.getCompanyId(), "Supplier")) != null) {
                this._propagateRoles(new long[]{userGroupRole.getUserId()}, new long[]{supplierRole.getRoleId()}, new long[0]);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    public void onAfterRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Role supplierRole;
            if (this._isUserSupplierInOtherAccounts(userGroupRole.getUserId())) {
                return;
            }
            AccountRole accountRole = this._accountRoleLocalService.fetchAccountRoleByRoleId(userGroupRole.getRoleId());
            if (accountRole != null && "Account Supplier".equals(accountRole.getRoleName()) && (supplierRole = this._roleLocalService.fetchRole(userGroupRole.getCompanyId(), "Supplier")) != null) {
                this._propagateRoles(new long[]{userGroupRole.getUserId()}, new long[0], new long[]{supplierRole.getRoleId()});
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private boolean _isUserSupplierInOtherAccounts(long userId) throws PortalException {
        List accountRoles = TransformUtil.transform((Collection)ListUtil.filter((List)this._userGroupRoleLocalService.getUserGroupRoles(userId), userGroupRole -> {
            try {
                Role role = userGroupRole.getRole();
                return role.getType() == 6;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        }), userGroupRole -> this._accountRoleLocalService.getAccountRoleByRoleId(userGroupRole.getRoleId()));
        for (AccountRole accountRole : accountRoles) {
            if (!"Account Supplier".equals(accountRole.getRoleName())) continue;
            return true;
        }
        return false;
    }

    private void _propagateRoles(long[] userId, long[] addRoleId, long[] removeRoleId) {
        try {
            if (addRoleId.length > 0) {
                this._userLocalService.addRoleUsers(addRoleId[0], userId);
                RoleMembershipPolicyUtil.propagateRoles((long[])userId, (long[])new long[]{addRoleId[0]}, null);
            }
            if (removeRoleId.length > 0) {
                this._userLocalService.deleteRoleUser(removeRoleId[0], userId[0]);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

