/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelListener.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterCreate((BaseModel)objectEntry);
        this._sendNotifications("create", objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterRemove((BaseModel)objectEntry);
        this._sendNotifications("delete", objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterUpdate((BaseModel)originalObjectEntry, (BaseModel)objectEntry);
        this._sendNotifications("update", objectEntry);
    }

    private void _sendNotifications(String action, ObjectEntry objectEntry) {
        block3: {
            try {
                CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(objectEntry.getGroupId());
                if (commerceChannel == null) {
                    return;
                }
                ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
                this._commerceNotificationHelper.sendNotifications(commerceChannel.getGroupId(), objectEntry.getUserId(), objectDefinition.getClassName() + "#" + action, (Object)objectEntry);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }
}

