/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrder service. Represents a row in the &quot;CommerceOrder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceOrderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderModelImpl
	extends BaseModelImpl<CommerceOrder> implements CommerceOrderModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order model instance should use the <code>CommerceOrder</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrder";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"billingAddressId", Types.BIGINT},
		{"commerceAccountId", Types.BIGINT},
		{"commerceCurrencyId", Types.BIGINT},
		{"commerceOrderTypeId", Types.BIGINT},
		{"commerceShippingMethodId", Types.BIGINT},
		{"deliveryCommerceTermEntryId", Types.BIGINT},
		{"paymentCommerceTermEntryId", Types.BIGINT},
		{"shippingAddressId", Types.BIGINT}, {"advanceStatus", Types.VARCHAR},
		{"commercePaymentMethodKey", Types.VARCHAR},
		{"couponCode", Types.VARCHAR},
		{"deliveryCTermEntryDescription", Types.CLOB},
		{"deliveryCommerceTermEntryName", Types.VARCHAR},
		{"lastPriceUpdateDate", Types.TIMESTAMP},
		{"manuallyAdjusted", Types.BOOLEAN}, {"orderDate", Types.TIMESTAMP},
		{"orderStatus", Types.INTEGER},
		{"paymentCTermEntryDescription", Types.CLOB},
		{"paymentCommerceTermEntryName", Types.VARCHAR},
		{"paymentStatus", Types.INTEGER}, {"printedNote", Types.VARCHAR},
		{"purchaseOrderNumber", Types.VARCHAR},
		{"requestedDeliveryDate", Types.TIMESTAMP},
		{"shippable", Types.BOOLEAN}, {"shippingAmount", Types.DECIMAL},
		{"shippingDiscountAmount", Types.DECIMAL},
		{"shippingDiscountPercentLevel1", Types.DECIMAL},
		{"shippingDiscountPercentLevel2", Types.DECIMAL},
		{"shippingDiscountPercentLevel3", Types.DECIMAL},
		{"shippingDiscountPercentLevel4", Types.DECIMAL},
		{"shippingDiscountPctLev1WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev2WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev3WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev4WithTax", Types.DECIMAL},
		{"shippingDiscountWithTaxAmount", Types.DECIMAL},
		{"shippingOptionName", Types.VARCHAR},
		{"shippingWithTaxAmount", Types.DECIMAL}, {"subtotal", Types.DECIMAL},
		{"subtotalDiscountAmount", Types.DECIMAL},
		{"subtotalDiscountPercentLevel1", Types.DECIMAL},
		{"subtotalDiscountPercentLevel2", Types.DECIMAL},
		{"subtotalDiscountPercentLevel3", Types.DECIMAL},
		{"subtotalDiscountPercentLevel4", Types.DECIMAL},
		{"subtotalDiscountPctLev1WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev2WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev3WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev4WithTax", Types.DECIMAL},
		{"subtotalDiscountWithTaxAmount", Types.DECIMAL},
		{"subtotalWithTaxAmount", Types.DECIMAL}, {"taxAmount", Types.DECIMAL},
		{"total", Types.DECIMAL}, {"totalDiscountAmount", Types.DECIMAL},
		{"totalDiscountPercentageLevel1", Types.DECIMAL},
		{"totalDiscountPercentageLevel2", Types.DECIMAL},
		{"totalDiscountPercentageLevel3", Types.DECIMAL},
		{"totalDiscountPercentageLevel4", Types.DECIMAL},
		{"totalDiscountPctLev1WithTax", Types.DECIMAL},
		{"totalDiscountPctLev2WithTax", Types.DECIMAL},
		{"totalDiscountPctLev3WithTax", Types.DECIMAL},
		{"totalDiscountPctLev4WithTax", Types.DECIMAL},
		{"totalDiscountWithTaxAmount", Types.DECIMAL},
		{"totalWithTaxAmount", Types.DECIMAL}, {"transactionId", Types.CLOB},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("billingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceAccountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceOrderTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliveryCommerceTermEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("paymentCommerceTermEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("advanceStatus", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commercePaymentMethodKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("couponCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliveryCTermEntryDescription", Types.CLOB);
		TABLE_COLUMNS_MAP.put("deliveryCommerceTermEntryName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPriceUpdateDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("manuallyAdjusted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("orderDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("orderStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("paymentCTermEntryDescription", Types.CLOB);
		TABLE_COLUMNS_MAP.put("paymentCommerceTermEntryName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("paymentStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("purchaseOrderNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("shippable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("shippingAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingOptionName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("shippingWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotal", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("taxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("total", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("transactionId", Types.CLOB);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrder (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceOrderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,billingAddressId LONG,commerceAccountId LONG,commerceCurrencyId LONG,commerceOrderTypeId LONG,commerceShippingMethodId LONG,deliveryCommerceTermEntryId LONG,paymentCommerceTermEntryId LONG,shippingAddressId LONG,advanceStatus VARCHAR(75) null,commercePaymentMethodKey VARCHAR(75) null,couponCode VARCHAR(75) null,deliveryCTermEntryDescription TEXT null,deliveryCommerceTermEntryName VARCHAR(75) null,lastPriceUpdateDate DATE null,manuallyAdjusted BOOLEAN,orderDate DATE null,orderStatus INTEGER,paymentCTermEntryDescription TEXT null,paymentCommerceTermEntryName VARCHAR(75) null,paymentStatus INTEGER,printedNote STRING null,purchaseOrderNumber VARCHAR(75) null,requestedDeliveryDate DATE null,shippable BOOLEAN,shippingAmount BIGDECIMAL null,shippingDiscountAmount BIGDECIMAL null,shippingDiscountPercentLevel1 BIGDECIMAL null,shippingDiscountPercentLevel2 BIGDECIMAL null,shippingDiscountPercentLevel3 BIGDECIMAL null,shippingDiscountPercentLevel4 BIGDECIMAL null,shippingDiscountPctLev1WithTax BIGDECIMAL null,shippingDiscountPctLev2WithTax BIGDECIMAL null,shippingDiscountPctLev3WithTax BIGDECIMAL null,shippingDiscountPctLev4WithTax BIGDECIMAL null,shippingDiscountWithTaxAmount BIGDECIMAL null,shippingOptionName VARCHAR(255) null,shippingWithTaxAmount BIGDECIMAL null,subtotal BIGDECIMAL null,subtotalDiscountAmount BIGDECIMAL null,subtotalDiscountPercentLevel1 BIGDECIMAL null,subtotalDiscountPercentLevel2 BIGDECIMAL null,subtotalDiscountPercentLevel3 BIGDECIMAL null,subtotalDiscountPercentLevel4 BIGDECIMAL null,subtotalDiscountPctLev1WithTax BIGDECIMAL null,subtotalDiscountPctLev2WithTax BIGDECIMAL null,subtotalDiscountPctLev3WithTax BIGDECIMAL null,subtotalDiscountPctLev4WithTax BIGDECIMAL null,subtotalDiscountWithTaxAmount BIGDECIMAL null,subtotalWithTaxAmount BIGDECIMAL null,taxAmount BIGDECIMAL null,total BIGDECIMAL null,totalDiscountAmount BIGDECIMAL null,totalDiscountPercentageLevel1 BIGDECIMAL null,totalDiscountPercentageLevel2 BIGDECIMAL null,totalDiscountPercentageLevel3 BIGDECIMAL null,totalDiscountPercentageLevel4 BIGDECIMAL null,totalDiscountPctLev1WithTax BIGDECIMAL null,totalDiscountPctLev2WithTax BIGDECIMAL null,totalDiscountPctLev3WithTax BIGDECIMAL null,totalDiscountPctLev4WithTax BIGDECIMAL null,totalDiscountWithTaxAmount BIGDECIMAL null,totalWithTaxAmount BIGDECIMAL null,transactionId TEXT null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrder.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrder.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceOrderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrder.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrder)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrder, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrder, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrder, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CommerceOrder, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CommerceOrder, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<CommerceOrder, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CommerceOrder::getMvccVersion);
			attributeGetterFunctions.put("uuid", CommerceOrder::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				CommerceOrder::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"commerceOrderId", CommerceOrder::getCommerceOrderId);
			attributeGetterFunctions.put("groupId", CommerceOrder::getGroupId);
			attributeGetterFunctions.put(
				"companyId", CommerceOrder::getCompanyId);
			attributeGetterFunctions.put("userId", CommerceOrder::getUserId);
			attributeGetterFunctions.put(
				"userName", CommerceOrder::getUserName);
			attributeGetterFunctions.put(
				"createDate", CommerceOrder::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CommerceOrder::getModifiedDate);
			attributeGetterFunctions.put(
				"billingAddressId", CommerceOrder::getBillingAddressId);
			attributeGetterFunctions.put(
				"commerceAccountId", CommerceOrder::getCommerceAccountId);
			attributeGetterFunctions.put(
				"commerceCurrencyId", CommerceOrder::getCommerceCurrencyId);
			attributeGetterFunctions.put(
				"commerceOrderTypeId", CommerceOrder::getCommerceOrderTypeId);
			attributeGetterFunctions.put(
				"commerceShippingMethodId",
				CommerceOrder::getCommerceShippingMethodId);
			attributeGetterFunctions.put(
				"deliveryCommerceTermEntryId",
				CommerceOrder::getDeliveryCommerceTermEntryId);
			attributeGetterFunctions.put(
				"paymentCommerceTermEntryId",
				CommerceOrder::getPaymentCommerceTermEntryId);
			attributeGetterFunctions.put(
				"shippingAddressId", CommerceOrder::getShippingAddressId);
			attributeGetterFunctions.put(
				"advanceStatus", CommerceOrder::getAdvanceStatus);
			attributeGetterFunctions.put(
				"commercePaymentMethodKey",
				CommerceOrder::getCommercePaymentMethodKey);
			attributeGetterFunctions.put(
				"couponCode", CommerceOrder::getCouponCode);
			attributeGetterFunctions.put(
				"deliveryCommerceTermEntryDescription",
				CommerceOrder::getDeliveryCommerceTermEntryDescription);
			attributeGetterFunctions.put(
				"deliveryCommerceTermEntryName",
				CommerceOrder::getDeliveryCommerceTermEntryName);
			attributeGetterFunctions.put(
				"lastPriceUpdateDate", CommerceOrder::getLastPriceUpdateDate);
			attributeGetterFunctions.put(
				"manuallyAdjusted", CommerceOrder::getManuallyAdjusted);
			attributeGetterFunctions.put(
				"orderDate", CommerceOrder::getOrderDate);
			attributeGetterFunctions.put(
				"orderStatus", CommerceOrder::getOrderStatus);
			attributeGetterFunctions.put(
				"paymentCommerceTermEntryDescription",
				CommerceOrder::getPaymentCommerceTermEntryDescription);
			attributeGetterFunctions.put(
				"paymentCommerceTermEntryName",
				CommerceOrder::getPaymentCommerceTermEntryName);
			attributeGetterFunctions.put(
				"paymentStatus", CommerceOrder::getPaymentStatus);
			attributeGetterFunctions.put(
				"printedNote", CommerceOrder::getPrintedNote);
			attributeGetterFunctions.put(
				"purchaseOrderNumber", CommerceOrder::getPurchaseOrderNumber);
			attributeGetterFunctions.put(
				"requestedDeliveryDate",
				CommerceOrder::getRequestedDeliveryDate);
			attributeGetterFunctions.put(
				"shippable", CommerceOrder::getShippable);
			attributeGetterFunctions.put(
				"shippingAmount", CommerceOrder::getShippingAmount);
			attributeGetterFunctions.put(
				"shippingDiscountAmount",
				CommerceOrder::getShippingDiscountAmount);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel1",
				CommerceOrder::getShippingDiscountPercentageLevel1);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel2",
				CommerceOrder::getShippingDiscountPercentageLevel2);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel3",
				CommerceOrder::getShippingDiscountPercentageLevel3);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel4",
				CommerceOrder::getShippingDiscountPercentageLevel4);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel1WithTaxAmount",
				CommerceOrder::
					getShippingDiscountPercentageLevel1WithTaxAmount);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel2WithTaxAmount",
				CommerceOrder::
					getShippingDiscountPercentageLevel2WithTaxAmount);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel3WithTaxAmount",
				CommerceOrder::
					getShippingDiscountPercentageLevel3WithTaxAmount);
			attributeGetterFunctions.put(
				"shippingDiscountPercentageLevel4WithTaxAmount",
				CommerceOrder::
					getShippingDiscountPercentageLevel4WithTaxAmount);
			attributeGetterFunctions.put(
				"shippingDiscountWithTaxAmount",
				CommerceOrder::getShippingDiscountWithTaxAmount);
			attributeGetterFunctions.put(
				"shippingOptionName", CommerceOrder::getShippingOptionName);
			attributeGetterFunctions.put(
				"shippingWithTaxAmount",
				CommerceOrder::getShippingWithTaxAmount);
			attributeGetterFunctions.put(
				"subtotal", CommerceOrder::getSubtotal);
			attributeGetterFunctions.put(
				"subtotalDiscountAmount",
				CommerceOrder::getSubtotalDiscountAmount);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel1",
				CommerceOrder::getSubtotalDiscountPercentageLevel1);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel2",
				CommerceOrder::getSubtotalDiscountPercentageLevel2);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel3",
				CommerceOrder::getSubtotalDiscountPercentageLevel3);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel4",
				CommerceOrder::getSubtotalDiscountPercentageLevel4);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel1WithTaxAmount",
				CommerceOrder::
					getSubtotalDiscountPercentageLevel1WithTaxAmount);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel2WithTaxAmount",
				CommerceOrder::
					getSubtotalDiscountPercentageLevel2WithTaxAmount);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel3WithTaxAmount",
				CommerceOrder::
					getSubtotalDiscountPercentageLevel3WithTaxAmount);
			attributeGetterFunctions.put(
				"subtotalDiscountPercentageLevel4WithTaxAmount",
				CommerceOrder::
					getSubtotalDiscountPercentageLevel4WithTaxAmount);
			attributeGetterFunctions.put(
				"subtotalDiscountWithTaxAmount",
				CommerceOrder::getSubtotalDiscountWithTaxAmount);
			attributeGetterFunctions.put(
				"subtotalWithTaxAmount",
				CommerceOrder::getSubtotalWithTaxAmount);
			attributeGetterFunctions.put(
				"taxAmount", CommerceOrder::getTaxAmount);
			attributeGetterFunctions.put("total", CommerceOrder::getTotal);
			attributeGetterFunctions.put(
				"totalDiscountAmount", CommerceOrder::getTotalDiscountAmount);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel1",
				CommerceOrder::getTotalDiscountPercentageLevel1);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel2",
				CommerceOrder::getTotalDiscountPercentageLevel2);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel3",
				CommerceOrder::getTotalDiscountPercentageLevel3);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel4",
				CommerceOrder::getTotalDiscountPercentageLevel4);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel1WithTaxAmount",
				CommerceOrder::getTotalDiscountPercentageLevel1WithTaxAmount);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel2WithTaxAmount",
				CommerceOrder::getTotalDiscountPercentageLevel2WithTaxAmount);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel3WithTaxAmount",
				CommerceOrder::getTotalDiscountPercentageLevel3WithTaxAmount);
			attributeGetterFunctions.put(
				"totalDiscountPercentageLevel4WithTaxAmount",
				CommerceOrder::getTotalDiscountPercentageLevel4WithTaxAmount);
			attributeGetterFunctions.put(
				"totalDiscountWithTaxAmount",
				CommerceOrder::getTotalDiscountWithTaxAmount);
			attributeGetterFunctions.put(
				"totalWithTaxAmount", CommerceOrder::getTotalWithTaxAmount);
			attributeGetterFunctions.put(
				"transactionId", CommerceOrder::getTransactionId);
			attributeGetterFunctions.put("status", CommerceOrder::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", CommerceOrder::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", CommerceOrder::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", CommerceOrder::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CommerceOrder, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CommerceOrder, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<CommerceOrder, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CommerceOrder, Long>)CommerceOrder::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<CommerceOrder, String>)CommerceOrder::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"commerceOrderId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setCommerceOrderId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<CommerceOrder, Long>)CommerceOrder::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CommerceOrder, Long>)CommerceOrder::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CommerceOrder, Long>)CommerceOrder::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CommerceOrder, String>)CommerceOrder::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CommerceOrder, Date>)CommerceOrder::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CommerceOrder, Date>)
					CommerceOrder::setModifiedDate);
			attributeSetterBiConsumers.put(
				"billingAddressId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setBillingAddressId);
			attributeSetterBiConsumers.put(
				"commerceAccountId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setCommerceAccountId);
			attributeSetterBiConsumers.put(
				"commerceCurrencyId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setCommerceCurrencyId);
			attributeSetterBiConsumers.put(
				"commerceOrderTypeId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setCommerceOrderTypeId);
			attributeSetterBiConsumers.put(
				"commerceShippingMethodId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setCommerceShippingMethodId);
			attributeSetterBiConsumers.put(
				"deliveryCommerceTermEntryId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setDeliveryCommerceTermEntryId);
			attributeSetterBiConsumers.put(
				"paymentCommerceTermEntryId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setPaymentCommerceTermEntryId);
			attributeSetterBiConsumers.put(
				"shippingAddressId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setShippingAddressId);
			attributeSetterBiConsumers.put(
				"advanceStatus",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setAdvanceStatus);
			attributeSetterBiConsumers.put(
				"commercePaymentMethodKey",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setCommercePaymentMethodKey);
			attributeSetterBiConsumers.put(
				"couponCode",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setCouponCode);
			attributeSetterBiConsumers.put(
				"deliveryCommerceTermEntryDescription",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setDeliveryCommerceTermEntryDescription);
			attributeSetterBiConsumers.put(
				"deliveryCommerceTermEntryName",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setDeliveryCommerceTermEntryName);
			attributeSetterBiConsumers.put(
				"lastPriceUpdateDate",
				(BiConsumer<CommerceOrder, Date>)
					CommerceOrder::setLastPriceUpdateDate);
			attributeSetterBiConsumers.put(
				"manuallyAdjusted",
				(BiConsumer<CommerceOrder, Boolean>)
					CommerceOrder::setManuallyAdjusted);
			attributeSetterBiConsumers.put(
				"orderDate",
				(BiConsumer<CommerceOrder, Date>)CommerceOrder::setOrderDate);
			attributeSetterBiConsumers.put(
				"orderStatus",
				(BiConsumer<CommerceOrder, Integer>)
					CommerceOrder::setOrderStatus);
			attributeSetterBiConsumers.put(
				"paymentCommerceTermEntryDescription",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setPaymentCommerceTermEntryDescription);
			attributeSetterBiConsumers.put(
				"paymentCommerceTermEntryName",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setPaymentCommerceTermEntryName);
			attributeSetterBiConsumers.put(
				"paymentStatus",
				(BiConsumer<CommerceOrder, Integer>)
					CommerceOrder::setPaymentStatus);
			attributeSetterBiConsumers.put(
				"printedNote",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setPrintedNote);
			attributeSetterBiConsumers.put(
				"purchaseOrderNumber",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setPurchaseOrderNumber);
			attributeSetterBiConsumers.put(
				"requestedDeliveryDate",
				(BiConsumer<CommerceOrder, Date>)
					CommerceOrder::setRequestedDeliveryDate);
			attributeSetterBiConsumers.put(
				"shippable",
				(BiConsumer<CommerceOrder, Boolean>)
					CommerceOrder::setShippable);
			attributeSetterBiConsumers.put(
				"shippingAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel1",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountPercentageLevel1);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel2",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountPercentageLevel2);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel3",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountPercentageLevel3);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel4",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountPercentageLevel4);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel1WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setShippingDiscountPercentageLevel1WithTaxAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel2WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setShippingDiscountPercentageLevel2WithTaxAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel3WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setShippingDiscountPercentageLevel3WithTaxAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountPercentageLevel4WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setShippingDiscountPercentageLevel4WithTaxAmount);
			attributeSetterBiConsumers.put(
				"shippingDiscountWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingDiscountWithTaxAmount);
			attributeSetterBiConsumers.put(
				"shippingOptionName",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setShippingOptionName);
			attributeSetterBiConsumers.put(
				"shippingWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setShippingWithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotal",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotal);
			attributeSetterBiConsumers.put(
				"subtotalDiscountAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountAmount);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel1",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountPercentageLevel1);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel2",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountPercentageLevel2);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel3",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountPercentageLevel3);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel4",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountPercentageLevel4);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel1WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setSubtotalDiscountPercentageLevel1WithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel2WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setSubtotalDiscountPercentageLevel2WithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel3WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setSubtotalDiscountPercentageLevel3WithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotalDiscountPercentageLevel4WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::
					setSubtotalDiscountPercentageLevel4WithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotalDiscountWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalDiscountWithTaxAmount);
			attributeSetterBiConsumers.put(
				"subtotalWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setSubtotalWithTaxAmount);
			attributeSetterBiConsumers.put(
				"taxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTaxAmount);
			attributeSetterBiConsumers.put(
				"total",
				(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::setTotal);
			attributeSetterBiConsumers.put(
				"totalDiscountAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountAmount);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel1",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountPercentageLevel1);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel2",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountPercentageLevel2);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel3",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountPercentageLevel3);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel4",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountPercentageLevel4);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel1WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::
						setTotalDiscountPercentageLevel1WithTaxAmount);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel2WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::
						setTotalDiscountPercentageLevel2WithTaxAmount);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel3WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::
						setTotalDiscountPercentageLevel3WithTaxAmount);
			attributeSetterBiConsumers.put(
				"totalDiscountPercentageLevel4WithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::
						setTotalDiscountPercentageLevel4WithTaxAmount);
			attributeSetterBiConsumers.put(
				"totalDiscountWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalDiscountWithTaxAmount);
			attributeSetterBiConsumers.put(
				"totalWithTaxAmount",
				(BiConsumer<CommerceOrder, BigDecimal>)
					CommerceOrder::setTotalWithTaxAmount);
			attributeSetterBiConsumers.put(
				"transactionId",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setTransactionId);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<CommerceOrder, Integer>)CommerceOrder::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<CommerceOrder, Long>)
					CommerceOrder::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<CommerceOrder, String>)
					CommerceOrder::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<CommerceOrder, Date>)CommerceOrder::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderId = commerceOrderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalCreateDate() {
		return getColumnOriginalValue("createDate");
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getBillingAddressId() {
		return _billingAddressId;
	}

	@Override
	public void setBillingAddressId(long billingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_billingAddressId = billingAddressId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBillingAddressId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("billingAddressId"));
	}

	@JSON
	@Override
	public long getCommerceAccountId() {
		return _commerceAccountId;
	}

	@Override
	public void setCommerceAccountId(long commerceAccountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceAccountId = commerceAccountId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceAccountId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceAccountId"));
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceCurrencyId = commerceCurrencyId;
	}

	@JSON
	@Override
	public long getCommerceOrderTypeId() {
		return _commerceOrderTypeId;
	}

	@Override
	public void setCommerceOrderTypeId(long commerceOrderTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderTypeId = commerceOrderTypeId;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingMethodId = commerceShippingMethodId;
	}

	@JSON
	@Override
	public long getDeliveryCommerceTermEntryId() {
		return _deliveryCommerceTermEntryId;
	}

	@Override
	public void setDeliveryCommerceTermEntryId(
		long deliveryCommerceTermEntryId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryCommerceTermEntryId = deliveryCommerceTermEntryId;
	}

	@JSON
	@Override
	public long getPaymentCommerceTermEntryId() {
		return _paymentCommerceTermEntryId;
	}

	@Override
	public void setPaymentCommerceTermEntryId(long paymentCommerceTermEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_paymentCommerceTermEntryId = paymentCommerceTermEntryId;
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAddressId = shippingAddressId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalShippingAddressId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("shippingAddressId"));
	}

	@JSON
	@Override
	public String getAdvanceStatus() {
		if (_advanceStatus == null) {
			return "";
		}
		else {
			return _advanceStatus;
		}
	}

	@Override
	public void setAdvanceStatus(String advanceStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_advanceStatus = advanceStatus;
	}

	@JSON
	@Override
	public String getCommercePaymentMethodKey() {
		if (_commercePaymentMethodKey == null) {
			return "";
		}
		else {
			return _commercePaymentMethodKey;
		}
	}

	@Override
	public void setCommercePaymentMethodKey(String commercePaymentMethodKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePaymentMethodKey = commercePaymentMethodKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCommercePaymentMethodKey() {
		return getColumnOriginalValue("commercePaymentMethodKey");
	}

	@JSON
	@Override
	public String getCouponCode() {
		if (_couponCode == null) {
			return "";
		}
		else {
			return _couponCode;
		}
	}

	@Override
	public void setCouponCode(String couponCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_couponCode = couponCode;
	}

	@JSON
	@Override
	public String getDeliveryCommerceTermEntryDescription() {
		if (_deliveryCommerceTermEntryDescription == null) {
			return "";
		}
		else {
			return _deliveryCommerceTermEntryDescription;
		}
	}

	@Override
	public void setDeliveryCommerceTermEntryDescription(
		String deliveryCommerceTermEntryDescription) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryCommerceTermEntryDescription =
			deliveryCommerceTermEntryDescription;
	}

	@JSON
	@Override
	public String getDeliveryCommerceTermEntryName() {
		if (_deliveryCommerceTermEntryName == null) {
			return "";
		}
		else {
			return _deliveryCommerceTermEntryName;
		}
	}

	@Override
	public void setDeliveryCommerceTermEntryName(
		String deliveryCommerceTermEntryName) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryCommerceTermEntryName = deliveryCommerceTermEntryName;
	}

	@JSON
	@Override
	public Date getLastPriceUpdateDate() {
		return _lastPriceUpdateDate;
	}

	@Override
	public void setLastPriceUpdateDate(Date lastPriceUpdateDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPriceUpdateDate = lastPriceUpdateDate;
	}

	@JSON
	@Override
	public boolean getManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@Override
	public void setManuallyAdjusted(boolean manuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manuallyAdjusted = manuallyAdjusted;
	}

	@JSON
	@Override
	public Date getOrderDate() {
		return _orderDate;
	}

	@Override
	public void setOrderDate(Date orderDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderDate = orderDate;
	}

	@JSON
	@Override
	public int getOrderStatus() {
		return _orderStatus;
	}

	@Override
	public void setOrderStatus(int orderStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderStatus = orderStatus;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalOrderStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("orderStatus"));
	}

	@JSON
	@Override
	public String getPaymentCommerceTermEntryDescription() {
		if (_paymentCommerceTermEntryDescription == null) {
			return "";
		}
		else {
			return _paymentCommerceTermEntryDescription;
		}
	}

	@Override
	public void setPaymentCommerceTermEntryDescription(
		String paymentCommerceTermEntryDescription) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_paymentCommerceTermEntryDescription =
			paymentCommerceTermEntryDescription;
	}

	@JSON
	@Override
	public String getPaymentCommerceTermEntryName() {
		if (_paymentCommerceTermEntryName == null) {
			return "";
		}
		else {
			return _paymentCommerceTermEntryName;
		}
	}

	@Override
	public void setPaymentCommerceTermEntryName(
		String paymentCommerceTermEntryName) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_paymentCommerceTermEntryName = paymentCommerceTermEntryName;
	}

	@JSON
	@Override
	public int getPaymentStatus() {
		return _paymentStatus;
	}

	@Override
	public void setPaymentStatus(int paymentStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_paymentStatus = paymentStatus;
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_printedNote = printedNote;
	}

	@JSON
	@Override
	public String getPurchaseOrderNumber() {
		if (_purchaseOrderNumber == null) {
			return "";
		}
		else {
			return _purchaseOrderNumber;
		}
	}

	@Override
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_purchaseOrderNumber = purchaseOrderNumber;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public boolean getShippable() {
		return _shippable;
	}

	@JSON
	@Override
	public boolean isShippable() {
		return _shippable;
	}

	@Override
	public void setShippable(boolean shippable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippable = shippable;
	}

	@JSON
	@Override
	public BigDecimal getShippingAmount() {
		return _shippingAmount;
	}

	@Override
	public void setShippingAmount(BigDecimal shippingAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAmount = shippingAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountAmount() {
		return _shippingDiscountAmount;
	}

	@Override
	public void setShippingDiscountAmount(BigDecimal shippingDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountAmount = shippingDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1() {
		return _shippingDiscountPercentageLevel1;
	}

	@Override
	public void setShippingDiscountPercentageLevel1(
		BigDecimal shippingDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel1 = shippingDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2() {
		return _shippingDiscountPercentageLevel2;
	}

	@Override
	public void setShippingDiscountPercentageLevel2(
		BigDecimal shippingDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel2 = shippingDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3() {
		return _shippingDiscountPercentageLevel3;
	}

	@Override
	public void setShippingDiscountPercentageLevel3(
		BigDecimal shippingDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel3 = shippingDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4() {
		return _shippingDiscountPercentageLevel4;
	}

	@Override
	public void setShippingDiscountPercentageLevel4(
		BigDecimal shippingDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel4 = shippingDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1WithTaxAmount() {
		return _shippingDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel1WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel1WithTaxAmount =
			shippingDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2WithTaxAmount() {
		return _shippingDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel2WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel2WithTaxAmount =
			shippingDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3WithTaxAmount() {
		return _shippingDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel3WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel3WithTaxAmount =
			shippingDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4WithTaxAmount() {
		return _shippingDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel4WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel4WithTaxAmount =
			shippingDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountWithTaxAmount() {
		return _shippingDiscountWithTaxAmount;
	}

	@Override
	public void setShippingDiscountWithTaxAmount(
		BigDecimal shippingDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountWithTaxAmount = shippingDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public String getShippingOptionName() {
		if (_shippingOptionName == null) {
			return "";
		}
		else {
			return _shippingOptionName;
		}
	}

	@Override
	public void setShippingOptionName(String shippingOptionName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingOptionName = shippingOptionName;
	}

	@JSON
	@Override
	public BigDecimal getShippingWithTaxAmount() {
		return _shippingWithTaxAmount;
	}

	@Override
	public void setShippingWithTaxAmount(BigDecimal shippingWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingWithTaxAmount = shippingWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotal() {
		return _subtotal;
	}

	@Override
	public void setSubtotal(BigDecimal subtotal) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotal = subtotal;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountAmount() {
		return _subtotalDiscountAmount;
	}

	@Override
	public void setSubtotalDiscountAmount(BigDecimal subtotalDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountAmount = subtotalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1() {
		return _subtotalDiscountPercentageLevel1;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1(
		BigDecimal subtotalDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel1 = subtotalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2() {
		return _subtotalDiscountPercentageLevel2;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2(
		BigDecimal subtotalDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel2 = subtotalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3() {
		return _subtotalDiscountPercentageLevel3;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3(
		BigDecimal subtotalDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel3 = subtotalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4() {
		return _subtotalDiscountPercentageLevel4;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4(
		BigDecimal subtotalDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel4 = subtotalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1WithTaxAmount() {
		return _subtotalDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel1WithTaxAmount =
			subtotalDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2WithTaxAmount() {
		return _subtotalDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel2WithTaxAmount =
			subtotalDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3WithTaxAmount() {
		return _subtotalDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel3WithTaxAmount =
			subtotalDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4WithTaxAmount() {
		return _subtotalDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel4WithTaxAmount =
			subtotalDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountWithTaxAmount() {
		return _subtotalDiscountWithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountWithTaxAmount(
		BigDecimal subtotalDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountWithTaxAmount = subtotalDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalWithTaxAmount() {
		return _subtotalWithTaxAmount;
	}

	@Override
	public void setSubtotalWithTaxAmount(BigDecimal subtotalWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalWithTaxAmount = subtotalWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTaxAmount() {
		return _taxAmount;
	}

	@Override
	public void setTaxAmount(BigDecimal taxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_taxAmount = taxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotal() {
		return _total;
	}

	@Override
	public void setTotal(BigDecimal total) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_total = total;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountAmount() {
		return _totalDiscountAmount;
	}

	@Override
	public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountAmount = totalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1() {
		return _totalDiscountPercentageLevel1;
	}

	@Override
	public void setTotalDiscountPercentageLevel1(
		BigDecimal totalDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel1 = totalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2() {
		return _totalDiscountPercentageLevel2;
	}

	@Override
	public void setTotalDiscountPercentageLevel2(
		BigDecimal totalDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel2 = totalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3() {
		return _totalDiscountPercentageLevel3;
	}

	@Override
	public void setTotalDiscountPercentageLevel3(
		BigDecimal totalDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel3 = totalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4() {
		return _totalDiscountPercentageLevel4;
	}

	@Override
	public void setTotalDiscountPercentageLevel4(
		BigDecimal totalDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel4 = totalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1WithTaxAmount() {
		return _totalDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel1WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel1WithTaxAmount =
			totalDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2WithTaxAmount() {
		return _totalDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel2WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel2WithTaxAmount =
			totalDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3WithTaxAmount() {
		return _totalDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel3WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel3WithTaxAmount =
			totalDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4WithTaxAmount() {
		return _totalDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel4WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel4WithTaxAmount =
			totalDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountWithTaxAmount() {
		return _totalDiscountWithTaxAmount;
	}

	@Override
	public void setTotalDiscountWithTaxAmount(
		BigDecimal totalDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountWithTaxAmount = totalDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalWithTaxAmount() {
		return _totalWithTaxAmount;
	}

	@Override
	public void setTotalWithTaxAmount(BigDecimal totalWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalWithTaxAmount = totalWithTaxAmount;
	}

	@JSON
	@Override
	public String getTransactionId() {
		if (_transactionId == null) {
			return "";
		}
		else {
			return _transactionId;
		}
	}

	@Override
	public void setTransactionId(String transactionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_transactionId = transactionId;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceOrder.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceOrder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderImpl commerceOrderImpl = new CommerceOrderImpl();

		commerceOrderImpl.setMvccVersion(getMvccVersion());
		commerceOrderImpl.setUuid(getUuid());
		commerceOrderImpl.setExternalReferenceCode(getExternalReferenceCode());
		commerceOrderImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderImpl.setGroupId(getGroupId());
		commerceOrderImpl.setCompanyId(getCompanyId());
		commerceOrderImpl.setUserId(getUserId());
		commerceOrderImpl.setUserName(getUserName());
		commerceOrderImpl.setCreateDate(getCreateDate());
		commerceOrderImpl.setModifiedDate(getModifiedDate());
		commerceOrderImpl.setBillingAddressId(getBillingAddressId());
		commerceOrderImpl.setCommerceAccountId(getCommerceAccountId());
		commerceOrderImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commerceOrderImpl.setCommerceOrderTypeId(getCommerceOrderTypeId());
		commerceOrderImpl.setCommerceShippingMethodId(
			getCommerceShippingMethodId());
		commerceOrderImpl.setDeliveryCommerceTermEntryId(
			getDeliveryCommerceTermEntryId());
		commerceOrderImpl.setPaymentCommerceTermEntryId(
			getPaymentCommerceTermEntryId());
		commerceOrderImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderImpl.setAdvanceStatus(getAdvanceStatus());
		commerceOrderImpl.setCommercePaymentMethodKey(
			getCommercePaymentMethodKey());
		commerceOrderImpl.setCouponCode(getCouponCode());
		commerceOrderImpl.setDeliveryCommerceTermEntryDescription(
			getDeliveryCommerceTermEntryDescription());
		commerceOrderImpl.setDeliveryCommerceTermEntryName(
			getDeliveryCommerceTermEntryName());
		commerceOrderImpl.setLastPriceUpdateDate(getLastPriceUpdateDate());
		commerceOrderImpl.setManuallyAdjusted(isManuallyAdjusted());
		commerceOrderImpl.setOrderDate(getOrderDate());
		commerceOrderImpl.setOrderStatus(getOrderStatus());
		commerceOrderImpl.setPaymentCommerceTermEntryDescription(
			getPaymentCommerceTermEntryDescription());
		commerceOrderImpl.setPaymentCommerceTermEntryName(
			getPaymentCommerceTermEntryName());
		commerceOrderImpl.setPaymentStatus(getPaymentStatus());
		commerceOrderImpl.setPrintedNote(getPrintedNote());
		commerceOrderImpl.setPurchaseOrderNumber(getPurchaseOrderNumber());
		commerceOrderImpl.setRequestedDeliveryDate(getRequestedDeliveryDate());
		commerceOrderImpl.setShippable(isShippable());
		commerceOrderImpl.setShippingAmount(getShippingAmount());
		commerceOrderImpl.setShippingDiscountAmount(
			getShippingDiscountAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel1(
			getShippingDiscountPercentageLevel1());
		commerceOrderImpl.setShippingDiscountPercentageLevel2(
			getShippingDiscountPercentageLevel2());
		commerceOrderImpl.setShippingDiscountPercentageLevel3(
			getShippingDiscountPercentageLevel3());
		commerceOrderImpl.setShippingDiscountPercentageLevel4(
			getShippingDiscountPercentageLevel4());
		commerceOrderImpl.setShippingDiscountPercentageLevel1WithTaxAmount(
			getShippingDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel2WithTaxAmount(
			getShippingDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel3WithTaxAmount(
			getShippingDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel4WithTaxAmount(
			getShippingDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setShippingDiscountWithTaxAmount(
			getShippingDiscountWithTaxAmount());
		commerceOrderImpl.setShippingOptionName(getShippingOptionName());
		commerceOrderImpl.setShippingWithTaxAmount(getShippingWithTaxAmount());
		commerceOrderImpl.setSubtotal(getSubtotal());
		commerceOrderImpl.setSubtotalDiscountAmount(
			getSubtotalDiscountAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1(
			getSubtotalDiscountPercentageLevel1());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2(
			getSubtotalDiscountPercentageLevel2());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3(
			getSubtotalDiscountPercentageLevel3());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4(
			getSubtotalDiscountPercentageLevel4());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1WithTaxAmount(
			getSubtotalDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2WithTaxAmount(
			getSubtotalDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3WithTaxAmount(
			getSubtotalDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4WithTaxAmount(
			getSubtotalDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountWithTaxAmount(
			getSubtotalDiscountWithTaxAmount());
		commerceOrderImpl.setSubtotalWithTaxAmount(getSubtotalWithTaxAmount());
		commerceOrderImpl.setTaxAmount(getTaxAmount());
		commerceOrderImpl.setTotal(getTotal());
		commerceOrderImpl.setTotalDiscountAmount(getTotalDiscountAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel1(
			getTotalDiscountPercentageLevel1());
		commerceOrderImpl.setTotalDiscountPercentageLevel2(
			getTotalDiscountPercentageLevel2());
		commerceOrderImpl.setTotalDiscountPercentageLevel3(
			getTotalDiscountPercentageLevel3());
		commerceOrderImpl.setTotalDiscountPercentageLevel4(
			getTotalDiscountPercentageLevel4());
		commerceOrderImpl.setTotalDiscountPercentageLevel1WithTaxAmount(
			getTotalDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel2WithTaxAmount(
			getTotalDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel3WithTaxAmount(
			getTotalDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel4WithTaxAmount(
			getTotalDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setTotalDiscountWithTaxAmount(
			getTotalDiscountWithTaxAmount());
		commerceOrderImpl.setTotalWithTaxAmount(getTotalWithTaxAmount());
		commerceOrderImpl.setTransactionId(getTransactionId());
		commerceOrderImpl.setStatus(getStatus());
		commerceOrderImpl.setStatusByUserId(getStatusByUserId());
		commerceOrderImpl.setStatusByUserName(getStatusByUserName());
		commerceOrderImpl.setStatusDate(getStatusDate());

		commerceOrderImpl.resetOriginalValues();

		return commerceOrderImpl;
	}

	@Override
	public CommerceOrder cloneWithOriginalValues() {
		CommerceOrderImpl commerceOrderImpl = new CommerceOrderImpl();

		commerceOrderImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceOrderImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		commerceOrderImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceOrderImpl.setCommerceOrderId(
			this.<Long>getColumnOriginalValue("commerceOrderId"));
		commerceOrderImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		commerceOrderImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceOrderImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceOrderImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceOrderImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceOrderImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceOrderImpl.setBillingAddressId(
			this.<Long>getColumnOriginalValue("billingAddressId"));
		commerceOrderImpl.setCommerceAccountId(
			this.<Long>getColumnOriginalValue("commerceAccountId"));
		commerceOrderImpl.setCommerceCurrencyId(
			this.<Long>getColumnOriginalValue("commerceCurrencyId"));
		commerceOrderImpl.setCommerceOrderTypeId(
			this.<Long>getColumnOriginalValue("commerceOrderTypeId"));
		commerceOrderImpl.setCommerceShippingMethodId(
			this.<Long>getColumnOriginalValue("commerceShippingMethodId"));
		commerceOrderImpl.setDeliveryCommerceTermEntryId(
			this.<Long>getColumnOriginalValue("deliveryCommerceTermEntryId"));
		commerceOrderImpl.setPaymentCommerceTermEntryId(
			this.<Long>getColumnOriginalValue("paymentCommerceTermEntryId"));
		commerceOrderImpl.setShippingAddressId(
			this.<Long>getColumnOriginalValue("shippingAddressId"));
		commerceOrderImpl.setAdvanceStatus(
			this.<String>getColumnOriginalValue("advanceStatus"));
		commerceOrderImpl.setCommercePaymentMethodKey(
			this.<String>getColumnOriginalValue("commercePaymentMethodKey"));
		commerceOrderImpl.setCouponCode(
			this.<String>getColumnOriginalValue("couponCode"));
		commerceOrderImpl.setDeliveryCommerceTermEntryDescription(
			this.<String>getColumnOriginalValue(
				"deliveryCTermEntryDescription"));
		commerceOrderImpl.setDeliveryCommerceTermEntryName(
			this.<String>getColumnOriginalValue(
				"deliveryCommerceTermEntryName"));
		commerceOrderImpl.setLastPriceUpdateDate(
			this.<Date>getColumnOriginalValue("lastPriceUpdateDate"));
		commerceOrderImpl.setManuallyAdjusted(
			this.<Boolean>getColumnOriginalValue("manuallyAdjusted"));
		commerceOrderImpl.setOrderDate(
			this.<Date>getColumnOriginalValue("orderDate"));
		commerceOrderImpl.setOrderStatus(
			this.<Integer>getColumnOriginalValue("orderStatus"));
		commerceOrderImpl.setPaymentCommerceTermEntryDescription(
			this.<String>getColumnOriginalValue(
				"paymentCTermEntryDescription"));
		commerceOrderImpl.setPaymentCommerceTermEntryName(
			this.<String>getColumnOriginalValue(
				"paymentCommerceTermEntryName"));
		commerceOrderImpl.setPaymentStatus(
			this.<Integer>getColumnOriginalValue("paymentStatus"));
		commerceOrderImpl.setPrintedNote(
			this.<String>getColumnOriginalValue("printedNote"));
		commerceOrderImpl.setPurchaseOrderNumber(
			this.<String>getColumnOriginalValue("purchaseOrderNumber"));
		commerceOrderImpl.setRequestedDeliveryDate(
			this.<Date>getColumnOriginalValue("requestedDeliveryDate"));
		commerceOrderImpl.setShippable(
			this.<Boolean>getColumnOriginalValue("shippable"));
		commerceOrderImpl.setShippingAmount(
			this.<BigDecimal>getColumnOriginalValue("shippingAmount"));
		commerceOrderImpl.setShippingDiscountAmount(
			this.<BigDecimal>getColumnOriginalValue("shippingDiscountAmount"));
		commerceOrderImpl.setShippingDiscountPercentageLevel1(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPercentLevel1"));
		commerceOrderImpl.setShippingDiscountPercentageLevel2(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPercentLevel2"));
		commerceOrderImpl.setShippingDiscountPercentageLevel3(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPercentLevel3"));
		commerceOrderImpl.setShippingDiscountPercentageLevel4(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPercentLevel4"));
		commerceOrderImpl.setShippingDiscountPercentageLevel1WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPctLev1WithTax"));
		commerceOrderImpl.setShippingDiscountPercentageLevel2WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPctLev2WithTax"));
		commerceOrderImpl.setShippingDiscountPercentageLevel3WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPctLev3WithTax"));
		commerceOrderImpl.setShippingDiscountPercentageLevel4WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountPctLev4WithTax"));
		commerceOrderImpl.setShippingDiscountWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"shippingDiscountWithTaxAmount"));
		commerceOrderImpl.setShippingOptionName(
			this.<String>getColumnOriginalValue("shippingOptionName"));
		commerceOrderImpl.setShippingWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("shippingWithTaxAmount"));
		commerceOrderImpl.setSubtotal(
			this.<BigDecimal>getColumnOriginalValue("subtotal"));
		commerceOrderImpl.setSubtotalDiscountAmount(
			this.<BigDecimal>getColumnOriginalValue("subtotalDiscountAmount"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPercentLevel1"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPercentLevel2"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPercentLevel3"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPercentLevel4"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPctLev1WithTax"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPctLev2WithTax"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPctLev3WithTax"));
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountPctLev4WithTax"));
		commerceOrderImpl.setSubtotalDiscountWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"subtotalDiscountWithTaxAmount"));
		commerceOrderImpl.setSubtotalWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("subtotalWithTaxAmount"));
		commerceOrderImpl.setTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("taxAmount"));
		commerceOrderImpl.setTotal(
			this.<BigDecimal>getColumnOriginalValue("total"));
		commerceOrderImpl.setTotalDiscountAmount(
			this.<BigDecimal>getColumnOriginalValue("totalDiscountAmount"));
		commerceOrderImpl.setTotalDiscountPercentageLevel1(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPercentageLevel1"));
		commerceOrderImpl.setTotalDiscountPercentageLevel2(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPercentageLevel2"));
		commerceOrderImpl.setTotalDiscountPercentageLevel3(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPercentageLevel3"));
		commerceOrderImpl.setTotalDiscountPercentageLevel4(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPercentageLevel4"));
		commerceOrderImpl.setTotalDiscountPercentageLevel1WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPctLev1WithTax"));
		commerceOrderImpl.setTotalDiscountPercentageLevel2WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPctLev2WithTax"));
		commerceOrderImpl.setTotalDiscountPercentageLevel3WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPctLev3WithTax"));
		commerceOrderImpl.setTotalDiscountPercentageLevel4WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountPctLev4WithTax"));
		commerceOrderImpl.setTotalDiscountWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"totalDiscountWithTaxAmount"));
		commerceOrderImpl.setTotalWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("totalWithTaxAmount"));
		commerceOrderImpl.setTransactionId(
			this.<String>getColumnOriginalValue("transactionId"));
		commerceOrderImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		commerceOrderImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		commerceOrderImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		commerceOrderImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return commerceOrderImpl;
	}

	@Override
	public int compareTo(CommerceOrder commerceOrder) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrder.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceOrder)) {
			return false;
		}

		CommerceOrder commerceOrder = (CommerceOrder)object;

		long primaryKey = commerceOrder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;
	}

	@Override
	public CacheModel<CommerceOrder> toCacheModel() {
		CommerceOrderCacheModel commerceOrderCacheModel =
			new CommerceOrderCacheModel();

		commerceOrderCacheModel.mvccVersion = getMvccVersion();

		commerceOrderCacheModel.uuid = getUuid();

		String uuid = commerceOrderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceOrderCacheModel.uuid = null;
		}

		commerceOrderCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderCacheModel.externalReferenceCode = null;
		}

		commerceOrderCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderCacheModel.groupId = getGroupId();

		commerceOrderCacheModel.companyId = getCompanyId();

		commerceOrderCacheModel.userId = getUserId();

		commerceOrderCacheModel.userName = getUserName();

		String userName = commerceOrderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.billingAddressId = getBillingAddressId();

		commerceOrderCacheModel.commerceAccountId = getCommerceAccountId();

		commerceOrderCacheModel.commerceCurrencyId = getCommerceCurrencyId();

		commerceOrderCacheModel.commerceOrderTypeId = getCommerceOrderTypeId();

		commerceOrderCacheModel.commerceShippingMethodId =
			getCommerceShippingMethodId();

		commerceOrderCacheModel.deliveryCommerceTermEntryId =
			getDeliveryCommerceTermEntryId();

		commerceOrderCacheModel.paymentCommerceTermEntryId =
			getPaymentCommerceTermEntryId();

		commerceOrderCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderCacheModel.advanceStatus = getAdvanceStatus();

		String advanceStatus = commerceOrderCacheModel.advanceStatus;

		if ((advanceStatus != null) && (advanceStatus.length() == 0)) {
			commerceOrderCacheModel.advanceStatus = null;
		}

		commerceOrderCacheModel.commercePaymentMethodKey =
			getCommercePaymentMethodKey();

		String commercePaymentMethodKey =
			commerceOrderCacheModel.commercePaymentMethodKey;

		if ((commercePaymentMethodKey != null) &&
			(commercePaymentMethodKey.length() == 0)) {

			commerceOrderCacheModel.commercePaymentMethodKey = null;
		}

		commerceOrderCacheModel.couponCode = getCouponCode();

		String couponCode = commerceOrderCacheModel.couponCode;

		if ((couponCode != null) && (couponCode.length() == 0)) {
			commerceOrderCacheModel.couponCode = null;
		}

		commerceOrderCacheModel.deliveryCommerceTermEntryDescription =
			getDeliveryCommerceTermEntryDescription();

		String deliveryCommerceTermEntryDescription =
			commerceOrderCacheModel.deliveryCommerceTermEntryDescription;

		if ((deliveryCommerceTermEntryDescription != null) &&
			(deliveryCommerceTermEntryDescription.length() == 0)) {

			commerceOrderCacheModel.deliveryCommerceTermEntryDescription = null;
		}

		commerceOrderCacheModel.deliveryCommerceTermEntryName =
			getDeliveryCommerceTermEntryName();

		String deliveryCommerceTermEntryName =
			commerceOrderCacheModel.deliveryCommerceTermEntryName;

		if ((deliveryCommerceTermEntryName != null) &&
			(deliveryCommerceTermEntryName.length() == 0)) {

			commerceOrderCacheModel.deliveryCommerceTermEntryName = null;
		}

		Date lastPriceUpdateDate = getLastPriceUpdateDate();

		if (lastPriceUpdateDate != null) {
			commerceOrderCacheModel.lastPriceUpdateDate =
				lastPriceUpdateDate.getTime();
		}
		else {
			commerceOrderCacheModel.lastPriceUpdateDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.manuallyAdjusted = isManuallyAdjusted();

		Date orderDate = getOrderDate();

		if (orderDate != null) {
			commerceOrderCacheModel.orderDate = orderDate.getTime();
		}
		else {
			commerceOrderCacheModel.orderDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.orderStatus = getOrderStatus();

		commerceOrderCacheModel.paymentCommerceTermEntryDescription =
			getPaymentCommerceTermEntryDescription();

		String paymentCommerceTermEntryDescription =
			commerceOrderCacheModel.paymentCommerceTermEntryDescription;

		if ((paymentCommerceTermEntryDescription != null) &&
			(paymentCommerceTermEntryDescription.length() == 0)) {

			commerceOrderCacheModel.paymentCommerceTermEntryDescription = null;
		}

		commerceOrderCacheModel.paymentCommerceTermEntryName =
			getPaymentCommerceTermEntryName();

		String paymentCommerceTermEntryName =
			commerceOrderCacheModel.paymentCommerceTermEntryName;

		if ((paymentCommerceTermEntryName != null) &&
			(paymentCommerceTermEntryName.length() == 0)) {

			commerceOrderCacheModel.paymentCommerceTermEntryName = null;
		}

		commerceOrderCacheModel.paymentStatus = getPaymentStatus();

		commerceOrderCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderCacheModel.printedNote = null;
		}

		commerceOrderCacheModel.purchaseOrderNumber = getPurchaseOrderNumber();

		String purchaseOrderNumber =
			commerceOrderCacheModel.purchaseOrderNumber;

		if ((purchaseOrderNumber != null) &&
			(purchaseOrderNumber.length() == 0)) {

			commerceOrderCacheModel.purchaseOrderNumber = null;
		}

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.shippable = isShippable();

		commerceOrderCacheModel.shippingAmount = getShippingAmount();

		commerceOrderCacheModel.shippingDiscountAmount =
			getShippingDiscountAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1 =
			getShippingDiscountPercentageLevel1();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2 =
			getShippingDiscountPercentageLevel2();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3 =
			getShippingDiscountPercentageLevel3();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4 =
			getShippingDiscountPercentageLevel4();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1WithTaxAmount =
			getShippingDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2WithTaxAmount =
			getShippingDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3WithTaxAmount =
			getShippingDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4WithTaxAmount =
			getShippingDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountWithTaxAmount =
			getShippingDiscountWithTaxAmount();

		commerceOrderCacheModel.shippingOptionName = getShippingOptionName();

		String shippingOptionName = commerceOrderCacheModel.shippingOptionName;

		if ((shippingOptionName != null) &&
			(shippingOptionName.length() == 0)) {

			commerceOrderCacheModel.shippingOptionName = null;
		}

		commerceOrderCacheModel.shippingWithTaxAmount =
			getShippingWithTaxAmount();

		commerceOrderCacheModel.subtotal = getSubtotal();

		commerceOrderCacheModel.subtotalDiscountAmount =
			getSubtotalDiscountAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1 =
			getSubtotalDiscountPercentageLevel1();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2 =
			getSubtotalDiscountPercentageLevel2();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3 =
			getSubtotalDiscountPercentageLevel3();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4 =
			getSubtotalDiscountPercentageLevel4();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1WithTaxAmount =
			getSubtotalDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2WithTaxAmount =
			getSubtotalDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3WithTaxAmount =
			getSubtotalDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4WithTaxAmount =
			getSubtotalDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountWithTaxAmount =
			getSubtotalDiscountWithTaxAmount();

		commerceOrderCacheModel.subtotalWithTaxAmount =
			getSubtotalWithTaxAmount();

		commerceOrderCacheModel.taxAmount = getTaxAmount();

		commerceOrderCacheModel.total = getTotal();

		commerceOrderCacheModel.totalDiscountAmount = getTotalDiscountAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel1 =
			getTotalDiscountPercentageLevel1();

		commerceOrderCacheModel.totalDiscountPercentageLevel2 =
			getTotalDiscountPercentageLevel2();

		commerceOrderCacheModel.totalDiscountPercentageLevel3 =
			getTotalDiscountPercentageLevel3();

		commerceOrderCacheModel.totalDiscountPercentageLevel4 =
			getTotalDiscountPercentageLevel4();

		commerceOrderCacheModel.totalDiscountPercentageLevel1WithTaxAmount =
			getTotalDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel2WithTaxAmount =
			getTotalDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel3WithTaxAmount =
			getTotalDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel4WithTaxAmount =
			getTotalDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.totalDiscountWithTaxAmount =
			getTotalDiscountWithTaxAmount();

		commerceOrderCacheModel.totalWithTaxAmount = getTotalWithTaxAmount();

		commerceOrderCacheModel.transactionId = getTransactionId();

		String transactionId = commerceOrderCacheModel.transactionId;

		if ((transactionId != null) && (transactionId.length() == 0)) {
			commerceOrderCacheModel.transactionId = null;
		}

		commerceOrderCacheModel.status = getStatus();

		commerceOrderCacheModel.statusByUserId = getStatusByUserId();

		commerceOrderCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceOrderCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceOrderCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceOrderCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceOrderCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceOrderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CommerceOrder)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrder>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceOrder.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceOrderId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _billingAddressId;
	private long _commerceAccountId;
	private long _commerceCurrencyId;
	private long _commerceOrderTypeId;
	private long _commerceShippingMethodId;
	private long _deliveryCommerceTermEntryId;
	private long _paymentCommerceTermEntryId;
	private long _shippingAddressId;
	private String _advanceStatus;
	private String _commercePaymentMethodKey;
	private String _couponCode;
	private String _deliveryCommerceTermEntryDescription;
	private String _deliveryCommerceTermEntryName;
	private Date _lastPriceUpdateDate;
	private boolean _manuallyAdjusted;
	private Date _orderDate;
	private int _orderStatus;
	private String _paymentCommerceTermEntryDescription;
	private String _paymentCommerceTermEntryName;
	private int _paymentStatus;
	private String _printedNote;
	private String _purchaseOrderNumber;
	private Date _requestedDeliveryDate;
	private boolean _shippable;
	private BigDecimal _shippingAmount;
	private BigDecimal _shippingDiscountAmount;
	private BigDecimal _shippingDiscountPercentageLevel1;
	private BigDecimal _shippingDiscountPercentageLevel2;
	private BigDecimal _shippingDiscountPercentageLevel3;
	private BigDecimal _shippingDiscountPercentageLevel4;
	private BigDecimal _shippingDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel4WithTaxAmount;
	private BigDecimal _shippingDiscountWithTaxAmount;
	private String _shippingOptionName;
	private BigDecimal _shippingWithTaxAmount;
	private BigDecimal _subtotal;
	private BigDecimal _subtotalDiscountAmount;
	private BigDecimal _subtotalDiscountPercentageLevel1;
	private BigDecimal _subtotalDiscountPercentageLevel2;
	private BigDecimal _subtotalDiscountPercentageLevel3;
	private BigDecimal _subtotalDiscountPercentageLevel4;
	private BigDecimal _subtotalDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel4WithTaxAmount;
	private BigDecimal _subtotalDiscountWithTaxAmount;
	private BigDecimal _subtotalWithTaxAmount;
	private BigDecimal _taxAmount;
	private BigDecimal _total;
	private BigDecimal _totalDiscountAmount;
	private BigDecimal _totalDiscountPercentageLevel1;
	private BigDecimal _totalDiscountPercentageLevel2;
	private BigDecimal _totalDiscountPercentageLevel3;
	private BigDecimal _totalDiscountPercentageLevel4;
	private BigDecimal _totalDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel4WithTaxAmount;
	private BigDecimal _totalDiscountWithTaxAmount;
	private BigDecimal _totalWithTaxAmount;
	private String _transactionId;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceOrder, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceOrder)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceOrderId", _commerceOrderId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("billingAddressId", _billingAddressId);
		_columnOriginalValues.put("commerceAccountId", _commerceAccountId);
		_columnOriginalValues.put("commerceCurrencyId", _commerceCurrencyId);
		_columnOriginalValues.put("commerceOrderTypeId", _commerceOrderTypeId);
		_columnOriginalValues.put(
			"commerceShippingMethodId", _commerceShippingMethodId);
		_columnOriginalValues.put(
			"deliveryCommerceTermEntryId", _deliveryCommerceTermEntryId);
		_columnOriginalValues.put(
			"paymentCommerceTermEntryId", _paymentCommerceTermEntryId);
		_columnOriginalValues.put("shippingAddressId", _shippingAddressId);
		_columnOriginalValues.put("advanceStatus", _advanceStatus);
		_columnOriginalValues.put(
			"commercePaymentMethodKey", _commercePaymentMethodKey);
		_columnOriginalValues.put("couponCode", _couponCode);
		_columnOriginalValues.put(
			"deliveryCTermEntryDescription",
			_deliveryCommerceTermEntryDescription);
		_columnOriginalValues.put(
			"deliveryCommerceTermEntryName", _deliveryCommerceTermEntryName);
		_columnOriginalValues.put("lastPriceUpdateDate", _lastPriceUpdateDate);
		_columnOriginalValues.put("manuallyAdjusted", _manuallyAdjusted);
		_columnOriginalValues.put("orderDate", _orderDate);
		_columnOriginalValues.put("orderStatus", _orderStatus);
		_columnOriginalValues.put(
			"paymentCTermEntryDescription",
			_paymentCommerceTermEntryDescription);
		_columnOriginalValues.put(
			"paymentCommerceTermEntryName", _paymentCommerceTermEntryName);
		_columnOriginalValues.put("paymentStatus", _paymentStatus);
		_columnOriginalValues.put("printedNote", _printedNote);
		_columnOriginalValues.put("purchaseOrderNumber", _purchaseOrderNumber);
		_columnOriginalValues.put(
			"requestedDeliveryDate", _requestedDeliveryDate);
		_columnOriginalValues.put("shippable", _shippable);
		_columnOriginalValues.put("shippingAmount", _shippingAmount);
		_columnOriginalValues.put(
			"shippingDiscountAmount", _shippingDiscountAmount);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel1", _shippingDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel2", _shippingDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel3", _shippingDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel4", _shippingDiscountPercentageLevel4);
		_columnOriginalValues.put(
			"shippingDiscountPctLev1WithTax",
			_shippingDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev2WithTax",
			_shippingDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev3WithTax",
			_shippingDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev4WithTax",
			_shippingDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountWithTaxAmount", _shippingDiscountWithTaxAmount);
		_columnOriginalValues.put("shippingOptionName", _shippingOptionName);
		_columnOriginalValues.put(
			"shippingWithTaxAmount", _shippingWithTaxAmount);
		_columnOriginalValues.put("subtotal", _subtotal);
		_columnOriginalValues.put(
			"subtotalDiscountAmount", _subtotalDiscountAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel1", _subtotalDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel2", _subtotalDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel3", _subtotalDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel4", _subtotalDiscountPercentageLevel4);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev1WithTax",
			_subtotalDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev2WithTax",
			_subtotalDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev3WithTax",
			_subtotalDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev4WithTax",
			_subtotalDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountWithTaxAmount", _subtotalDiscountWithTaxAmount);
		_columnOriginalValues.put(
			"subtotalWithTaxAmount", _subtotalWithTaxAmount);
		_columnOriginalValues.put("taxAmount", _taxAmount);
		_columnOriginalValues.put("total", _total);
		_columnOriginalValues.put("totalDiscountAmount", _totalDiscountAmount);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel1", _totalDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel2", _totalDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel3", _totalDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel4", _totalDiscountPercentageLevel4);
		_columnOriginalValues.put(
			"totalDiscountPctLev1WithTax",
			_totalDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev2WithTax",
			_totalDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev3WithTax",
			_totalDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev4WithTax",
			_totalDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountWithTaxAmount", _totalDiscountWithTaxAmount);
		_columnOriginalValues.put("totalWithTaxAmount", _totalWithTaxAmount);
		_columnOriginalValues.put("transactionId", _transactionId);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"deliveryCTermEntryDescription",
			"deliveryCommerceTermEntryDescription");
		attributeNames.put(
			"paymentCTermEntryDescription",
			"paymentCommerceTermEntryDescription");
		attributeNames.put(
			"shippingDiscountPercentLevel1",
			"shippingDiscountPercentageLevel1");
		attributeNames.put(
			"shippingDiscountPercentLevel2",
			"shippingDiscountPercentageLevel2");
		attributeNames.put(
			"shippingDiscountPercentLevel3",
			"shippingDiscountPercentageLevel3");
		attributeNames.put(
			"shippingDiscountPercentLevel4",
			"shippingDiscountPercentageLevel4");
		attributeNames.put(
			"shippingDiscountPctLev1WithTax",
			"shippingDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev2WithTax",
			"shippingDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev3WithTax",
			"shippingDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev4WithTax",
			"shippingDiscountPercentageLevel4WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPercentLevel1",
			"subtotalDiscountPercentageLevel1");
		attributeNames.put(
			"subtotalDiscountPercentLevel2",
			"subtotalDiscountPercentageLevel2");
		attributeNames.put(
			"subtotalDiscountPercentLevel3",
			"subtotalDiscountPercentageLevel3");
		attributeNames.put(
			"subtotalDiscountPercentLevel4",
			"subtotalDiscountPercentageLevel4");
		attributeNames.put(
			"subtotalDiscountPctLev1WithTax",
			"subtotalDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev2WithTax",
			"subtotalDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev3WithTax",
			"subtotalDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev4WithTax",
			"subtotalDiscountPercentageLevel4WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev1WithTax",
			"totalDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev2WithTax",
			"totalDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev3WithTax",
			"totalDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev4WithTax",
			"totalDiscountPercentageLevel4WithTaxAmount");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;
	private CommerceOrder _escapedModel;

}