/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressRestrictionLocalService;
import com.liferay.commerce.service.base.CommerceShippingMethodServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceShippingMethod"}, service={AopService.class})
public class CommerceShippingMethodServiceImpl
extends CommerceShippingMethodServiceBaseImpl {
    @Reference
    private CommerceAddressRestrictionLocalService _commerceAddressRestrictionLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannel)")
    private ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission;

    public CommerceAddressRestriction addCommerceAddressRestriction(long groupId, long commerceShippingMethodId, long countryId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.addCommerceAddressRestriction(this.getUserId(), groupId, commerceShippingMethodId, countryId);
    }

    @Deprecated
    public CommerceAddressRestriction addCommerceAddressRestriction(long commerceShippingMethodId, long countryId, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingMethodService.addCommerceAddressRestriction(serviceContext.getScopeGroupId(), commerceShippingMethodId, countryId);
    }

    public CommerceShippingMethod addCommerceShippingMethod(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String engineKey, File imageFile, double priority, String trackingURL) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.addCommerceShippingMethod(this.getUserId(), groupId, nameMap, descriptionMap, active, engineKey, imageFile, priority, trackingURL);
    }

    public CommerceShippingMethod createCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        }
        return this.commerceShippingMethodLocalService.createCommerceShippingMethod(commerceShippingMethodId);
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        CommerceAddressRestriction commerceAddressRestriction = this._commerceAddressRestrictionLocalService.getCommerceAddressRestriction(commerceAddressRestrictionId);
        this._checkCommerceChannel(commerceAddressRestriction.getGroupId());
        this.commerceShippingMethodLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    public void deleteCommerceAddressRestrictions(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethodId);
    }

    public void deleteCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
    }

    public CommerceShippingMethod fetchCommerceShippingMethod(long groupId, String engineKey) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(groupId, engineKey);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        }
        return commerceShippingMethod;
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.getCommerceAddressRestrictions(commerceShippingMethodId, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.getCommerceAddressRestrictionsCount(commerceShippingMethodId);
    }

    public CommerceShippingMethod getCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return commerceShippingMethod;
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, boolean active, int start, int end, OrderByComparator<CommerceShippingMethod> orderByComparator) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, int start, int end, OrderByComparator<CommerceShippingMethod> orderByComparator) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId, start, end, orderByComparator);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, long countryId, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethods(groupId, countryId, active);
    }

    public int getCommerceShippingMethodsCount(long groupId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commerceShippingMethodLocalService.getCommerceShippingMethodsCount(groupId);
    }

    public CommerceShippingMethod setActive(long commerceShippingMethodId, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod != null) {
            this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        }
        return this.commerceShippingMethodLocalService.setActive(commerceShippingMethodId, active);
    }

    public CommerceShippingMethod updateCommerceShippingMethod(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, File imageFile, double priority, String trackingURL) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
        this._checkCommerceChannel(commerceShippingMethod.getGroupId());
        return this.commerceShippingMethodLocalService.updateCommerceShippingMethod(commerceShippingMethod.getCommerceShippingMethodId(), nameMap, descriptionMap, active, imageFile, priority, trackingURL);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        this._commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

