/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration"}, service={CommerceOrderItemQuantityFormatter.class})
public class CommerceOrderItemQuantityFormatterImpl
implements CommerceOrderItemQuantityFormatter {
    private volatile CommerceOrderItemDecimalQuantityConfiguration _commerceOrderItemDecimalQuantityConfiguration;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;

    public String format(CommerceOrderItem commerceOrderItem, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, Locale locale) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = commerceOrderItem.fetchCPMeasurementUnit();
        DecimalFormat decimalFormat = this._getDecimalFormat(locale);
        BigDecimal quantity = commerceOrderItem.getQuantity();
        if (cpMeasurementUnit != null) {
            return StringBundler.concat((String[])new String[]{decimalFormat.format(quantity), " ", cpMeasurementUnit.getName(locale)});
        }
        if (cpInstanceUnitOfMeasure != null) {
            return String.valueOf(quantity.setScale(cpInstanceUnitOfMeasure.getPrecision(), RoundingMode.HALF_UP));
        }
        return decimalFormat.format(quantity);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderItemDecimalQuantityConfiguration = (CommerceOrderItemDecimalQuantityConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderItemDecimalQuantityConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._commerceOrderItemDecimalQuantityConfiguration = null;
    }

    private DecimalFormat _getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00", DecimalFormatSymbols.getInstance(locale));
        decimalFormat.setMaximumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.maximumFractionDigits());
        decimalFormat.setMinimumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.minimumFractionDigits());
        decimalFormat.setRoundingMode(this._commerceOrderItemDecimalQuantityConfiguration.roundingMode());
        return decimalFormat;
    }
}

