/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.commerce.util.CommerceAccountRoleHelper;
import com.liferay.portal.db.partition.DBPartitionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceAccountRoleHelper.class})
public class CommerceAccountRoleHelperImpl
implements CommerceAccountRoleHelper {
    private static final String[] _SUPPLIER_CONTROL_PANEL_PORTLET_IDS = new String[]{"com_liferay_commerce_order_web_internal_portlet_CommerceOrderPortlet", "com_liferay_commerce_pricing_web_internal_portlet_CommercePriceListPortlet", "com_liferay_commerce_pricing_web_internal_portlet_CommercePromotionPortlet", "com_liferay_commerce_catalog_web_internal_portlet_CommerceCatalogsPortlet", "com_liferay_commerce_channel_web_internal_portlet_CommerceChannelsPortlet", "com_liferay_commerce_product_definitions_web_internal_portlet_CPDefinitionsPortlet"};
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void checkCommerceAccountRoles(ServiceContext serviceContext) throws PortalException {
        this._checkAccountRole("Account Administrator", serviceContext);
        this._checkAccountRole("Buyer", serviceContext);
        this._checkAccountRole("Order Manager", serviceContext);
        if (FeatureFlagManagerUtil.isEnabled((String)"COMMERCE-10890")) {
            this._checkAccountRole("Account Supplier", serviceContext);
            this._checkRole("Supplier", serviceContext);
        }
    }

    private void _checkAccountRole(String name, ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            AccountRole accountRole = this._accountRoleLocalService.addAccountRole(serviceContext.getUserId(), 0L, name, Collections.singletonMap(serviceContext.getLocale(), name), Collections.emptyMap());
            role = accountRole.getRole();
            this._setRolePermissions(role, serviceContext);
        }
        if ("Account Administrator".equals(name)) {
            this._setRolePermissions(role, serviceContext);
        }
    }

    private void _checkRole(String name, ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            role = this._roleLocalService.addRole(serviceContext.getUserId(), null, 0L, name, Collections.singletonMap(serviceContext.getLocale(), name), Collections.emptyMap(), 1, null, serviceContext);
            this._setRolePermissions(role, serviceContext);
        }
    }

    private void _setRolePermissions(long companyId, String primaryKey, Map<String, String[]> resourceActionIds, Role role, int scope) throws PortalException {
        for (Map.Entry<String, String[]> entry : resourceActionIds.entrySet()) {
            try {
                DBPartitionUtil.forEachCompanyId(company -> this._resourceActionLocalService.checkResourceActions((String)entry.getKey(), Arrays.asList((Object[])entry.getValue())));
            }
            catch (Exception exception) {
                throw new PortalException((Throwable)exception);
            }
            for (String actionId : entry.getValue()) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, entry.getKey(), scope, primaryKey, role.getRoleId(), actionId);
            }
        }
    }

    private void _setRolePermissions(Role role, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String[]> companyResourceActionIds = new HashMap<String, String[]>();
        HashMap<String, String[]> groupResourceActionIds = new HashMap<String, String[]>();
        String name = role.getName();
        if (name.equals("Account Administrator")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"MANAGE_ADDRESSES", "ASSIGN_USERS", "UPDATE", "VIEW", "VIEW_ADDRESSES", "VIEW_USERS"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "APPROVE_OPEN_COMMERCE_ORDERS", "CHECKOUT_OPEN_COMMERCE_ORDERS", "DELETE_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "MANAGE_COMMERCE_ORDERS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Buyer")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"MANAGE_ADDRESSES", "VIEW_ADDRESSES"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "CHECKOUT_OPEN_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Order Manager")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "APPROVE_OPEN_COMMERCE_ORDERS", "CHECKOUT_OPEN_COMMERCE_ORDERS", "DELETE_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "MANAGE_COMMERCE_ORDERS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Supplier")) {
            for (String portletId : _SUPPLIER_CONTROL_PANEL_PORTLET_IDS) {
                companyResourceActionIds.put(portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
            }
            companyResourceActionIds.put("90", new String[]{"VIEW_CONTROL_PANEL"});
            companyResourceActionIds.put("com.liferay.commerce.catalog", new String[]{"ADD_COMMERCE_CATALOG"});
            companyResourceActionIds.put("com.liferay.commerce.channel", new String[]{"VIEW_COMMERCE_NOTIFICATION_QUEUE_ENTRIES", "ADD_COMMERCE_NOTIFICATION_TEMPLATE"});
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.order", new String[]{"MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_NOTES", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_PRICES", "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS"});
            companyResourceActionIds.put("com.liferay.commerce.price.list", new String[]{"ADD_COMMERCE_PRICE_LIST"});
            companyResourceActionIds.put("com.liferay.commerce.pricing", new String[]{"ADD_COMMERCE_PRICING_CLASS"});
            companyResourceActionIds.put("com.liferay.commerce.pricing.model.CommercePricingClass", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.product", new String[]{"ADD_COMMERCE_PRODUCT_OPTION", "ADD_COMMERCE_PRODUCT_SPECIFICATION_OPTION", "MANAGE_COMMERCE_PRODUCT_ATTACHMENTS", "MANAGE_COMMERCE_PRODUCT_IMAGES", "MANAGE_COMMERCE_PRODUCT_MEASUREMENT_UNITS", "VIEW_COMMERCE_PRODUCT_ATTACHMENTS", "VIEW_COMMERCE_PRODUCT_IMAGES"});
            companyResourceActionIds.put("com.liferay.commerce.shipment", new String[]{"MANAGE_COMMERCE_SHIPMENTS"});
            companyResourceActionIds.put("com.liferay.commerce.tax", new String[]{"VIEW_COMMERCE_PRODUCT_TAX_CATEGORIES"});
        }
        this._setRolePermissions(serviceContext.getCompanyId(), String.valueOf(serviceContext.getCompanyId()), companyResourceActionIds, role, 1);
        this._setRolePermissions(serviceContext.getCompanyId(), String.valueOf(0L), groupResourceActionIds, role, 3);
    }
}

