/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=15", "commerce.order.status.priority:Integer=60"}, service={CommerceOrderStatus.class})
public class ShippedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 15;
    public static final int PRIORITY = 60;
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(15);
        if (!this._commerceShippingHelper.isShippable(commerceOrder)) {
            commerceOrder = this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 0, userId, secure);
        }
        commerceOrder = secure ? this._commerceOrderService.updateCommerceOrder(commerceOrder) : this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return commerceOrder;
    }

    public int getKey() {
        return 15;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)15));
    }

    public int getPriority() {
        return 60;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return commerceOrder.getOrderStatus() == 15 || commerceOrder.getOrderStatus() == 0;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        return !commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        boolean allOrderItemsShipped = true;
        for (CommerceOrderItem shippedCommerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (!BigDecimalUtil.lt((BigDecimal)shippedCommerceOrderItem.getShippedQuantity(), (BigDecimal)shippedCommerceOrderItem.getQuantity()) || !shippedCommerceOrderItem.isShippable()) continue;
            allOrderItemsShipped = false;
        }
        return (commerceOrder.getOrderStatus() == 10 || commerceOrder.getOrderStatus() == 14) && allOrderItemsShipped;
    }

    public boolean isValidForOrder(CommerceOrder commerceOrder) throws PortalException {
        return this._commerceShippingHelper.isShippable(commerceOrder);
    }
}

