/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CPInstanceUnitOfMeasureModelListener
extends BaseModelListener<CPInstanceUnitOfMeasure> {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;

    public void onAfterCreate(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) {
        int cpInstanceUnitOfMeasuresCount = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasuresCount(cpInstanceUnitOfMeasure.getCPInstanceId());
        if (cpInstanceUnitOfMeasuresCount != 1) {
            return;
        }
        this._updateUnitOfMeasureKey(cpInstanceUnitOfMeasure.getCPInstanceId(), cpInstanceUnitOfMeasure.getIncrementalOrderQuantity(), cpInstanceUnitOfMeasure.getKey(), null, "");
    }

    public void onAfterUpdate(CPInstanceUnitOfMeasure originalCPInstanceUnitOfMeasure, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) throws ModelListenerException {
        String key = cpInstanceUnitOfMeasure.getKey();
        if (key.equals(originalCPInstanceUnitOfMeasure.getKey()) && BigDecimalUtil.eq((BigDecimal)cpInstanceUnitOfMeasure.getIncrementalOrderQuantity(), (BigDecimal)originalCPInstanceUnitOfMeasure.getIncrementalOrderQuantity())) {
            return;
        }
        int cpInstanceUnitOfMeasuresCount = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasuresCount(cpInstanceUnitOfMeasure.getCPInstanceId());
        if (cpInstanceUnitOfMeasuresCount != 1) {
            return;
        }
        this._updateUnitOfMeasureKey(originalCPInstanceUnitOfMeasure.getCPInstanceId(), cpInstanceUnitOfMeasure.getIncrementalOrderQuantity(), cpInstanceUnitOfMeasure.getKey(), originalCPInstanceUnitOfMeasure.getIncrementalOrderQuantity(), originalCPInstanceUnitOfMeasure.getKey());
    }

    private void _updateUnitOfMeasureKey(long cpInstanceId, BigDecimal incrementalOrderQuantity, String key, BigDecimal originalIncrementalOrderQuantity, String originalKey) {
        int[] orderStatuses = ArrayUtil.append((int[][])new int[][]{CommerceOrderConstants.ORDER_STATUSES_OPEN, CommerceOrderConstants.ORDER_STATUSES_PENDING, CommerceOrderConstants.ORDER_STATUSES_PROCESSING, CommerceOrderConstants.ORDER_STATUSES_SHIPPING});
        for (CommerceOrderItem commerceOrderItem : this._commerceOrderItemLocalService.getCommerceOrderItems(cpInstanceId, orderStatuses, originalKey, -1, -1)) {
            BigDecimal quantity = commerceOrderItem.getQuantity();
            if (BigDecimalUtil.gt((BigDecimal)originalIncrementalOrderQuantity, (BigDecimal)BigDecimal.ZERO)) {
                quantity = quantity.divide(originalIncrementalOrderQuantity, RoundingMode.HALF_UP);
            }
            commerceOrderItem.setQuantity(quantity.multiply(incrementalOrderQuantity));
            commerceOrderItem.setUnitOfMeasureKey(key);
            this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
        }
    }
}

