/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.constants.CPDefinitionInventoryConstants;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDAvailabilityEstimateLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"cp.definition.inventory.engine.key=default", "cp.definition.inventory.engine.priority:Integer=1"}, service={CPDefinitionInventoryEngine.class})
public class CPDefinitionInventoryEngineImpl
implements CPDefinitionInventoryEngine {
    public static final String KEY = "default";
    @Reference
    private CPDAvailabilityEstimateLocalService _cpdAvailabilityEstimateLocalService;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private Language _language;

    public String[] getAllowedOrderQuantities(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return new String[0];
        }
        return ArrayUtil.toStringArray((Object[])cpDefinitionInventory.getAllowedOrderQuantitiesArray());
    }

    public String getAvailabilityEstimate(CPInstance cpInstance, Locale locale) throws PortalException {
        CPDAvailabilityEstimate cpDefinitionAvailabilityEstimate = this._cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionAvailabilityEstimate == null) {
            return "";
        }
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = cpDefinitionAvailabilityEstimate.getCommerceAvailabilityEstimate();
        if (commerceAvailabilityEstimate == null) {
            return "";
        }
        return commerceAvailabilityEstimate.getTitle(locale);
    }

    public String getKey() {
        return KEY;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, KEY);
    }

    public BigDecimal getMaxOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return CPDefinitionInventoryConstants.DEFAULT_MAX_ORDER_QUANTITY;
        }
        return cpDefinitionInventory.getMaxOrderQuantity();
    }

    public BigDecimal getMinOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return CPDefinitionInventoryConstants.DEFAULT_MIN_ORDER_QUANTITY;
        }
        return cpDefinitionInventory.getMinOrderQuantity();
    }

    public BigDecimal getMinStockQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return BigDecimal.ZERO;
        }
        return cpDefinitionInventory.getMinStockQuantity();
    }

    public BigDecimal getMultipleOrderQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return CPDefinitionInventoryConstants.DEFAULT_MULTIPLE_ORDER_QUANTITY;
        }
        return cpDefinitionInventory.getMultipleOrderQuantity();
    }

    public boolean isBackOrderAllowed(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.isBackOrders();
    }

    public boolean isDisplayAvailability(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.isDisplayAvailability();
    }

    public boolean isDisplayStockQuantity(CPInstance cpInstance) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        if (cpDefinitionInventory == null) {
            return false;
        }
        return cpDefinitionInventory.isDisplayStockQuantity();
    }
}

