/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CommerceInventoryChecker;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceInventoryChecker<T>
implements CommerceInventoryChecker<T> {
    @Reference
    protected CommerceInventoryEngine commerceInventoryEngine;
    @Reference
    protected CPDefinitionInventoryEngine cpDefinitionInventoryEngine;
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceInventoryChecker.class);

    protected boolean isAvailable(CPInstance cpInstance, BigDecimal quantity) {
        if (cpInstance == null) {
            return false;
        }
        return this.isBackOrderAllowed(cpInstance) || this.commerceInventoryEngine.hasStockQuantity(cpInstance.getCompanyId(), cpInstance.getGroupId(), quantity, cpInstance.getSku(), "");
    }

    protected boolean isBackOrderAllowed(CPInstance cpInstance) {
        try {
            if (this.cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
                return true;
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to check is back order allowed", (Throwable)portalException);
        }
        return false;
    }
}

