create table CPDAvailabilityEstimate (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	CPDAvailabilityEstimateId LONG not null primary key,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	commerceAvailabilityEstimateId LONG,
	CProductId LONG,
	lastPublishDate DATE null
);

create table CPDefinitionInventory (
	mvccVersion LONG default 0 not null,
	ctCollectionId LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	CPDefinitionInventoryId LONG not null,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	CPDefinitionId LONG,
	CPDefinitionInventoryEngine VARCHAR(75) null,
	lowStockActivity VARCHAR(75) null,
	displayAvailability BOOLEAN,
	displayStockQuantity BOOLEAN,
	minStockQuantity INTEGER,
	backOrders BOOLEAN,
	minOrderQuantity INTEGER,
	maxOrderQuantity INTEGER,
	allowedOrderQuantities VARCHAR(75) null,
	multipleOrderQuantity INTEGER,
	primary key (CPDefinitionInventoryId, ctCollectionId)
);

create table CSOptionAccountEntryRel (
	mvccVersion LONG default 0 not null,
	CSOptionAccountEntryRelId LONG not null primary key,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	accountEntryId LONG,
	commerceChannelId LONG,
	commerceShippingMethodKey VARCHAR(75) null,
	commerceShippingOptionKey VARCHAR(75) null
);

create table CommerceAddressRestriction (
	mvccVersion LONG default 0 not null,
	commerceAddressRestrictionId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	classNameId LONG,
	classPK LONG,
	countryId LONG
);

create table CommerceAvailabilityEstimate (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	commerceAvailabilityEstimateId LONG not null primary key,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	title STRING null,
	priority DOUBLE,
	lastPublishDate DATE null
);

create table CommerceOrder (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceOrderId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	billingAddressId LONG,
	commerceAccountId LONG,
	commerceCurrencyId LONG,
	commerceOrderTypeId LONG,
	commerceShippingMethodId LONG,
	deliveryCommerceTermEntryId LONG,
	paymentCommerceTermEntryId LONG,
	shippingAddressId LONG,
	advanceStatus VARCHAR(75) null,
	commercePaymentMethodKey VARCHAR(75) null,
	couponCode VARCHAR(75) null,
	deliveryCTermEntryDescription TEXT null,
	deliveryCommerceTermEntryName VARCHAR(75) null,
	lastPriceUpdateDate DATE null,
	manuallyAdjusted BOOLEAN,
	orderDate DATE null,
	orderStatus INTEGER,
	paymentCTermEntryDescription TEXT null,
	paymentCommerceTermEntryName VARCHAR(75) null,
	paymentStatus INTEGER,
	printedNote STRING null,
	purchaseOrderNumber VARCHAR(75) null,
	requestedDeliveryDate DATE null,
	shippingAmount DECIMAL(30, 16) null,
	shippingDiscountAmount DECIMAL(30, 16) null,
	shippingDiscountPercentLevel1 DECIMAL(30, 16) null,
	shippingDiscountPercentLevel2 DECIMAL(30, 16) null,
	shippingDiscountPercentLevel3 DECIMAL(30, 16) null,
	shippingDiscountPercentLevel4 DECIMAL(30, 16) null,
	shippingDiscountPctLev1WithTax DECIMAL(30, 16) null,
	shippingDiscountPctLev2WithTax DECIMAL(30, 16) null,
	shippingDiscountPctLev3WithTax DECIMAL(30, 16) null,
	shippingDiscountPctLev4WithTax DECIMAL(30, 16) null,
	shippingDiscountWithTaxAmount DECIMAL(30, 16) null,
	shippingOptionName VARCHAR(255) null,
	shippingWithTaxAmount DECIMAL(30, 16) null,
	subtotal DECIMAL(30, 16) null,
	subtotalDiscountAmount DECIMAL(30, 16) null,
	subtotalDiscountPercentLevel1 DECIMAL(30, 16) null,
	subtotalDiscountPercentLevel2 DECIMAL(30, 16) null,
	subtotalDiscountPercentLevel3 DECIMAL(30, 16) null,
	subtotalDiscountPercentLevel4 DECIMAL(30, 16) null,
	subtotalDiscountPctLev1WithTax DECIMAL(30, 16) null,
	subtotalDiscountPctLev2WithTax DECIMAL(30, 16) null,
	subtotalDiscountPctLev3WithTax DECIMAL(30, 16) null,
	subtotalDiscountPctLev4WithTax DECIMAL(30, 16) null,
	subtotalDiscountWithTaxAmount DECIMAL(30, 16) null,
	subtotalWithTaxAmount DECIMAL(30, 16) null,
	taxAmount DECIMAL(30, 16) null,
	total DECIMAL(30, 16) null,
	totalDiscountAmount DECIMAL(30, 16) null,
	totalDiscountPercentageLevel1 DECIMAL(30, 16) null,
	totalDiscountPercentageLevel2 DECIMAL(30, 16) null,
	totalDiscountPercentageLevel3 DECIMAL(30, 16) null,
	totalDiscountPercentageLevel4 DECIMAL(30, 16) null,
	totalDiscountPctLev1WithTax DECIMAL(30, 16) null,
	totalDiscountPctLev2WithTax DECIMAL(30, 16) null,
	totalDiscountPctLev3WithTax DECIMAL(30, 16) null,
	totalDiscountPctLev4WithTax DECIMAL(30, 16) null,
	totalDiscountWithTaxAmount DECIMAL(30, 16) null,
	totalWithTaxAmount DECIMAL(30, 16) null,
	transactionId TEXT null,
	status INTEGER,
	statusByUserId LONG,
	statusByUserName VARCHAR(75) null,
	statusDate DATE null
);

create table CommerceOrderItem (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceOrderItemId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	bookedQuantityId LONG,
	commerceOrderId LONG,
	commercePriceListId LONG,
	CPInstanceId LONG,
	CPMeasurementUnitId LONG,
	CProductId LONG,
	customerCommerceOrderItemId LONG,
	parentCommerceOrderItemId LONG,
	shippingAddressId LONG,
	decimalQuantity DECIMAL(30, 16) null,
	deliveryGroup VARCHAR(75) null,
	deliveryMaxSubscriptionCycles LONG,
	deliverySubscriptionLength INTEGER,
	deliverySubscriptionType VARCHAR(75) null,
	deliverySubTypeSettings VARCHAR(75) null,
	depth DOUBLE,
	discountAmount DECIMAL(30, 16) null,
	discountManuallyAdjusted BOOLEAN,
	discountPercentageLevel1 DECIMAL(30, 16) null,
	discountPercentageLevel2 DECIMAL(30, 16) null,
	discountPercentageLevel3 DECIMAL(30, 16) null,
	discountPercentageLevel4 DECIMAL(30, 16) null,
	discountPctLevel1WithTaxAmount DECIMAL(30, 16) null,
	discountPctLevel2WithTaxAmount DECIMAL(30, 16) null,
	discountPctLevel3WithTaxAmount DECIMAL(30, 16) null,
	discountPctLevel4WithTaxAmount DECIMAL(30, 16) null,
	discountWithTaxAmount DECIMAL(30, 16) null,
	finalPrice DECIMAL(30, 16) null,
	finalPriceWithTaxAmount DECIMAL(30, 16) null,
	freeShipping BOOLEAN,
	height DOUBLE,
	json TEXT null,
	manuallyAdjusted BOOLEAN,
	maxSubscriptionCycles LONG,
	name STRING null,
	priceManuallyAdjusted BOOLEAN,
	priceOnApplication BOOLEAN,
	printedNote STRING null,
	promoPrice DECIMAL(30, 16) null,
	promoPriceWithTaxAmount DECIMAL(30, 16) null,
	quantity INTEGER,
	replacedCPInstanceId LONG,
	replacedSku VARCHAR(75) null,
	requestedDeliveryDate DATE null,
	shipSeparately BOOLEAN,
	shippable BOOLEAN,
	shippedQuantity INTEGER,
	shippingExtraPrice DOUBLE,
	sku VARCHAR(75) null,
	subscription BOOLEAN,
	subscriptionLength INTEGER,
	subscriptionType VARCHAR(75) null,
	subscriptionTypeSettings VARCHAR(75) null,
	unitOfMeasureKey VARCHAR(75) null,
	unitPrice DECIMAL(30, 16) null,
	unitPriceWithTaxAmount DECIMAL(30, 16) null,
	weight DOUBLE,
	width DOUBLE
);

create table CommerceOrderNote (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceOrderNoteId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	commerceOrderId LONG,
	content STRING null,
	restricted BOOLEAN
);

create table CommerceOrderPayment (
	mvccVersion LONG default 0 not null,
	commerceOrderPaymentId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	commerceOrderId LONG,
	commercePaymentMethodKey VARCHAR(75) null,
	content TEXT null,
	status INTEGER
);

create table CommerceOrderType (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceOrderTypeId LONG not null primary key,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	name STRING null,
	description STRING null,
	active_ BOOLEAN,
	displayDate DATE null,
	displayOrder INTEGER,
	expirationDate DATE null,
	lastPublishDate DATE null,
	status INTEGER,
	statusByUserId LONG,
	statusByUserName VARCHAR(75) null,
	statusDate DATE null
);

create table CommerceOrderTypeRel (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceOrderTypeRelId LONG not null primary key,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	classNameId LONG,
	classPK LONG,
	commerceOrderTypeId LONG
);

create table CommerceShipment (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceShipmentId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	commerceAccountId LONG,
	commerceAddressId LONG,
	commerceShippingMethodId LONG,
	carrier VARCHAR(75) null,
	expectedDate DATE null,
	shippingDate DATE null,
	shippingOptionName TEXT null,
	trackingNumber VARCHAR(75) null,
	trackingURL STRING null,
	status INTEGER
);

create table CommerceShipmentItem (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	externalReferenceCode VARCHAR(75) null,
	commerceShipmentItemId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	commerceShipmentId LONG,
	commerceOrderItemId LONG,
	commerceInventoryWarehouseId LONG,
	quantity INTEGER
);

create table CommerceShippingMethod (
	mvccVersion LONG default 0 not null,
	commerceShippingMethodId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	name STRING null,
	description STRING null,
	active_ BOOLEAN,
	engineKey VARCHAR(75) null,
	imageId LONG,
	priority DOUBLE,
	trackingURL STRING null
);

create table CommerceSubscriptionEntry (
	mvccVersion LONG default 0 not null,
	uuid_ VARCHAR(75) null,
	commerceSubscriptionEntryId LONG not null primary key,
	groupId LONG,
	companyId LONG,
	userId LONG,
	userName VARCHAR(75) null,
	createDate DATE null,
	modifiedDate DATE null,
	CPInstanceUuid VARCHAR(75) null,
	CProductId LONG,
	commerceOrderItemId LONG,
	subscriptionLength INTEGER,
	subscriptionType VARCHAR(75) null,
	subscriptionTypeSettings TEXT null,
	currentCycle LONG,
	maxSubscriptionCycles LONG,
	subscriptionStatus INTEGER,
	lastIterationDate DATE null,
	nextIterationDate DATE null,
	startDate DATE null,
	deliverySubscriptionLength INTEGER,
	deliverySubscriptionType VARCHAR(75) null,
	deliverySubTypeSettings VARCHAR(75) null,
	deliveryCurrentCycle LONG,
	deliveryMaxSubscriptionCycles LONG,
	deliverySubscriptionStatus INTEGER,
	deliveryLastIterationDate DATE null,
	deliveryNextIterationDate DATE null,
	deliveryStartDate DATE null
);